/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.actions;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.event.ReferencedObjectRefactoredEvent;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.base.EventHandler;
import com.sap.ide.metamodel.webdynpro.component.controller.Action;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.enum.ActionTypeEnum;
import com.sap.ide.webdynpro.controllereditor.AbstractControllerTableModel;
import com.sap.ide.webdynpro.controllereditor.actions.ActionEditDialog;
import com.sap.ide.webdynpro.controllereditor.wizards.action.CreateActionWizardDialog;
import com.sap.ide.webdynpro.controllereditor.wizards.action.RenameActionWizard;
import com.sap.ide.webdynpro.service.controllereditor.ControllerPasteManager;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.action.ActionService;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectNameComparator;
import com.sap.ide.webdynpro.service.core.MessageDialogWithCheckBoxes;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizard;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizardDialog;
import java.util.Arrays;
import org.eclipse.ui.PlatformUI;

public class ActionsTableModel
extends AbstractControllerTableModel {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final int NUMBER_OF_COLUMNS = 4;
    private static final String[] COLUMN_NAMES = new String[]{mTextPool.getText(34), mTextPool.getText(555), mTextPool.getText(35), mTextPool.getText(562)};
    private static final Class[] COLUMN_CLASSES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ActionsTableModel.class$("java.lang.String")) : class$java$lang$String, class$org$eclipse$swt$widgets$Button == null ? (class$org$eclipse$swt$widgets$Button = ActionsTableModel.class$("org.eclipse.swt.widgets.Button")) : class$org$eclipse$swt$widgets$Button, class$java$lang$String == null ? (class$java$lang$String = ActionsTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ActionsTableModel.class$("java.lang.String")) : class$java$lang$String};
    private static final int[] COLUMN_WIDTHS = new int[]{Integer.MAX_VALUE, 16, Integer.MAX_VALUE, Integer.MAX_VALUE};
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_BEFORE_VALIDATION = 1;
    public static final int COLUMN_EVENT_HANDLER = 2;
    public static final int COLUMN_TEXT = 3;
    private Action[] mActions = null;
    RefactoringObserver mRefactoringObserver = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$eclipse$swt$widgets$Button;

    public ActionsTableModel(Controller controller) {
        super(controller);
        this.setNumberOfColumns(4);
        this.setColumnNames(COLUMN_NAMES);
        this.setColumnClasses(COLUMN_CLASSES);
        this.updateDataTable();
        this.getController().attachChildrenObserver((DevelopmentObjectObserver)this);
        this.mRefactoringObserver = new RefactoringObserver();
        this.getController().attachChildrenObserver((DevelopmentObjectObserver)this.mRefactoringObserver);
    }

    public DevelopmentObject getDataTableEntry(int index) {
        if (index < 0 | index > this.mActions.length) {
            return null;
        }
        return this.mActions[index];
    }

    protected int getNumberOfElementsInDataTable() {
        return this.mActions.length;
    }

    protected void masterObjectChanged(DevelopmentObject newMasterObject) {
        super.masterObjectChanged(newMasterObject);
    }

    protected void updateDataTable() {
        if (this.getController() != null) {
            this.mActions = this.getController().getActions();
            Arrays.sort(this.mActions, new DevelopmentObjectNameComparator());
        }
    }

    public int getRowCount() {
        if (this.mActions == null) {
            return 0;
        }
        return this.mActions.length;
    }

    public int[] getColumnWidths() {
        return COLUMN_WIDTHS;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.mActions.length <= rowIndex) {
            return AbstractControllerTableModel.ERROR;
        }
        Action action = this.mActions[rowIndex];
        if (action == null) {
            return AbstractControllerTableModel.ERROR;
        }
        switch (columnIndex) {
            case 0: {
                return action.getName();
            }
            case 1: {
                return new Boolean(action.getType().equals(ActionTypeEnum.BEFORE_VALIDATION));
            }
            case 2: {
                if (action.getEventHandler() == null) {
                    return "";
                }
                return action.getEventHandler().getName();
            }
            case 3: {
                if (action.getText() == null) {
                    return "";
                }
                return action.getText();
            }
        }
        return AbstractControllerTableModel.ERROR;
    }

    protected void doNew() {
        MMRepositoryObject[] repositoryObjects = ActionService.getRepositoryObjectsAffectedByActionCreation((Controller)this.getController());
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        CreateActionWizardDialog dialog = new CreateActionWizardDialog(this.getController());
        dialog.open();
        dialog.close();
    }

    protected void doRename(int[] indexes) {
        Action[] actions = this.getIndexesActions(indexes);
        int i = 0;
        while (i < actions.length) {
            Action action = actions[i];
            MMRepositoryObject[] repositoryObjects = ActionService.getRepositoryObjectsAffectedByActionModification((Action)action);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            RenameActionWizard renameWizard = new RenameActionWizard((DevelopmentObject)action);
            RenameWizardDialog wizardDialog = new RenameWizardDialog((RenameWizard)renameWizard);
            wizardDialog.open();
            wizardDialog.close();
            ++i;
        }
    }

    protected void doDelete(int[] indexes) {
        Action[] actions = this.getIndexesActions(indexes);
        boolean userSaidDeleteAll = false;
        int result = -1;
        boolean deleteEventHandler = false;
        int i = 0;
        while (i < actions.length) {
            Action action = actions[i];
            MMRepositoryObject[] repositoryObjects = ActionService.getRepositoryObjectsAffectedByActionDeletion((Action)action);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            if (!userSaidDeleteAll) {
                String[] buttons = new String[]{mCoreTextPool.getText(150), mCoreTextPool.getText(164), mCoreTextPool.getText(151)};
                String[] questions = new String[]{mTextPool.getText(170)};
                boolean[] questionDefaultValues = new boolean[]{true};
                MessageDialogWithCheckBoxes dialog = new MessageDialogWithCheckBoxes(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), mCoreTextPool.getText(400, (Object)mTextPool.getText(10)), null, mCoreTextPool.getText(401, (Object)mTextPool.getText(10), (Object)action.getName()), 3, buttons, 2, questions, questionDefaultValues);
                result = dialog.open();
                dialog.close();
                if (result == 1) {
                    userSaidDeleteAll = true;
                    result = 0;
                }
                deleteEventHandler = dialog.getAnswers()[0];
            }
            if (result == 0) {
                ActionService.deleteAction((Controller)this.getController(), (Action)action, (boolean)deleteEventHandler);
            }
            ++i;
        }
    }

    protected void doEdit(int[] indexes) {
        Action[] actions = this.getIndexesActions(indexes);
        int i = 0;
        while (i < actions.length) {
            Action action = actions[i];
            MMRepositoryObject[] repositoryObjects = ActionService.getRepositoryObjectsAffectedByActionModification((Action)action);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            ActionEditDialog dialog = new ActionEditDialog(action, 1);
            if (dialog.open() == 0) {
                ActionService.editAction((Action)action, (String)dialog.getNewText(), (String)dialog.getNewEventHandlerName(), (boolean)dialog.getNewBeforeValidation());
            }
            ++i;
        }
    }

    protected void doCopy(MetamodelClipboard clipboard, int[] indexes) {
        Action[] actions = this.getIndexesActions(indexes);
        clipboard.copy((DevelopmentObject[])actions);
    }

    protected void doPaste(MetamodelClipboard clipboard) {
        MMRepositoryObject[] repositoryObjects = ActionService.getRepositoryObjectsAffectedByActionCreation((Controller)this.getController());
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        ControllerPasteManager controllerPasteManager = new ControllerPasteManager();
        controllerPasteManager.paste(clipboard, (MetamodelObject)this.getController());
    }

    protected boolean canPaste(MetamodelClipboard clipboard) {
        DevelopmentObjectEnum[] objects = clipboard.getContentTypes();
        int i = 0;
        while (i < objects.length) {
            if (!objects[i].equals(WebDynproDevelopmentObjectEnum.ACTION)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isReadOnly() {
        return this.getController().originatesInArchive();
    }

    public boolean isCutable(int[] indexes) {
        return false;
    }

    protected boolean isEventRelevant(MetamodelEvent event) {
        if (event.getModifiedObject() instanceof Action || event.getModifiedObject() instanceof EventHandler) {
            switch (event.getEventId()) {
                case 1: 
                case 2: 
                case 4: 
                case 64: 
                case 128: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public void tableModelDisposed() {
        super.tableModelDisposed();
        this.getController().detachChildrenObserver((DevelopmentObjectObserver)this);
        this.getController().detachChildrenObserver((DevelopmentObjectObserver)this.mRefactoringObserver);
    }

    private Action[] getIndexesActions(int[] indexes) {
        Action[] actions = new Action[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            actions[i] = this.mActions[indexes[i]];
            ++i;
        }
        return actions;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RefactoringObserver
    implements DevelopmentObjectObserver {
        private RefactoringObserver() {
        }

        public void update(MetamodelEvent event) {
            MetamodelEvent[] events = new MetamodelEvent[]{event};
            this.update(events);
        }

        public void update(MetamodelEvent[] events) {
            int i = 0;
            while (i < events.length) {
                if (events[i] instanceof ReferencedObjectRefactoredEvent) {
                    ActionsTableModel.this.fireTableDataChanged();
                    break;
                }
                ++i;
            }
        }
    }
}

