/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.actions;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.component.controller.Action;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.AbstractControllerTableModel;
import com.sap.ide.webdynpro.controllereditor.parameters.ParameterEditDialog;
import com.sap.ide.webdynpro.controllereditor.parameters.ParametersTableModel;
import com.sap.ide.webdynpro.controllereditor.wizards.action.CreateActionParameterWizardDialog;
import com.sap.ide.webdynpro.controllereditor.wizards.action.RenameActionParameterWizard;
import com.sap.ide.webdynpro.service.controllereditor.action.ActionService;
import com.sap.ide.webdynpro.service.controllereditor.parameter.ParameterService;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.MessageDialogWithCheckBoxes;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizard;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizardDialog;
import org.eclipse.ui.PlatformUI;

public class ActionParametersTableModel
extends ParametersTableModel {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();

    public ActionParametersTableModel(Controller controller) {
        super(controller);
    }

    protected void doNew() {
        if (this.mSelectedParent == null) {
            return;
        }
        Action action = (Action)this.mSelectedParent;
        MMRepositoryObject[] repositoryObjects = ActionService.getRepositoryObjectsAffectedByActionParameterCreation((Action)action);
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        CreateActionParameterWizardDialog dialog = new CreateActionParameterWizardDialog(action, null);
        dialog.open();
        dialog.close();
    }

    protected void doDelete(int[] indexes) {
        if (this.mSelectedParent == null) {
            return;
        }
        Action action = (Action)this.mSelectedParent;
        Parameter[] parameters = this.getIndexesParameters(indexes);
        boolean userSaidDeleteAll = false;
        int result = -1;
        int i = 0;
        while (i < parameters.length) {
            Parameter actionParameter = parameters[i];
            MMRepositoryObject[] repositoryObjects = ActionService.getRepositoryObjectsAffectedByActionParameterDeletion((Parameter)actionParameter);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            String[] buttons = new String[]{mCoreTextPool.getText(150), mCoreTextPool.getText(164), mCoreTextPool.getText(151)};
            String[] questions = new String[]{AbstractControllerTableModel.mTextPool.getText(171)};
            boolean[] questionsDefaultValues = new boolean[]{true};
            MessageDialogWithCheckBoxes dialog = new MessageDialogWithCheckBoxes(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), mCoreTextPool.getText(400, (Object)AbstractControllerTableModel.mTextPool.getText(11)), null, mCoreTextPool.getText(401, (Object)AbstractControllerTableModel.mTextPool.getText(11), (Object)actionParameter.getName()), 3, buttons, 2, questions, questionsDefaultValues);
            if (!userSaidDeleteAll) {
                result = dialog.open();
                dialog.close();
                if (result == 1) {
                    userSaidDeleteAll = true;
                    result = 0;
                }
            }
            if (result == 0) {
                boolean deleteEventHandlerParameter = dialog.getAnswers()[0];
                ActionService.deleteActionParameter((Action)action, (Parameter)actionParameter, (boolean)deleteEventHandlerParameter);
            }
            ++i;
        }
    }

    protected void doEdit(int[] indexes) {
        if (this.mSelectedParent == null) {
            return;
        }
        Action action = (Action)this.mSelectedParent;
        Parameter[] parameters = this.getIndexesParameters(indexes);
        int i = 0;
        while (i < parameters.length) {
            Parameter actionParameter = parameters[i];
            MMRepositoryObject[] repositoryObjects = ActionService.getRepositoryObjectsAffectedByActionParameterModification((Parameter)actionParameter);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            ParameterEditDialog dialog = new ParameterEditDialog(actionParameter, this.getController(), 1, AbstractControllerTableModel.mTextPool.getText(169), false);
            if (dialog.open() == 0) {
                ActionService.editActionParameter((Action)action, (Parameter)actionParameter, (DevelopmentObject)dialog.getNewParameterType(), (MetamodelServices.CompoundType)dialog.getNewParameterTypeAsCompoundType(), (boolean)dialog.isAdaptSubObject());
            }
            ++i;
        }
    }

    protected void doRename(int[] indexes) {
        Parameter[] parameters = this.getIndexesParameters(indexes);
        int i = 0;
        while (i < indexes.length) {
            Parameter parameter = parameters[i];
            MMRepositoryObject[] repositoryObjects = ParameterService.getRepositoryObjectsAffectedByParameterModification((Parameter)parameter);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            RenameActionParameterWizard renameWizard = new RenameActionParameterWizard((DevelopmentObject)parameter);
            RenameWizardDialog wizardDialog = new RenameWizardDialog((RenameWizard)renameWizard);
            wizardDialog.open();
            wizardDialog.close();
            ++i;
        }
    }

    protected boolean isReadOnly() {
        return this.getController().originatesInArchive() || !this.isModifiedParentObjectRelevant((DevelopmentObject)this.mSelectedParent);
    }

    protected boolean isModifiedParentObjectRelevant(DevelopmentObject object) {
        return object instanceof Action;
    }
}

