/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.actions;

import com.sap.ide.metamodel.webdynpro.base.EventHandler;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.navigation.OutboundPlug;
import com.sap.ide.metamodel.webdynpro.component.view.AbstractView;
import com.sap.ide.webdynpro.controllereditor.EditUI;
import com.sap.ide.webdynpro.controllereditor.IDialogWithButtonAccess;
import com.sap.ide.webdynpro.controllereditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.controllereditor.eventhandlers.EventHandlerSubObjectEditUI;
import com.sap.ide.webdynpro.controllereditor.wizards.action.CreateActionWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.plug.CreateOutboundPlugWizardDialog;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.action.ActionService;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectNameComparator;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import java.util.Arrays;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class ActionEditUI
extends EditUI {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    private Controller mController = null;
    private IDialogWithButtonAccess mDialog = null;
    private CreateActionWizardData mData = null;
    private int mMode;
    private Text mNameField = null;
    private Text mTextField = null;
    private Button mBeforeValidationField = null;
    private EventHandlerSubObjectEditUI mSubUI = null;
    private Combo mFirePlugField = null;
    private Button mNewPlugButton = null;

    public ActionEditUI(CreateActionWizardData data, int mode, Controller controller, IDisplayErrorListener displayErrorListener, IDialogWithButtonAccess dialog) {
        super(displayErrorListener);
        this.mData = data;
        this.mMode = mode;
        this.mController = controller;
        this.mDialog = dialog;
    }

    public void initUI(IGridLayoutPane glp) {
        glp.addTextLabel(mTextPool.getText(103));
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, false);
        this.mNameField = glp.addTextField(this.mData.getName(), this.mMode == 1, gd);
        this.mNameField.addModifyListener((ModifyListener)new NameModifyListener());
        glp.addPlaceholder();
        glp.addTextLabel(mTextPool.getText(563));
        gd = glp.createGridLayoutData(4, 4, true, false);
        this.mTextField = glp.addTextField(this.mData.getText(), false, gd);
        this.mTextField.addModifyListener((ModifyListener)new TextModifyListener());
        glp.addPlaceholder();
        glp.addTextLabel(mTextPool.getText(557));
        gd = glp.createGridLayoutData(4, 4, true, false);
        this.mBeforeValidationField = glp.addCheckBox("", this.mData.getBeforeValidation(), gd);
        this.mBeforeValidationField.addSelectionListener((SelectionListener)new BeforeValidationSelectionListener());
        ExistingEventHandlerSelectionListener existingEventHandlerSelectionListener = new ExistingEventHandlerSelectionListener(this.getDisplayErrorListener());
        this.mBeforeValidationField.addSelectionListener((SelectionListener)existingEventHandlerSelectionListener);
        glp.addPlaceholder();
        glp.addHorizontalSeparator();
        this.mSubUI = new EventHandlerSubObjectEditUI(this.mController, this.mData, this.mMode, this.getDisplayErrorListener(), false, this.mDialog);
        this.mSubUI.initUI(glp, 3);
        this.mSubUI.getExistingEventHandlerCombo().addSelectionListener((SelectionListener)existingEventHandlerSelectionListener);
        if (this.mMode == 0) {
            glp.addHorizontalSeparator();
            glp.addTextLabel("Fire plug");
            gd = glp.createGridLayoutData(4, 4, true, false);
            String[] entries = new String[]{"<None>"};
            AbstractView view = this.mController.getView();
            if (view != null) {
                OutboundPlug[] plugs = view.getOutboundPlugs();
                Arrays.sort(plugs, new DevelopmentObjectNameComparator());
                entries = new String[plugs.length + 1];
                entries[0] = "<None>";
                int i = 0;
                while (i < plugs.length) {
                    entries[i + 1] = plugs[i].getName();
                    ++i;
                }
            }
            this.mFirePlugField = glp.addComboBox(entries, entries[0], true, gd);
            this.mFirePlugField.addSelectionListener((SelectionListener)new FirePlugSelectionListener());
            gd = glp.createGridLayoutData(4, 4, true, false);
            this.mNewPlugButton = glp.addPushButton(mCoreTextPool.getText(152));
            this.mNewPlugButton.addSelectionListener((SelectionListener)new NewPlugButtonSelectionListener());
        }
        this.getDisplayErrorListener().setErrorMessage("");
    }

    private boolean validatePage() {
        String error = null;
        if (this.mMode != 1) {
            error = ActionService.isNewActionNameValid((String)this.mNameField.getText(), (Controller)this.mController, (this.mData.getSelectedEventHandlerIndex() == -1 ? 1 : 0) != 0);
            this.getDisplayErrorListener().setErrorMessage(error);
        }
        return error == null;
    }

    public void setVisible(boolean visible) {
        this.mNameField.setFocus();
    }

    private class NewPlugButtonSelectionListener
    implements SelectionListener {
        private NewPlugButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            AbstractView view = ActionEditUI.this.mController.getView();
            if (view != null) {
                CreateOutboundPlugWizardDialog dialog = new CreateOutboundPlugWizardDialog(view);
                dialog.open();
                OutboundPlug plug = dialog.getNewOutboundPlug();
                ActionEditUI.this.mData.setPlugToFire(plug);
                OutboundPlug[] plugs = view.getOutboundPlugs();
                Arrays.sort(plugs, new DevelopmentObjectNameComparator());
                String[] entries = new String[plugs.length + 1];
                entries[0] = "<None>";
                int index = 0;
                int i = 0;
                while (i < plugs.length) {
                    entries[i + 1] = plugs[i].getName();
                    if (plugs[i].equals(plug)) {
                        index = i + 1;
                    }
                    ++i;
                }
                ActionEditUI.this.mFirePlugField.setItems(entries);
                ActionEditUI.this.mFirePlugField.select(index);
                dialog.close();
            }
        }
    }

    private class FirePlugSelectionListener
    implements SelectionListener {
        private FirePlugSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            AbstractView view = ActionEditUI.this.mController.getView();
            if (view != null) {
                OutboundPlug plug = view.getOutboundPlug(ActionEditUI.this.mFirePlugField.getText());
                ActionEditUI.this.mData.setPlugToFire(plug);
            }
        }
    }

    private class ExistingEventHandlerSelectionListener
    implements SelectionListener {
        private IDisplayErrorListener mDisplayErrorListener = null;

        public ExistingEventHandlerSelectionListener(IDisplayErrorListener displayErrorListener) {
            this.mDisplayErrorListener = displayErrorListener;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            String error = ActionService.isEventHandlerValid((EventHandler)ActionEditUI.this.mData.getSelectedEventHandler(), (boolean)ActionEditUI.this.mData.getBeforeValidation());
            this.mDisplayErrorListener.setErrorMessage(error);
        }
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            ActionEditUI.this.validatePage();
            ActionEditUI.this.mData.setText(ActionEditUI.this.mTextField.getText());
        }
    }

    private class BeforeValidationSelectionListener
    implements SelectionListener {
        private BeforeValidationSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            ActionEditUI.this.mData.setBeforeValidation(ActionEditUI.this.mBeforeValidationField.getSelection());
        }
    }

    private class NameModifyListener
    implements ModifyListener {
        private NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            ActionEditUI.this.validatePage();
            ActionEditUI.this.mData.setName(ActionEditUI.this.mNameField.getText());
            String eventHandlerName = ActionService.getEventHandlerName((String)ActionEditUI.this.mNameField.getText());
            ActionEditUI.this.mSubUI.setDefaultEventHandlerName(eventHandlerName);
        }
    }
}

