/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor;

import com.sap.ide.metamodel.webdynpro.services.ServicesEclipse;
import com.sap.ide.webdynpro.controllereditor.ControllerCallback;
import com.sap.ide.webdynpro.controllereditor.ControllerEditorResourceChecker;
import com.sap.ide.webdynpro.controllereditor.actions.ActionCallback;
import com.sap.ide.webdynpro.controllereditor.component.ComponentCallback;
import com.sap.ide.webdynpro.controllereditor.component.ComponentUsageCallback;
import com.sap.ide.webdynpro.controllereditor.context.ContextCallback;
import com.sap.ide.webdynpro.controllereditor.customevents.EventCallback;
import com.sap.ide.webdynpro.controllereditor.plugs.PlugCallback;
import com.sap.ide.webdynpro.controllereditor.wizards.datalink.DataLinkActionCallback;
import com.sap.ide.webdynpro.service.controllereditor.action.ActionCaller;
import com.sap.ide.webdynpro.service.controllereditor.action.IActionCallback;
import com.sap.ide.webdynpro.service.controllereditor.component.ComponentCaller;
import com.sap.ide.webdynpro.service.controllereditor.component.IComponentCallback;
import com.sap.ide.webdynpro.service.controllereditor.context.IContextCallback;
import com.sap.ide.webdynpro.service.controllereditor.context.ui.ContextCaller;
import com.sap.ide.webdynpro.service.controllereditor.controller.ControllerCaller;
import com.sap.ide.webdynpro.service.controllereditor.controller.IControllerCallback;
import com.sap.ide.webdynpro.service.controllereditor.datalink.DataLinkCaller;
import com.sap.ide.webdynpro.service.controllereditor.datalink.IDataLinkCallback;
import com.sap.ide.webdynpro.service.controllereditor.event.EventCaller;
import com.sap.ide.webdynpro.service.controllereditor.event.IEventCallback;
import com.sap.ide.webdynpro.service.controllereditor.plug.IPlugCallback;
import com.sap.ide.webdynpro.service.controllereditor.plug.PlugCaller;
import com.sap.ide.webdynpro.service.controllereditor.usage.ComponentUsageCaller;
import com.sap.ide.webdynpro.service.controllereditor.usage.IComponentUsageCallback;
import com.sap.ide.webdynpro.ui.service.ServicesUI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class Plugin
extends AbstractUIPlugin
implements IStartup {
    private static final String DEBUG_OPTION_CONTEXT_WIZARDS_STATS = "com.sap.ide.webdynpro.controllereditor/debug/context/wizards/tree_statistics";
    private static final String DEBUG_OPTION_CONTEXT_WIZARDS_TREE_DUMP = "com.sap.ide.webdynpro.controllereditor/debug/context/wizards/tree_dump";
    private static Plugin mPlugin;

    public Plugin(IPluginDescriptor descriptor) {
        super(descriptor);
        mPlugin = this;
    }

    public static Plugin getDefault() {
        return mPlugin;
    }

    public static void internalError(Class theClass, String methodName, String message, Throwable e, boolean logOnly) {
        ServicesUI.internalError((Class)theClass, (String)methodName, (String)message, (Throwable)e, (org.eclipse.core.runtime.Plugin)Plugin.getDefault(), (boolean)logOnly);
    }

    public void startup() throws CoreException {
        super.startup();
        ComponentCaller.setComponentCallback((IComponentCallback)new ComponentCallback());
        ControllerCaller.setControllerCallback((IControllerCallback)new ControllerCallback());
        ActionCaller.setActionCallback((IActionCallback)new ActionCallback());
        EventCaller.setEventCallback((IEventCallback)new EventCallback());
        PlugCaller.setPlugCallback((IPlugCallback)new PlugCallback());
        ContextCaller.initialize((IContextCallback)new ContextCallback());
        DataLinkCaller.setDataLinkCallback((IDataLinkCallback)new DataLinkActionCallback());
        ComponentUsageCaller.setComponentUsageCallback((IComponentUsageCallback)new ComponentUsageCallback());
    }

    public void earlyStartup() {
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            public void run() {
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    if (projects[i].isOpen() && ServicesEclipse.projectHasWebDynproNature((String)projects[i].getName())) {
                        ControllerEditorResourceChecker checker = new ControllerEditorResourceChecker(projects[i]);
                        try {
                            projects[i].accept((IResourceVisitor)checker);
                        }
                        catch (CoreException e) {
                            Plugin.internalError(this.getClass(), "earlyStartup()", e.getMessage(), e, true);
                        }
                    }
                    ++i;
                }
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ControllerEditorResourceChecker(null), 1);
            }
        });
    }

    public static boolean isContextWizardTreeDumpEnabled() {
        return Plugin.getDefault().isDebugging() && Plugin.toBoolean(Platform.getDebugOption((String)DEBUG_OPTION_CONTEXT_WIZARDS_TREE_DUMP), false);
    }

    public static boolean isContextWizardTreeStatisticsEnabled() {
        return Plugin.getDefault().isDebugging() && Plugin.toBoolean(Platform.getDebugOption((String)DEBUG_OPTION_CONTEXT_WIZARDS_STATS), false);
    }

    private static boolean toBoolean(String value, boolean defaultValue) {
        return value != null && value.equalsIgnoreCase(Boolean.TRUE.toString()) || defaultValue;
    }
}

