/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor;

import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectNameComparator;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import java.util.Arrays;

public class CreateTypedObjectWizardData {
    private static final String NULL_TYPE_STRING = "void";
    private int mSelectedTypeIndex = 0;
    private String mProjectName = null;
    private DtSimpleType[] mTypes = null;
    private MetamodelServices.CompoundType[] mNativeTypes = null;
    private MetamodelServices.CompoundType mCompoundType = null;
    private boolean mIsArray = false;
    private int mArrayDimension = 0;

    public CreateTypedObjectWizardData(String projectName) {
        this.mProjectName = projectName;
        this.initTypes();
    }

    private void initTypes() {
        this.mTypes = MetamodelServices.getBuiltInScalarTypes((String)this.mProjectName);
        this.mNativeTypes = new MetamodelServices.CompoundType[0];
        Arrays.sort(this.mTypes, new DevelopmentObjectNameComparator());
    }

    public void setTypes(DtSimpleType[] types) {
        this.mTypes = types;
        this.mNativeTypes = new MetamodelServices.CompoundType[0];
        this.mCompoundType = null;
    }

    public void setTypes(DtSimpleType[] types, MetamodelServices.CompoundType[] nativeTypes) {
        this.mTypes = types;
        this.mNativeTypes = nativeTypes;
        this.mCompoundType = null;
    }

    public int getSelectedTypeIndex() {
        if (this.mCompoundType == null) {
            return this.mSelectedTypeIndex;
        }
        return this.mSelectedTypeIndex + 1;
    }

    public DevelopmentObject getSelectedType() {
        if (this.mSelectedTypeIndex > -1) {
            if (this.mSelectedTypeIndex < this.mTypes.length) {
                return this.mTypes[this.mSelectedTypeIndex];
            }
            return null;
        }
        return null;
    }

    public MetamodelServices.CompoundType getSelectedCompoundType() {
        if (this.mSelectedTypeIndex > -1 + this.mTypes.length) {
            if (this.mSelectedTypeIndex - this.mTypes.length < this.mNativeTypes.length) {
                return this.mNativeTypes[this.mSelectedTypeIndex - this.mTypes.length];
            }
            return null;
        }
        return null;
    }

    public MetamodelServices.CompoundType getSelectedTypeAsCompoundType() {
        if (this.mCompoundType != null) {
            return this.mCompoundType;
        }
        if (this.mSelectedTypeIndex < 1) {
            return null;
        }
        return new MetamodelServices.CompoundType(this.mTypes[this.mSelectedTypeIndex]);
    }

    public String[] getTypeNames() {
        int length = this.mTypes.length + this.mNativeTypes.length;
        int start = 0;
        if (this.mCompoundType != null) {
            ++length;
            ++start;
        }
        String[] names = new String[length];
        if (this.mCompoundType != null) {
            names[0] = this.getCompoundTypeName();
        }
        int i = 0;
        while (i < this.mTypes.length) {
            names[i + start] = this.mTypes[i] != null ? this.mTypes[i].getName() : NULL_TYPE_STRING;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.mNativeTypes.length) {
            names[this.mTypes.length + i2 + start] = this.mNativeTypes[i2] != null ? this.mNativeTypes[i2].getQualifiedName() : NULL_TYPE_STRING;
            ++i2;
        }
        return names;
    }

    public String getSelectedTypeName() {
        if (this.mCompoundType != null) {
            return this.getCompoundTypeName();
        }
        if (this.mSelectedTypeIndex > -1) {
            if (this.mSelectedTypeIndex < this.mTypes.length) {
                if (this.mTypes[this.mSelectedTypeIndex] != null) {
                    return this.mTypes[this.mSelectedTypeIndex].getName();
                }
                return NULL_TYPE_STRING;
            }
            if (this.mNativeTypes[this.mSelectedTypeIndex - this.mTypes.length] != null) {
                return this.mNativeTypes[this.mSelectedTypeIndex - this.mTypes.length].getQualifiedName();
            }
            return NULL_TYPE_STRING;
        }
        return "<ERROR>";
    }

    private String getCompoundTypeName() {
        if (this.mCompoundType == null) {
            return "<ERROR>";
        }
        if (this.mCompoundType.isSimpleType()) {
            return this.mCompoundType.getName();
        }
        return this.mCompoundType.getQualifiedName();
    }

    public void setSelectedTypeIndex(int index) {
        int length = this.mTypes.length + this.mNativeTypes.length;
        int start = 0;
        if (this.mCompoundType != null) {
            ++length;
            ++start;
        }
        if (index > -1 + start && index < length) {
            this.mSelectedTypeIndex = index - start;
            this.mCompoundType = null;
        }
    }

    public void setSelectedType(DevelopmentObject type) {
        if (type == null) {
            this.mSelectedTypeIndex = 0;
            this.mCompoundType = null;
        } else {
            int i = 0;
            while (i < this.mTypes.length) {
                if (type.equals(this.mTypes[i])) {
                    this.mSelectedTypeIndex = i;
                    this.mCompoundType = null;
                    return;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.mNativeTypes.length) {
                if (type.equals(this.mNativeTypes[i2])) {
                    this.mSelectedTypeIndex = this.mTypes.length + i2;
                    this.mCompoundType = null;
                    return;
                }
                ++i2;
            }
        }
    }

    public void setSelectedType(MetamodelServices.CompoundType type) {
        int i = 0;
        while (i < this.mNativeTypes.length) {
            if (type.equals((Object)this.mNativeTypes[i])) {
                this.mSelectedTypeIndex = this.mTypes.length + i;
                this.mCompoundType = null;
                return;
            }
            ++i;
        }
        this.mCompoundType = type;
        this.mSelectedTypeIndex = -1;
    }

    public int getArrayDimension() {
        if (this.mIsArray) {
            return this.mArrayDimension;
        }
        return 0;
    }

    public String getArrayDimensionString() {
        if (this.mIsArray) {
            return Integer.toString(this.mArrayDimension);
        }
        return "";
    }

    public void setArrayDimension(int dimension) {
        this.mArrayDimension = dimension;
    }

    public boolean isArray() {
        return this.mIsArray;
    }

    public void setArray(boolean isArray) {
        this.mIsArray = isArray;
        this.mArrayDimension = isArray ? 1 : 0;
    }
}

