/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor;

import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class ControllerPropertyPage
extends PropertySheetPage {
    private static final TextPool mTextPool = TextPool.getInstance();
    public static final int PAGE_TYPE_CONTEXT = 0;
    public static final int PAGE_TYPE_LAYOUT = 1;
    public static final int PAGE_TYPE_OTHERS = 2;
    private PageBook mPageBook = null;
    private IPropertySheetPage mDefaultAdaptor = new PropertySheetPage();
    private IPropertySheetPage mContextAdaptor = null;
    private IPropertySheetPage mLayoutAdaptor = null;
    private Control mDefaultControl = null;
    private Control mContextControl = null;
    private Control mLayoutControl = null;
    private int mActivePage = 0;

    public ControllerPropertyPage(IPropertySheetPage layoutAdaptor, IPropertySheetPage contextAdaptor) {
        this.mLayoutAdaptor = layoutAdaptor;
        this.mContextAdaptor = contextAdaptor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (parent instanceof PageBook) {
            this.mPageBook = (PageBook)parent;
            this.mDefaultAdaptor.createControl(parent);
            this.mDefaultControl = this.mDefaultAdaptor.getControl();
            if (this.mContextAdaptor != null) {
                try {
                    ((IPageBookViewPage)this.mContextAdaptor).init(this.getSite());
                }
                catch (PartInitException e) {
                    Plugin.internalError(((Object)((Object)this)).getClass(), "Failed to initialize PropertyPage for context editor", e.getMessage(), e, false);
                    return;
                }
                this.mContextAdaptor.createControl(parent);
                this.mContextControl = this.mContextAdaptor.getControl();
            }
            if (this.mLayoutAdaptor != null && this.mLayoutAdaptor instanceof PropertySheetPage) {
                try {
                    ((IPageBookViewPage)this.mLayoutAdaptor).init(this.getSite());
                }
                catch (PartInitException e) {
                    Plugin.internalError(((Object)((Object)this)).getClass(), "createControl(Composite)", e.getMessage(), e, false);
                    return;
                }
                this.mLayoutAdaptor.createControl(parent);
                this.mLayoutControl = this.mLayoutAdaptor.getControl();
            }
        }
        if (this.getControl() != null) {
            this.mPageBook.showPage(this.getControl());
        }
    }

    public Control getControl() {
        if (this.mActivePage == 0) {
            return this.mContextControl;
        }
        if (this.mActivePage == 1) {
            return this.mLayoutControl;
        }
        return this.mDefaultControl;
    }

    public void setActivePageType(int page) {
        if ((page == 0 | page == 1 | page == 2) & page != this.mActivePage) {
            this.mActivePage = page;
            Control control = this.getControl();
            if (control != null && !control.isDisposed()) {
                this.mPageBook.showPage(this.getControl());
            }
        }
    }

    public IPropertySheetPage getContextPropertyPage() {
        return this.mContextAdaptor;
    }

    public IPropertySheetPage getLayoutPropertyPage() {
        return this.mLayoutAdaptor;
    }

    public void dispose() {
        super.dispose();
        if (this.mDefaultAdaptor != null) {
            this.mDefaultAdaptor.dispose();
        }
        if (this.mLayoutAdaptor != null) {
            this.mLayoutAdaptor.dispose();
        }
        if (this.mContextAdaptor != null) {
            this.mContextAdaptor.dispose();
        }
    }
}

