/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor;

import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.services.ServicesEclipse;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationFileFindService;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;

public class ControllerEditorResourceChecker
implements IResourceChangeListener,
IResourceDeltaVisitor,
IResourceVisitor {
    public ControllerEditorResourceChecker(IProject project) {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            Plugin.internalError(this.getClass(), "resourceChanged(IResourceChangeEvent)", e.getMessage(), e, false);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IProject project = delta.getResource().getProject();
        if (project == null) {
            return true;
        }
        if (!project.isAccessible()) {
            return false;
        }
        if (!(delta.getResource() instanceof IFile)) {
            return true;
        }
        if (!ServicesEclipse.projectHasWebDynproNature((String)project.getName())) {
            return false;
        }
        if (delta.getKind() == 1 || delta.getKind() == 4) {
            this.setEditor(delta.getResource());
        }
        return true;
    }

    public boolean visit(IResource resource) throws CoreException {
        this.setEditor(resource);
        return true;
    }

    private void setEditor(IResource resource) {
        if (resource instanceof IFile) {
            IFile file;
            Component[] components = null;
            if (resource.getProject() != null) {
                try {
                    components = MetamodelServices.getWebDynproRoot((String)resource.getProject().getName()).getComponents();
                }
                catch (LoadException e) {
                    Plugin.internalError(this.getClass(), "earlyStartup()", e.getMessage(), e, true);
                    return;
                }
            }
            if (ImplementationFileFindService.isControllerImplementationFile((IFile)(file = (IFile)resource), components) != null) {
                IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                registry.setDefaultEditor(file, "com.sap.ide.webdynpro.editors.controller");
            }
        }
    }
}

