/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.editor.IDevelopmentObjectEditor;
import com.sap.ide.metamodel.core.plugin.IMetamodelSaveParticipant;
import com.sap.ide.metamodel.core.plugin.MetamodelHelper;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.base.CustomEvent;
import com.sap.ide.metamodel.webdynpro.base.Procedure;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.controller.Action;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.FieldGroup;
import com.sap.ide.metamodel.webdynpro.component.navigation.InboundPlug;
import com.sap.ide.metamodel.webdynpro.component.navigation.OutboundPlug;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.metamodel.webdynpro.services.ServicesEclipse;
import com.sap.ide.tools.core.patternfwk.editor.ISourcePatternEditor;
import com.sap.ide.tools.core.patternfwk.editor.ISourcePatternTopLevelEditor;
import com.sap.ide.webdynpro.controllereditor.AbstractControllerEditorPage;
import com.sap.ide.webdynpro.controllereditor.ControllerEditorContributor;
import com.sap.ide.webdynpro.controllereditor.ControllerPropertyPage;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.controllereditor.actions.ActionsPage;
import com.sap.ide.webdynpro.controllereditor.context.ContextEditorPart;
import com.sap.ide.webdynpro.controllereditor.customevents.EventsPage;
import com.sap.ide.webdynpro.controllereditor.fieldgroups.FieldGroupsPage;
import com.sap.ide.webdynpro.controllereditor.implementation.JavaImplementationEditor;
import com.sap.ide.webdynpro.controllereditor.methods.MethodsPage;
import com.sap.ide.webdynpro.controllereditor.outline.ControllerOutlinePage;
import com.sap.ide.webdynpro.controllereditor.overview.OverviewPage;
import com.sap.ide.webdynpro.controllereditor.plugs.PlugsPage;
import com.sap.ide.webdynpro.generation.eclipse.GenerationEclipse;
import com.sap.ide.webdynpro.generation.naming.NamingService;
import com.sap.ide.webdynpro.service.controllereditor.ControllerEditorInput;
import com.sap.ide.webdynpro.service.controllereditor.IControllerEditorPart;
import com.sap.ide.webdynpro.service.controllereditor.ServiceControllerEditorPlugin;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.controller.ControllerService;
import com.sap.ide.webdynpro.service.controllereditor.implementation.IJavaImplementationEditor;
import com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationFileFindService;
import com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectEditorInput;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.editor.IDevelopmentObjectMarker;
import com.sap.ide.webdynpro.service.core.editor.source.SourceResolver;
import com.sap.ide.webdynpro.service.viewdesigner.IViewDesignerPart;
import com.sap.ide.webdynpro.service.viewdesigner.ServiceWithUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class ControllerEditorPart
extends MultiPageEditorPart
implements IMetamodelSaveParticipant,
IControllerEditorPart,
ISourcePatternTopLevelEditor,
IDevelopmentObjectEditor {
    private static final TextPool mTextPool = TextPool.getInstance();
    private int mActivePage = -2;
    private ControllerEditorInput mControllerEditorInput = null;
    private JavaImplementationEditor mJavaImplSourceEditor = null;
    private int mJavaImplSourceEditorIndex = -1;
    private ImplementationService mImplementationService = null;
    private EditorPart mLayoutEditor = null;
    private int mLayoutEditorIndex = -1;
    private ContextEditorPart mContextEditor;
    private int mContextEditorIndex = -1;
    private int mOverviewTabIndex = -1;
    private AbstractControllerEditorPage mOverviewPage = null;
    private int mMethodTabIndex = -1;
    private AbstractControllerEditorPage mMethodPage = null;
    private int mPlugTabIndex = -1;
    private AbstractControllerEditorPage mPlugPage = null;
    private int mActionTabIndex = -1;
    private AbstractControllerEditorPage mActionPage = null;
    private int mEventTabIndex = -1;
    private AbstractControllerEditorPage mEventPage = null;
    private int mFieldGroupTabIndex = -1;
    private AbstractControllerEditorPage mFieldGroupPage = null;
    private int mRequestedTab = -1;
    private static final int REQUESTED_TAB_IMPLEMENTATION = 0;
    private static final int REQUESTED_TAB_IMPLEMENTATION_NO_GENERATION = 1;
    private ControllerOutlinePage mOutlinePage;
    private ControllerPropertyPage mPropertySheetPage;
    RefactorObserver mRefactorObserver = null;
    ControllerEditorControlListener mControllerEditorControlListener = null;
    static /* synthetic */ Class class$org$eclipse$ui$views$contentoutline$IContentOutlinePage;
    static /* synthetic */ Class class$org$eclipse$ui$views$properties$IPropertySheetPage;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public void gotoMarker(IMarker marker) {
        if (marker instanceof IDevelopmentObjectMarker) {
            DevelopmentObject object = ((IDevelopmentObjectMarker)marker).getDevelopmentObject();
            int subType = ((IDevelopmentObjectMarker)marker).getSubType();
            this.gotoDevelopmentObject(object, subType);
        } else if (this.mJavaImplSourceEditor != null) {
            this.mJavaImplSourceEditor.gotoMarker(marker);
        }
        this.setFocus();
    }

    private void gotoDevelopmentObject(DevelopmentObject object, int subType) {
        int newPage = this.getActivePage();
        if (subType == 1) {
            newPage = this.mJavaImplSourceEditorIndex;
        } else if (object instanceof Procedure) {
            newPage = this.mMethodTabIndex;
        } else if (object instanceof ContextAttribute) {
            newPage = this.mContextEditorIndex;
        } else if (object instanceof InboundPlug || object instanceof OutboundPlug) {
            newPage = this.mPlugTabIndex;
        } else if (object instanceof Action) {
            newPage = this.mActionTabIndex;
        } else if (object instanceof CustomEvent) {
            newPage = this.mEventTabIndex;
        } else if (object instanceof FieldGroup) {
            newPage = this.mFieldGroupTabIndex;
        }
        this.setActivePage(newPage);
        this.pageChange(newPage);
        if (subType == 1) {
            SourceResolver.setSourcePosition((CompilationUnitEditor)this.mJavaImplSourceEditor, (DevelopmentObject)this.mControllerEditorInput.getController(), (DevelopmentObject)object);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (editorInput instanceof ControllerEditorInput) {
            this.mControllerEditorInput = (ControllerEditorInput)editorInput;
        } else if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            if (fileEditorInput.getFile() == null) {
                throw new PartInitException(mTextPool.getText(1010, (Object)"No file given"));
            }
            Component[] components = null;
            ComponentInterfaceDefinition[] componentInterfaceDefinitions = null;
            try {
                String projectName = fileEditorInput.getFile().getProject().getName();
                if (!ServicesEclipse.projectHasWebDynproNature((String)projectName)) {
                    throw new PartInitException("The project '" + projectName + "' has no Web Dynpro nature");
                }
                WebDynproRoot root = MetamodelServices.getWebDynproRoot((String)projectName);
                components = root.getComponents();
                componentInterfaceDefinitions = root.getComponentInterfaceDefinitions();
            }
            catch (LoadException e) {
                ServiceControllerEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"init(IEditorSite, IEditorInput)", (String)e.getMessage(), (Throwable)e, (boolean)false);
                return;
            }
            IFile file = fileEditorInput.getFile();
            Controller controller = ImplementationFileFindService.isControllerImplementationFile((IFile)file, (Component[])components);
            if (controller == null) {
                controller = ImplementationFileFindService.isControllerEditorMetadataFile((IFile)file, (Component[])components, (ComponentInterfaceDefinition[])componentInterfaceDefinitions);
                if (controller == null) {
                    throw new PartInitException(mTextPool.getText(1010, (Object)file.getLocation()));
                }
            } else {
                this.mRequestedTab = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId().equals("org.eclipse.debug.ui.DebugPerspective") ? 1 : 0;
            }
            if (controller.getType().equals(ControllerTypeEnum.COMPONENT)) {
                DevelopmentObject parentObject = controller.getParent();
                if (parentObject instanceof Component) {
                    this.mControllerEditorInput = new ControllerEditorInput((Component)parentObject);
                }
            } else if (controller.getType().equals(ControllerTypeEnum.COMPONENT_INTERFACE)) {
                DevelopmentObject parentObject = controller.getParent();
                if (parentObject instanceof ComponentInterfaceImplementation) {
                    this.mControllerEditorInput = new ControllerEditorInput((ComponentInterfaceImplementation)parentObject);
                } else if (parentObject instanceof ComponentInterfaceDefinition) {
                    this.mControllerEditorInput = new ControllerEditorInput((ComponentInterfaceDefinition)parentObject);
                }
            } else if (controller.getType().equals(ControllerTypeEnum.COMPONENT_CONFIGURATION)) {
                this.mControllerEditorInput = new ControllerEditorInput(controller);
            } else if (controller.getType().equals(ControllerTypeEnum.INTERFACE_VIEW)) {
                this.mControllerEditorInput = new ControllerEditorInput((InterfaceView)controller.getView());
            } else if (controller.getType().equals(ControllerTypeEnum.VIEW)) {
                this.mControllerEditorInput = new ControllerEditorInput(controller.getView());
            } else if (controller.getType().equals(ControllerTypeEnum.CUSTOM)) {
                this.mControllerEditorInput = new ControllerEditorInput(controller);
            } else {
                throw new PartInitException(mTextPool.getText(1010, (Object)controller.getType().toString()));
            }
            editorInput = this.mControllerEditorInput;
        } else {
            throw new PartInitException(mTextPool.getText(1010, (Object)editorInput.getClass().getName()));
        }
        super.init(site, editorInput);
        this.setTitle(this.mControllerEditorInput.getEditorName());
        this.setTitleImage(ControllerService.getIcon((Controller)this.mControllerEditorInput.getController()));
        this.mRefactorObserver = new RefactorObserver();
        this.mControllerEditorInput.getController().attachObserver((DevelopmentObjectObserver)this.mRefactorObserver, 8256);
        if (this.mControllerEditorInput.getView() != null) {
            this.mControllerEditorInput.getView().attachObserver((DevelopmentObjectObserver)this.mRefactorObserver, 8256);
        }
        this.closeOtherEditors(this.mControllerEditorInput.getController());
    }

    protected void createPages() {
        ControllerTypeEnum type = this.mControllerEditorInput.getController().getType();
        if (type.equals(ControllerTypeEnum.COMPONENT)) {
            this.createOverviewPage();
            this.createContextPage();
            this.createMethodsPage();
            this.createEventsPage();
            this.createImplementationPage();
        } else if (type.equals(ControllerTypeEnum.COMPONENT_INTERFACE)) {
            this.createOverviewPage();
            this.createContextPage();
            this.createMethodsPage();
            this.createEventsPage();
            if (this.mControllerEditorInput.getComponentInterface() instanceof ComponentInterfaceImplementation) {
                this.createImplementationPage();
            }
        } else if (type.equals(ControllerTypeEnum.COMPONENT_CONFIGURATION)) {
            this.createOverviewPage();
            this.createContextPage();
            if (this.mControllerEditorInput.getComponentInterface() instanceof ComponentInterfaceImplementation) {
                this.createImplementationPage();
            }
        } else if (type.equals(ControllerTypeEnum.INTERFACE_VIEW)) {
            this.createOverviewPage();
            this.createPlugsPage();
            if (this.mControllerEditorInput.getComponentInterface() instanceof ComponentInterfaceImplementation) {
                this.createImplementationPage();
            }
        } else if (type.equals(ControllerTypeEnum.VIEW)) {
            this.createOverviewPage();
            this.createLayoutPage();
            this.createContextPage();
            this.createPlugsPage();
            this.createActionsPage();
            this.createMethodsPage();
            this.createImplementationPage();
        } else if (type.equals(ControllerTypeEnum.CUSTOM)) {
            this.createOverviewPage();
            this.createContextPage();
            this.createMethodsPage();
            this.createEventsPage();
            this.createImplementationPage();
        }
        this.setInitialTab();
        this.mControllerEditorControlListener = new ControllerEditorControlListener();
        this.getContainer().addControlListener((ControlListener)this.mControllerEditorControlListener);
        this.getContainer().pack(true);
    }

    private void setInitialTab() {
        if (this.mRequestedTab == -1) {
            if (this.mControllerEditorInput.getController().getType().equals(ControllerTypeEnum.COMPONENT)) {
                if (this.mContextEditorIndex != -1) {
                    this.setActivePage(this.mContextEditorIndex);
                    this.pageChange(this.mContextEditorIndex);
                }
            } else if (this.mControllerEditorInput.getController().getType().equals(ControllerTypeEnum.VIEW)) {
                if (this.mLayoutEditorIndex != -1) {
                    this.setActivePage(this.mLayoutEditorIndex);
                    this.pageChange(this.mLayoutEditorIndex);
                }
            } else if (this.mControllerEditorInput.getController().getType().equals(ControllerTypeEnum.CUSTOM)) {
                if (this.mContextEditorIndex != -1) {
                    this.setActivePage(this.mContextEditorIndex);
                    this.pageChange(this.mContextEditorIndex);
                }
            } else if (this.mControllerEditorInput.getController().getType().equals(ControllerTypeEnum.COMPONENT_INTERFACE)) {
                if (this.mContextEditorIndex != -1) {
                    this.setActivePage(this.mContextEditorIndex);
                    this.pageChange(this.mContextEditorIndex);
                }
            } else if (this.mControllerEditorInput.getController().getType().equals(ControllerTypeEnum.INTERFACE_VIEW) && this.mPlugTabIndex != -1) {
                this.setActivePage(this.mPlugTabIndex);
                this.pageChange(this.mPlugTabIndex);
            }
        } else {
            switch (this.mRequestedTab) {
                case 0: {
                    if (this.mJavaImplSourceEditorIndex == -1) break;
                    this.setActivePage(this.mJavaImplSourceEditorIndex);
                    this.pageChange(this.mJavaImplSourceEditorIndex);
                    break;
                }
                case 1: {
                    if (this.mJavaImplSourceEditorIndex == -1) break;
                    this.setActivePage(this.mJavaImplSourceEditorIndex);
                    break;
                }
            }
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private void createOverviewPage() {
        this.mOverviewPage = null;
        if (this.mControllerEditorInput.getComponent() != null) {
            this.mOverviewPage = new OverviewPage(this.mControllerEditorInput.getController(), this.mControllerEditorInput.getView(), this.mControllerEditorInput.getComponent());
        } else if (this.mControllerEditorInput.getComponentInterface() instanceof ComponentInterfaceDefinition) {
            this.mOverviewPage = new OverviewPage(this.mControllerEditorInput.getController(), (ComponentInterfaceDefinition)this.mControllerEditorInput.getComponentInterface());
        }
        this.mOverviewTabIndex = this.addPage((Control)this.mOverviewPage.init(this.getContainer()));
        this.setPageText(this.mOverviewTabIndex, mTextPool.getText(20));
    }

    private void createContextPage() {
        this.mContextEditor = new ContextEditorPart((EditorPart)this);
        try {
            this.mContextEditorIndex = this.addPage((IEditorPart)this.mContextEditor, this.getEditorInput());
            this.setPageText(this.mContextEditorIndex, "Context");
        }
        catch (PartInitException e) {
            Plugin.internalError(((Object)((Object)this)).getClass(), "createContextPage()", "Failed to create context editor page", e, false);
        }
    }

    private void createLayoutPage() {
        this.mLayoutEditor = (EditorPart)ServiceWithUI.createViewDesignerPart();
        if (this.mLayoutEditor instanceof IViewDesignerPart) {
            ((IViewDesignerPart)this.mLayoutEditor).setControllerEditorPart((Object)this);
        }
        try {
            this.mLayoutEditorIndex = this.addPage((IEditorPart)this.mLayoutEditor, ServiceWithUI.createViewDesignerEditorInput((View)((View)this.mControllerEditorInput.getView())));
        }
        catch (PartInitException e) {
            ServiceControllerEditorPlugin.internalError(((Object)((Object)this)).getClass(), (String)"createLayoutPage()", (String)e.getMessage(), (Throwable)e, (boolean)false);
            Composite composite = new Composite(this.getContainer(), 0);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            layout.numColumns = 1;
            this.mContextEditorIndex = this.addPage((Control)composite);
            this.setPageText(this.mContextEditorIndex, mTextPool.getText(28));
            return;
        }
        this.setPageText(this.mLayoutEditorIndex, mTextPool.getText(28));
    }

    private void createFieldgroupsPage() {
        this.mFieldGroupPage = new FieldGroupsPage(this.mControllerEditorInput.getController());
        this.mFieldGroupTabIndex = this.addPage((Control)this.mFieldGroupPage.init(this.getContainer()));
        this.setPageText(this.mFieldGroupTabIndex, mTextPool.getText(22));
    }

    private void createPlugsPage() {
        this.mPlugPage = new PlugsPage(this.mControllerEditorInput.getController(), this.mControllerEditorInput.getView());
        this.mPlugTabIndex = this.addPage((Control)this.mPlugPage.init(this.getContainer()));
        this.setPageText(this.mPlugTabIndex, mTextPool.getText(23));
    }

    private void createActionsPage() {
        this.mActionPage = new ActionsPage(this.mControllerEditorInput.getController());
        this.mActionTabIndex = this.addPage((Control)this.mActionPage.init(this.getContainer()));
        this.setPageText(this.mActionTabIndex, mTextPool.getText(24));
    }

    private void createMethodsPage() {
        this.mMethodPage = new MethodsPage(this.mControllerEditorInput.getController());
        this.mMethodTabIndex = this.addPage((Control)this.mMethodPage.init(this.getContainer()));
        this.setPageText(this.mMethodTabIndex, mTextPool.getText(29));
    }

    private void createEventsPage() {
        this.mEventPage = new EventsPage(this.mControllerEditorInput.getController());
        this.mEventTabIndex = this.addPage((Control)this.mEventPage.init(this.getContainer()));
        this.setPageText(this.mEventTabIndex, mTextPool.getText(26));
    }

    private void createImplementationPage() {
        MessageDialog dialog;
        String[] buttons;
        Shell shell;
        boolean needsGeneration = false;
        IProject project = com.sap.ide.metamodel.core.services.ServicesEclipse.getEclipseProject((DevelopmentObject)this.mControllerEditorInput.getController());
        NamingService namingService = new NamingService(project.getLocation().toFile().getAbsolutePath() + GenerationEclipse.getGenerationOutputPathInfix());
        Path path = new Path(namingService.getControllerEditableNaming(this.mControllerEditorInput.getController()).getAbsoluteFilePath());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (file == null || !file.exists()) {
            needsGeneration = true;
        }
        FileEditorInput javaFileEditorInput = new FileEditorInput(file);
        this.mImplementationService = new ImplementationService(this.mControllerEditorInput.getController());
        if (needsGeneration) {
            this.mImplementationService.updateImplementationFromXML();
        }
        this.mJavaImplSourceEditor = new JavaImplementationEditor(this.mControllerEditorInput.getController());
        this.mImplementationService.setJavaEditor((IJavaImplementationEditor)this.mJavaImplSourceEditor);
        try {
            this.mJavaImplSourceEditorIndex = this.addPage((IEditorPart)this.mJavaImplSourceEditor, (IEditorInput)javaFileEditorInput);
        }
        catch (PartInitException e) {
            this.mImplementationService.generateEmptyImplementation();
            try {
                this.mJavaImplSourceEditorIndex = this.addPage((IEditorPart)this.mJavaImplSourceEditor, (IEditorInput)javaFileEditorInput);
            }
            catch (PartInitException ie) {
                Plugin.internalError(((Object)((Object)this)).getClass(), "createImplementationPage()", ie.getMessage(), ie, false);
                this.createErrorImplementationPage();
                return;
            }
            shell = this.getSite().getShell();
            buttons = new String[]{mTextPool.getText(8)};
            dialog = new MessageDialog(shell, mTextPool.getText(180), null, mTextPool.getText(181), 2, buttons, 0);
            dialog.open();
            dialog.close();
        }
        this.mJavaImplSourceEditor.initializeListeners();
        try {
            JavaUI.getWorkingCopyManager().connect((IEditorInput)javaFileEditorInput);
        }
        catch (CoreException e) {
            this.mImplementationService.generateEmptyImplementation();
            try {
                this.mJavaImplSourceEditorIndex = this.addPage((IEditorPart)this.mJavaImplSourceEditor, (IEditorInput)javaFileEditorInput);
            }
            catch (PartInitException ie) {
                Plugin.internalError(((Object)((Object)this)).getClass(), "createImplementationPage()", ie.getMessage(), ie, false);
                this.createErrorImplementationPage();
                return;
            }
            shell = this.getSite().getShell();
            buttons = new String[]{mTextPool.getText(8)};
            dialog = new MessageDialog(shell, mTextPool.getText(180), null, mTextPool.getText(181), 2, buttons, 0);
            dialog.open();
            dialog.close();
        }
        this.setPageText(this.mJavaImplSourceEditorIndex, mTextPool.getText(27));
    }

    private void createErrorImplementationPage() {
        Composite composite = new Composite(this.getContainer(), 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        layout.numColumns = 1;
        Label label = new Label(composite, 0);
        label.setText("Could not open java implementation editor.");
        int index = this.addPage((Control)composite);
        this.setPageText(index, mTextPool.getText(27));
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = ControllerEditorPart.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage)) {
            return this.getContentOutlinePage();
        }
        if (adapter.equals(class$org$eclipse$ui$views$properties$IPropertySheetPage == null ? (class$org$eclipse$ui$views$properties$IPropertySheetPage = ControllerEditorPart.class$("org.eclipse.ui.views.properties.IPropertySheetPage")) : class$org$eclipse$ui$views$properties$IPropertySheetPage)) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(adapter);
    }

    protected void pageChange(int newPageIndex) {
        if (newPageIndex != this.mActivePage) {
            IEditorActionBarContributor contributor;
            int previousActivePage = this.mActivePage;
            this.mActivePage = newPageIndex;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window instanceof WorkbenchWindow) {
                ((WorkbenchWindow)window).getActionBars().getStatusLineManager().setErrorMessage(null);
            }
            this.setActiveOutlinePage(newPageIndex);
            this.setActivePropertySheetPage(newPageIndex);
            if (newPageIndex == this.mJavaImplSourceEditorIndex) {
                this.mJavaImplSourceEditor.setFocus();
                if (this.mImplementationService != null) {
                    this.mImplementationService.updateImplementationFromXML();
                }
            } else if (newPageIndex == this.mContextEditorIndex) {
                this.mContextEditor.setFocus();
            } else if (newPageIndex == this.mLayoutEditorIndex) {
                this.mLayoutEditor.setFocus();
            }
            if ((contributor = this.getEditorSite().getActionBarContributor()) instanceof ControllerEditorContributor) {
                if (newPageIndex == this.mJavaImplSourceEditorIndex) {
                    ((ControllerEditorContributor)contributor).setActivePage((IEditorPart)this.mJavaImplSourceEditor);
                } else if (newPageIndex == this.mContextEditorIndex) {
                    ((ControllerEditorContributor)contributor).setActivePage((IEditorPart)this.mContextEditor);
                } else {
                    ((ControllerEditorContributor)contributor).setActivePage(null);
                }
            }
        }
        if (this.mControllerEditorControlListener != null) {
            this.mControllerEditorControlListener.controlResized(null);
        }
    }

    private ControllerOutlinePage getContentOutlinePage() {
        if (this.mOutlinePage == null) {
            IContentOutlinePage layoutOutlinePage = null;
            if (this.mLayoutEditor != null) {
                layoutOutlinePage = (IContentOutlinePage)this.mLayoutEditor.getAdapter(class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = ControllerEditorPart.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage);
            }
            if (this.mJavaImplSourceEditor != null) {
                this.mOutlinePage = new ControllerOutlinePage((IContentOutlinePage)this.mJavaImplSourceEditor.getAdapter(class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = ControllerEditorPart.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage), layoutOutlinePage, this.mJavaImplSourceEditor);
                this.setActiveOutlinePage(this.mActivePage);
            }
        }
        return this.mOutlinePage;
    }

    private void setActiveOutlinePage(int pageIndex) {
        int outlinePageType = pageIndex == this.mJavaImplSourceEditorIndex ? 0 : (pageIndex == this.mLayoutEditorIndex ? 1 : 2);
        if (this.mOutlinePage != null) {
            this.mOutlinePage.setActivePageType(outlinePageType);
        }
    }

    private PropertySheetPage getPropertySheetPage() {
        if (this.mPropertySheetPage == null) {
            IPropertySheetPage layoutPropertyPage = null;
            if (this.mLayoutEditor != null) {
                layoutPropertyPage = (IPropertySheetPage)this.mLayoutEditor.getAdapter(class$org$eclipse$ui$views$properties$IPropertySheetPage == null ? (class$org$eclipse$ui$views$properties$IPropertySheetPage = ControllerEditorPart.class$("org.eclipse.ui.views.properties.IPropertySheetPage")) : class$org$eclipse$ui$views$properties$IPropertySheetPage);
            }
            IPropertySheetPage contextPropertyPage = null;
            if (this.mContextEditor != null) {
                contextPropertyPage = (IPropertySheetPage)this.mContextEditor.getAdapter(class$org$eclipse$ui$views$properties$IPropertySheetPage == null ? (class$org$eclipse$ui$views$properties$IPropertySheetPage = ControllerEditorPart.class$("org.eclipse.ui.views.properties.IPropertySheetPage")) : class$org$eclipse$ui$views$properties$IPropertySheetPage);
            }
            this.mPropertySheetPage = new ControllerPropertyPage(layoutPropertyPage, contextPropertyPage);
            this.setActivePropertySheetPage(this.mActivePage);
        }
        return this.mPropertySheetPage;
    }

    private void setActivePropertySheetPage(int pageIndex) {
        int propertiesPageType = pageIndex == this.mLayoutEditorIndex ? 1 : (pageIndex == this.mContextEditorIndex ? 0 : 2);
        if (this.mPropertySheetPage != null) {
            this.mPropertySheetPage.setActivePageType(propertiesPageType);
        }
    }

    public void dispose() {
        this.mControllerEditorInput.getController().detachObserver((DevelopmentObjectObserver)this.mRefactorObserver);
        if (this.mControllerEditorInput.getView() != null) {
            this.mControllerEditorInput.getView().detachObserver((DevelopmentObjectObserver)this.mRefactorObserver);
        }
        if (this.mOutlinePage != null) {
            this.mOutlinePage.dispose();
        }
        if (this.mPropertySheetPage != null) {
            this.mPropertySheetPage.dispose();
        }
        super.dispose();
    }

    public void setFocus() {
        super.setFocus();
        if (this.mActivePage == this.mContextEditorIndex) {
            this.mContextEditor.setFocus();
        } else if (this.mActivePage == this.mLayoutEditorIndex) {
            this.mLayoutEditor.setFocus();
        } else if (this.mActivePage == this.mJavaImplSourceEditorIndex) {
            this.mJavaImplSourceEditor.setFocus();
        }
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof ControllerEditorContributor) {
            ((ControllerEditorContributor)contributor).setReadOnlyText(this.mControllerEditorInput.getReadOnlyText());
            ((ControllerEditorContributor)contributor).setActivePage(this.getActiveEditor());
        }
    }

    public void postSave() {
        if (this.mLayoutEditor != null && this.mLayoutEditor.isDirty()) {
            this.mLayoutEditor.doSave(null);
        }
        if (this.mJavaImplSourceEditor != null) {
            this.mJavaImplSourceEditor.setNoUpdateOfMetadata(true);
            if (ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                this.mJavaImplSourceEditor.doRevertToSaved();
            }
            this.mJavaImplSourceEditor.setNoUpdateOfMetadata(false);
        }
    }

    public void preSave() {
        if (this.mJavaImplSourceEditor != null) {
            FileEditorInput input;
            IFile file;
            this.mJavaImplSourceEditor.setNoUpdateOfMetadata(true);
            if (this.mJavaImplSourceEditor.getEditorInput() instanceof FileEditorInput && (file = (input = (FileEditorInput)this.mJavaImplSourceEditor.getEditorInput()).getFile()) != null && file.exists() && this.mJavaImplSourceEditor.isDirty()) {
                this.mJavaImplSourceEditor.doSave(null);
            }
        }
    }

    public Metamodel getMetamodel() {
        Controller controller = this.mControllerEditorInput.getController();
        if (controller != null) {
            return controller.getRoot().getMetamodel();
        }
        return null;
    }

    public void postRollback() {
        if (this.mControllerEditorInput.getController() == null || !this.mControllerEditorInput.getController().isValid()) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)this, false);
            return;
        }
        if (this.mImplementationService != null) {
            this.mImplementationService.updateImplementationFromXML();
        }
        this.updateUI();
    }

    public JavaImplementationEditor getImplementationEditor() {
        return this.mJavaImplSourceEditor;
    }

    public IJavaImplementationEditor getImplementationEditorAsInterface() {
        return this.mJavaImplSourceEditor;
    }

    public ISourcePatternEditor getSourcePatternEditor() {
        return this.mJavaImplSourceEditor;
    }

    public boolean isSourcePatternEditorActive() {
        return this.getActivePage() == this.mJavaImplSourceEditorIndex;
    }

    private void closeOtherEditors(Controller controller) {
        IMetamodelSaveParticipant[] allEditors = MetamodelHelper.getAllActiveMetamodelEditors((Metamodel)controller.getRoot().getMetamodel());
        int i = 0;
        while (i < allEditors.length) {
            DevelopmentObjectEditorInput input;
            IEditorPart part;
            if (allEditors[i] instanceof IEditorPart && (part = (IEditorPart)allEditors[i]) != this && part.getEditorInput() instanceof DevelopmentObjectEditorInput && (input = (DevelopmentObjectEditorInput)part.getEditorInput()).getDevelopmentObject() == this.mControllerEditorInput.getController()) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(part, false);
            }
            ++i;
        }
    }

    public DevelopmentObject getDevelopmentObject() {
        return this.mControllerEditorInput.getController();
    }

    public void updateUI() {
        int i = 0;
        while (i < this.getPageCount()) {
            this.getControl(i).redraw();
            this.getControl(i).update();
            ++i;
        }
    }

    public void endLayoutUpdate() {
        if (this.mLayoutEditor instanceof IViewDesignerPart) {
            ((IViewDesignerPart)this.mLayoutEditor).endTransaction();
        }
    }

    public void startLayoutUpdate() {
        if (this.mLayoutEditor instanceof IViewDesignerPart) {
            ((IViewDesignerPart)this.mLayoutEditor).startTransaction();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ControllerEditorControlListener
    implements ControlListener {
        private ControllerEditorControlListener() {
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            if (ControllerEditorPart.this.mActionPage != null) {
                ControllerEditorPart.this.mActionPage.adaptSize();
            }
            if (ControllerEditorPart.this.mEventPage != null) {
                ControllerEditorPart.this.mEventPage.adaptSize();
            }
            if (ControllerEditorPart.this.mFieldGroupPage != null) {
                ControllerEditorPart.this.mFieldGroupPage.adaptSize();
            }
            if (ControllerEditorPart.this.mMethodPage != null) {
                ControllerEditorPart.this.mMethodPage.adaptSize();
            }
            if (ControllerEditorPart.this.mOverviewPage != null) {
                ControllerEditorPart.this.mOverviewPage.adaptSize();
            }
            if (ControllerEditorPart.this.mPlugPage != null) {
                ControllerEditorPart.this.mPlugPage.adaptSize();
            }
        }
    }

    private class RefactorObserver
    implements DevelopmentObjectObserver {
        private RefactorObserver() {
        }

        public void update(MetamodelEvent event) {
            MetamodelEvent[] events = new MetamodelEvent[]{event};
            this.update(events);
        }

        public void update(MetamodelEvent[] events) {
            ControllerEditorPart.super.setTitle(ControllerEditorPart.this.mControllerEditorInput.getEditorName());
        }
    }
}

