/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor;

import com.sap.ide.webdynpro.controllereditor.AbstractControllerTableModel;
import com.sap.ide.webdynpro.controllereditor.AbstractControllerTableSection;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.tssap.util.ui.glpc.section.IMenuProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class ContextMenuProvider
implements IMenuProvider,
SelectionListener {
    private static final TextPool mTextPool = TextPool.getInstance();
    private AbstractControllerTableSection mTableSection = null;
    private MenuItem mItemEdit = null;
    private MenuItem mItemCut = null;
    private MenuItem mItemCopy = null;
    private MenuItem mItemPaste = null;
    private MenuItem mItemDelete = null;
    private MenuItem mItemRename = null;
    private String mItemDeleteText = mTextPool.getText(3);

    public ContextMenuProvider(AbstractControllerTableSection tableSection) {
        this.mTableSection = tableSection;
    }

    public void addItems(Menu menu) {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        int[] indexes = this.mTableSection.getTableViewer().getTable().getSelectionIndices();
        this.mItemEdit = new MenuItem(menu, 0);
        this.mItemEdit.setText(mTextPool.getText(1));
        this.mItemEdit.addSelectionListener((SelectionListener)this);
        if (!((AbstractControllerTableModel)this.mTableSection.getTableModel()).isEditable(indexes)) {
            this.mItemEdit.setEnabled(false);
        }
        new MenuItem(menu, 2);
        this.mItemCut = new MenuItem(menu, 0);
        this.mItemCut.setText(mTextPool.getText(3000));
        this.mItemCut.setImage(sharedImages.getImage("IMG_TOOL_CUT_HOVER"));
        this.mItemCut.addSelectionListener((SelectionListener)this);
        if (!((AbstractControllerTableModel)this.mTableSection.getTableModel()).isCutable(indexes)) {
            this.mItemCut.setEnabled(false);
        }
        this.mItemCopy = new MenuItem(menu, 0);
        this.mItemCopy.setText(mTextPool.getText(2));
        this.mItemCopy.setImage(sharedImages.getImage("IMG_TOOL_COPY_HOVER"));
        this.mItemCopy.addSelectionListener((SelectionListener)this);
        if (!((AbstractControllerTableModel)this.mTableSection.getTableModel()).isCopyable(indexes)) {
            this.mItemCopy.setEnabled(false);
        }
        this.mItemPaste = new MenuItem(menu, 0);
        this.mItemPaste.setText(mTextPool.getText(9));
        this.mItemPaste.setImage(sharedImages.getImage("IMG_TOOL_PASTE_HOVER"));
        this.mItemPaste.addSelectionListener((SelectionListener)this);
        if (!((AbstractControllerTableModel)this.mTableSection.getTableModel()).isPasteable()) {
            this.mItemPaste.setEnabled(false);
        }
        new MenuItem(menu, 2);
        this.mItemDelete = new MenuItem(menu, 0);
        this.mItemDelete.setText(this.mItemDeleteText);
        this.mItemDelete.setImage(sharedImages.getImage("IMG_TOOL_DELETE_HOVER"));
        this.mItemDelete.addSelectionListener((SelectionListener)this);
        if (!((AbstractControllerTableModel)this.mTableSection.getTableModel()).isDeletable(indexes)) {
            this.mItemDelete.setEnabled(false);
        }
        this.mItemRename = new MenuItem(menu, 0);
        this.mItemRename.setText(mTextPool.getText(3001));
        this.mItemRename.addSelectionListener((SelectionListener)this);
        if (!((AbstractControllerTableModel)this.mTableSection.getTableModel()).isRenameable(indexes)) {
            this.mItemRename.setEnabled(false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        int[] indexes = this.mTableSection.getTableViewer().getTable().getSelectionIndices();
        if (e.widget instanceof MenuItem) {
            MenuItem item = (MenuItem)e.widget;
            if (item.equals(this.mItemEdit)) {
                ((AbstractControllerTableModel)this.mTableSection.getTableModel()).doEdit(indexes);
            } else if (item.equals(this.mItemCut)) {
                ((AbstractControllerTableModel)this.mTableSection.getTableModel()).doCallCut(indexes);
            } else if (item.equals(this.mItemCopy)) {
                ((AbstractControllerTableModel)this.mTableSection.getTableModel()).doCallCopy(indexes);
            } else if (item.equals(this.mItemPaste)) {
                ((AbstractControllerTableModel)this.mTableSection.getTableModel()).doCallPaste();
            } else if (item.equals(this.mItemRename)) {
                ((AbstractControllerTableModel)this.mTableSection.getTableModel()).doRename(indexes);
            } else if (item.equals(this.mItemDelete)) {
                ((AbstractControllerTableModel)this.mTableSection.getTableModel()).doDelete(indexes);
            }
        }
    }

    public void setItemDeleteText(String text) {
        this.mItemDeleteText = text;
    }
}

