/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.AbstractControllerTableModel;
import com.sap.ide.webdynpro.controllereditor.ContextMenuProvider;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.core.ServiceCorePlugin;
import com.tssap.util.ui.glpc.section.ButtonClickedEvent;
import com.tssap.util.ui.glpc.section.IButtonClickedListener;
import com.tssap.util.ui.glpc.section.TableSection;
import com.tssap.util.ui.pane.IGridLayoutPane;
import javax.swing.table.TableModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;

public abstract class AbstractControllerTableSection
extends TableSection
implements DisposeListener,
SelectionListener {
    protected static final TextPool mTextPool = TextPool.getInstance();
    protected static final int BUTTON_INDEX_NEW_OR_ADD = 0;
    protected static final String[] BUTTONS_NEW = new String[]{mTextPool.getText(0)};
    protected static final String[] BUTTONS_ADD = new String[]{mTextPool.getText(4)};
    private Controller mController = null;
    private AbstractControllerTableModel mTableModel = null;
    private ContextMenuProvider mContextMenuProvider = null;

    public AbstractControllerTableSection(Controller controller, AbstractControllerTableModel tableModel, String title, String description, String[] buttons) {
        this(controller, tableModel, title, description, buttons, null);
    }

    public AbstractControllerTableSection(Controller controller, AbstractControllerTableModel tableModel, String title, String description, String[] buttons, boolean[] buttonsEnabled) {
        super((TableModel)tableModel, ServiceCorePlugin.WIDGET_FACTORY, title, description, buttons, buttonsEnabled, false);
        this.mController = controller;
        this.mTableModel = tableModel;
        this.addButtonClickedListener(new ButtonClickedListener());
        this.mContextMenuProvider = new ContextMenuProvider(this);
        this.addMenuProvider(this.mContextMenuProvider);
    }

    protected Controller getController() {
        return this.mController;
    }

    public void update(DevelopmentObject newMasterObject) {
        if (newMasterObject != null) {
            this.enableDisableButtons();
        } else {
            this.setButtonEnabled(0, false);
        }
    }

    public void enableDisableButtons() {
        this.setButtonEnabled(0, !this.mTableModel.isReadOnly());
    }

    public void widgetDisposed(DisposeEvent e) {
        this.mTableModel.tableModelDisposed();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        super.widgetDefaultSelected(e);
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        super.widgetSelected(e);
        if (e.widget instanceof Table) {
            Table table = (Table)e.widget;
            this.mTableModel.selectionChanged(table.getSelectionIndices());
        }
    }

    protected void postInitSection(IGridLayoutPane glp) {
        super.postInitSection(glp);
        this.getUserAreaGridLayoutPane().addDisposeListener((DisposeListener)this);
        this.addSelectionListener(this);
        this.setButtonEnabled(0, !this.mTableModel.isReadOnly());
        this.getTableViewer().getTable().addMouseListener((MouseListener)new DoubleClickMouseListener());
    }

    public ContextMenuProvider getContextMenuProvider() {
        return this.mContextMenuProvider;
    }

    private class DoubleClickMouseListener
    implements MouseListener {
        private DoubleClickMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            int[] indexes = AbstractControllerTableSection.this.getTableViewer().getTable().getSelectionIndices();
            if (AbstractControllerTableSection.this.mTableModel.isEditable(indexes)) {
                AbstractControllerTableSection.this.mTableModel.doEdit(indexes);
            }
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }
    }

    private class ButtonClickedListener
    implements IButtonClickedListener {
        private ButtonClickedListener() {
        }

        public void buttonClicked(ButtonClickedEvent e) {
            switch (e.getIndex()) {
                case 0: {
                    AbstractControllerTableSection.this.mTableModel.doNew();
                    break;
                }
            }
        }
    }
}

