/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.gde.printing.zoom;

import com.togethersoft.selena.gde.printing.zoom.FriendlyFigureUtilities;
import com.togethersoft.selena.gde.printing.zoom.FriendlyGraphics;
import com.togethersoft.selena.gde.printing.zoom.ZoomGraphics$FontHeightCache;
import com.togethersoft.selena.gde.printing.zoom.ZoomGraphics$State;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;

public class ZoomGraphics
extends FriendlyGraphics {
    private static final Rectangle TEMP = new Rectangle();
    private static final Point PT = new Point();
    private static Map fontCache = new HashMap();
    private ZoomGraphics$FontHeightCache localCache = new ZoomGraphics$FontHeightCache(null);
    private ZoomGraphics$FontHeightCache targetCache = new ZoomGraphics$FontHeightCache(null);
    private Graphics graphics;
    private Font localFont;
    private float fractionalX;
    private float fractionalY;
    private float zoom = 1.0f;
    private List stack = new ArrayList();
    private int stackPointer = 0;

    public ZoomGraphics(Graphics graphics) {
        this.graphics = graphics;
        this.localFont = graphics.getFont();
    }

    public void clipRect(Rectangle rectangle) {
        this.graphics.clipRect(this.zoomRect(rectangle));
    }

    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.graphics.drawArc(this.zoomRect(n2, n3, n4, n5), n6, n7);
    }

    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.graphics.drawArc(this.zoomRect(n2, n3, n4, n5), n6, n7);
    }

    public void drawFocus(int n2, int n3, int n4, int n5) {
        this.graphics.drawFocus(this.zoomRect(n2, n3, n4, n5));
    }

    public void drawImage(Image image, int n2, int n3) {
        org.eclipse.swt.graphics.Rectangle rectangle = image.getBounds();
        this.graphics.drawImage(image, 0, 0, rectangle.width, rectangle.height, (int)((float)n2 * this.zoom), (int)((float)n3 * this.zoom), (int)((float)rectangle.width * this.zoom), (int)((float)rectangle.height * this.zoom));
    }

    public void drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        Rectangle rectangle = this.zoomRect(n6, n7, n8, n9);
        this.graphics.drawImage(image, n2, n3, n4, n5, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawLine(int n2, int n3, int n4, int n5) {
        this.graphics.drawLine((int)((float)n2 * this.zoom), (int)((float)n3 * this.zoom), (int)((float)n4 * this.zoom), (int)((float)n5 * this.zoom));
    }

    private void drawDashedLine(int n2, int n3, int n4, int n5) {
        int n6 = this.getLineStyle();
        this.setLineStyle(1);
        double d2 = 17.0f * this.zoom;
        double d3 = 7.0f * this.zoom;
        double d4 = d2 + d3;
        n2 = (int)((float)n2 * this.zoom);
        n3 = (int)((float)n3 * this.zoom);
        n4 = (int)((float)n4 * this.zoom);
        n5 = (int)((float)n5 * this.zoom);
        int n7 = n4 - n2;
        int n8 = n5 - n3;
        double d5 = Math.sqrt(n7 * n7 + n8 * n8);
        double d6 = n7;
        d6 /= d5;
        double d7 = n8;
        d7 /= d5;
        int n9 = (int)(d5 / d4);
        if ((int)((double)n9 * d4) == (int)d5) {
            --n9;
        }
        int n10 = n2;
        int n11 = n3;
        int n12 = 0;
        while (n12 < n9) {
            int n13 = n2 + (int)(((double)n12 * d4 + d2) * d6);
            int n14 = n3 + (int)(((double)n12 * d4 + d2) * d7);
            this.graphics.drawLine(n10, n11, n13, n14);
            n10 = n2 + (int)((double)(n12 + 1) * d4 * d6);
            n11 = n3 + (int)((double)(n12 + 1) * d4 * d7);
            ++n12;
        }
        this.graphics.drawLine(n10, n11, n4, n5);
        this.setLineStyle(n6);
    }

    public void drawOval(int n2, int n3, int n4, int n5) {
        this.graphics.drawOval(this.zoomRect(n2, n3, n4, n5));
    }

    public void fillOval(int n2, int n3, int n4, int n5) {
        this.graphics.fillOval(this.zoomFillRect(n2, n3, n4, n5));
    }

    public void drawPolygon(PointList pointList) {
        this.graphics.drawPolygon(this.zoomPointList(pointList));
    }

    public void fillPolygon(PointList pointList) {
        this.graphics.fillPolygon(this.zoomPointList(pointList));
    }

    public void drawPolyline(PointList pointList) {
        if (this.getLineStyle() == 2 && this.zoom > 1.0f && pointList.size() > 1) {
            Point point = pointList.getFirstPoint();
            int n2 = 1;
            while (n2 < pointList.size()) {
                Point point2 = pointList.getPoint(n2);
                this.drawDashedLine(point.x, point.y, point2.x, point2.y);
                point = point2;
                ++n2;
            }
        } else {
            this.graphics.drawPolyline(this.zoomPointList(pointList));
        }
    }

    public void drawRectangle(int n2, int n3, int n4, int n5) {
        this.graphics.drawRectangle(this.zoomRect(n2, n3, n4, n5));
    }

    public void fillRectangle(int n2, int n3, int n4, int n5) {
        this.graphics.fillRectangle(this.zoomFillRect(n2, n3, n4, n5));
    }

    public void drawRoundRectangle(Rectangle rectangle, int n2, int n3) {
        this.graphics.drawRoundRectangle(this.zoomRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height), (int)((float)n2 * this.zoom), (int)((float)n3 * this.zoom));
    }

    public void fillRoundRectangle(Rectangle rectangle, int n2, int n3) {
        this.graphics.fillRoundRectangle(this.zoomFillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height), (int)((float)n2 * this.zoom), (int)((float)n3 * this.zoom));
    }

    public void drawString(String string, int n2, int n3) {
        this.graphics.drawString(string, this.zoomTextPoint(n2, n3));
    }

    public void fillString(String string, int n2, int n3) {
        this.graphics.fillString(string, this.zoomTextPoint(n2, n3));
    }

    public void drawText(String string, int n2, int n3) {
        this.graphics.drawText(string, this.zoomTextPoint(n2, n3));
    }

    public void fillText(String string, int n2, int n3) {
        this.graphics.fillText(string, this.zoomTextPoint(n2, n3));
    }

    public int getAdvanceWidth(char c2) {
        FriendlyFigureUtilities.setFont(this.getLocalFont());
        return FriendlyFigureUtilities.getGC().getAdvanceWidth(c2);
    }

    public Color getBackgroundColor() {
        return this.graphics.getBackgroundColor();
    }

    public int getCharWidth(char c2) {
        FriendlyFigureUtilities.setFont(this.getLocalFont());
        return FriendlyFigureUtilities.getGC().getCharWidth(c2);
    }

    public Rectangle getClip(Rectangle rectangle) {
        this.graphics.getClip(rectangle);
        int n2 = (int)((float)rectangle.x / this.zoom);
        int n3 = (int)((float)rectangle.y / this.zoom);
        rectangle.width = (int)Math.ceil((float)rectangle.right() / this.zoom) - n2;
        rectangle.height = (int)Math.ceil((float)rectangle.bottom() / this.zoom) - n3;
        rectangle.x = n2;
        rectangle.y = n3;
        return rectangle;
    }

    public Font getFont() {
        return this.getLocalFont();
    }

    public FontMetrics getFontMetrics() {
        return FigureUtilities.getFontMetrics((Font)this.localFont);
    }

    public Color getForegroundColor() {
        return this.graphics.getForegroundColor();
    }

    public int getLineStyle() {
        return this.graphics.getLineStyle();
    }

    public int getLineWidth() {
        return this.graphics.getLineWidth();
    }

    private Font getLocalFont() {
        return this.localFont;
    }

    public Dimension getStringExtent(String string) {
        FriendlyFigureUtilities.setFont(this.getLocalFont());
        org.eclipse.swt.graphics.Point point = FriendlyFigureUtilities.getGC().stringExtent(string);
        return new Dimension(point.x, point.y);
    }

    public Dimension getTextExtent(String string) {
        FriendlyFigureUtilities.setFont(this.getLocalFont());
        org.eclipse.swt.graphics.Point point = FriendlyFigureUtilities.getGC().textExtent(string);
        return new Dimension(point.x, point.y);
    }

    public boolean getXORMode() {
        return this.graphics.getXORMode();
    }

    public void popState() {
        this.graphics.popState();
        --this.stackPointer;
        this.restoreLocalState((ZoomGraphics$State)this.stack.get(this.stackPointer));
    }

    public void pushState() {
        if (this.stack.size() > this.stackPointer) {
            ZoomGraphics$State zoomGraphics$State = (ZoomGraphics$State)this.stack.get(this.stackPointer);
            zoomGraphics$State.setValues(this.zoom, this.fractionalX, this.fractionalY, this.getLocalFont());
        } else {
            this.stack.add(new ZoomGraphics$State(this.zoom, this.fractionalX, this.fractionalY, this.getLocalFont()));
        }
        ++this.stackPointer;
        this.graphics.pushState();
    }

    private void restoreLocalState(ZoomGraphics$State zoomGraphics$State) {
        this.fractionalX = ZoomGraphics$State.access$100(zoomGraphics$State);
        this.fractionalY = ZoomGraphics$State.access$200(zoomGraphics$State);
        this.setScale(ZoomGraphics$State.access$300(zoomGraphics$State));
        this.setLocalFont(ZoomGraphics$State.access$400(zoomGraphics$State));
    }

    public void restoreState() {
        this.graphics.restoreState();
        this.restoreLocalState((ZoomGraphics$State)this.stack.get(this.stackPointer - 1));
    }

    public void scale(float f2) {
        this.setScale(this.zoom * f2);
    }

    void setScale(float f2) {
        if (this.zoom == f2) {
            return;
        }
        this.zoom = f2;
        this.graphics.setFont(this.zoomFont(this.getLocalFont()));
    }

    Font getCachedFont(FontData fontData) {
        Font font = (Font)fontCache.get(new Integer(fontData.getHeight()));
        if (font != null) {
            return font;
        }
        font = new Font(null, fontData);
        fontCache.put(new Integer(fontData.getHeight()), font);
        return font;
    }

    public void setBackgroundColor(Color color) {
        this.graphics.setBackgroundColor(color);
    }

    public void setClip(Rectangle rectangle) {
        this.graphics.setClip(this.zoomRect(rectangle));
    }

    public void setFont(Font font) {
        this.setLocalFont(font);
    }

    public void setForegroundColor(Color color) {
        this.graphics.setForegroundColor(color);
    }

    public void setLineStyle(int n2) {
        this.graphics.setLineStyle(n2);
    }

    public void setLineWidth(int n2) {
        this.graphics.setLineWidth((int)((float)n2 * this.zoom));
    }

    private void setLocalFont(Font font) {
        this.localFont = font;
        this.graphics.setFont(this.zoomFont(font));
    }

    public void setXORMode(boolean bl) {
        this.graphics.setXORMode(bl);
    }

    public void translate(int n2, int n3) {
        float f2 = (float)n2 * this.zoom + this.fractionalX;
        float f3 = (float)n3 * this.zoom + this.fractionalY;
        int n4 = (int)f2;
        int n5 = (int)f3;
        this.fractionalX = f2 - (float)n4;
        this.fractionalY = f3 - (float)n5;
        this.graphics.translate(n4, n5);
    }

    private Point zoomTextPoint(int n2, int n3) {
        FontMetrics fontMetrics;
        if (this.localCache.font != this.localFont) {
            fontMetrics = FigureUtilities.getFontMetrics((Font)this.localFont);
            this.localCache.height = fontMetrics.getHeight() - fontMetrics.getDescent();
            this.localCache.font = this.localFont;
        }
        if (this.targetCache.font != this.graphics.getFont()) {
            fontMetrics = this.graphics.getFontMetrics();
            this.targetCache.font = this.graphics.getFont();
            this.targetCache.height = fontMetrics.getHeight() - fontMetrics.getDescent();
        }
        return new Point((double)((float)n2 * this.zoom), (double)((float)(n3 + this.localCache.height - 1) * this.zoom - (float)this.targetCache.height + 1.0f));
    }

    private PointList zoomPointList(PointList pointList) {
        PointList pointList2 = new PointList(pointList.size());
        int n2 = 0;
        while (n2 < pointList.size()) {
            pointList2.addPoint(pointList.getPoint(n2).scale(this.zoom));
            ++n2;
        }
        return pointList2;
    }

    private Rectangle zoomFillRect(int n2, int n3, int n4, int n5) {
        ZoomGraphics.TEMP.x = (int)((float)n2 * this.zoom);
        ZoomGraphics.TEMP.y = (int)((float)n3 * this.zoom);
        ZoomGraphics.TEMP.width = (int)((float)(n2 + n4 - 1) * this.zoom) - ZoomGraphics.TEMP.x + 1;
        ZoomGraphics.TEMP.height = (int)((float)(n3 + n5 - 1) * this.zoom) - ZoomGraphics.TEMP.y + 1;
        return TEMP;
    }

    private Font zoomFont(Font font) {
        FontData fontData = this.getLocalFont().getFontData()[0];
        fontData = new FontData(fontData.getName(), Math.max(1, (int)((float)fontData.getHeight() * this.zoom)), fontData.getStyle());
        return this.getCachedFont(fontData);
    }

    private Rectangle zoomRect(int n2, int n3, int n4, int n5) {
        ZoomGraphics.TEMP.x = (int)((float)n2 * this.zoom);
        ZoomGraphics.TEMP.y = (int)((float)n3 * this.zoom);
        ZoomGraphics.TEMP.width = (int)((float)(n2 + n4) * this.zoom) - ZoomGraphics.TEMP.x;
        ZoomGraphics.TEMP.height = (int)((float)(n3 + n5) * this.zoom) - ZoomGraphics.TEMP.y;
        return TEMP;
    }

    private Rectangle zoomRect(Rectangle rectangle) {
        ZoomGraphics.TEMP.x = (int)((float)rectangle.x * this.zoom);
        ZoomGraphics.TEMP.y = (int)((float)rectangle.y * this.zoom);
        ZoomGraphics.TEMP.width = (int)((float)rectangle.right() * this.zoom) - ZoomGraphics.TEMP.x;
        ZoomGraphics.TEMP.height = (int)((float)rectangle.bottom() * this.zoom) - ZoomGraphics.TEMP.y;
        return TEMP;
    }
}

