/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.gde.printing.zoom;

import com.togethersoft.selena.gde.printing.zoom.FriendlyFigureUtilities$1;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class FriendlyFigureUtilities {
    private static final float RGB_VALUE_MULTIPLIER = 0.6f;
    private static GC gc;
    private static Font appliedFont;
    private static FontMetrics metrics;
    private static Object LOCK;
    private static Color ghostFillColor;

    public static Color darker(Color color) {
        return new Color(null, (int)((float)color.getRed() * 0.6f), (int)((float)color.getGreen() * 0.6f), (int)((float)color.getBlue() * 0.6f));
    }

    public static FontMetrics getFontMetrics(Font font) {
        FriendlyFigureUtilities.setFont(font);
        return metrics;
    }

    protected static GC getGC() {
        if (gc == null) {
            Object object = LOCK;
            synchronized (object) {
                if (gc == null) {
                    Display.getDefault().syncExec((Runnable)new FriendlyFigureUtilities$1());
                }
            }
        }
        return gc;
    }

    protected static Point getTextDimension(String string, Font font) {
        FriendlyFigureUtilities.setFont(font);
        return FriendlyFigureUtilities.getGC().textExtent(string);
    }

    static int getLargestSubstringConfinedTo(String string, Font font, int n2) {
        FontMetrics fontMetrics = FriendlyFigureUtilities.getFontMetrics(font);
        float f2 = fontMetrics.getAverageCharWidth();
        int n3 = 0;
        int n4 = string.length() + 1;
        int n5 = 0;
        int n6 = 0;
        while (n4 - n3 > 1) {
            if ((n5 += (int)((float)(n2 - n6) / f2)) >= n4) {
                n5 = n4 - 1;
            }
            if (n5 <= n3) {
                n5 = n3 + 1;
            }
            if ((n6 = FriendlyFigureUtilities.getTextExtents((String)string.substring((int)0, (int)n5), (Font)font).width) < n2) {
                n3 = n5;
                continue;
            }
            n4 = n5;
        }
        return n3;
    }

    public static Dimension getTextExtents(String string, Font font) {
        return new Dimension(FriendlyFigureUtilities.getTextDimension(string, font));
    }

    public static int getTextWidth(String string, Font font) {
        return FriendlyFigureUtilities.getTextDimension((String)string, (Font)font).x;
    }

    public static Color lighter(Color color) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        return new Color(null, Math.max(2, Math.min((int)((float)n2 / 0.6f), 255)), Math.max(2, Math.min((int)((float)n3 / 0.6f), 255)), Math.max(2, Math.min((int)((float)n4 / 0.6f), 255)));
    }

    public static Shape makeGhostShape(Shape shape) {
        shape.setBackgroundColor(ghostFillColor);
        shape.setFillXOR(true);
        return shape;
    }

    public static Color mixColors(Color color, Color color2) {
        return new Color(null, (color.getRed() + color2.getRed()) / 2, (color.getGreen() + color2.getGreen()) / 2, (color.getBlue() + color2.getBlue()) / 2);
    }

    public static void paintEtchedBorder(Graphics graphics, Rectangle rectangle, Color color, Color color2) {
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        graphics.setLineStyle(1);
        graphics.setLineWidth(1);
        graphics.setXORMode(false);
        graphics.setForegroundColor(color);
        graphics.drawRectangle(n2, n3, n4 -= 2, n5 -= 2);
        graphics.setForegroundColor(color2);
        graphics.drawRectangle(++n2, ++n3, n4, n5);
    }

    public static void paintEtchedBorder(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getBackgroundColor();
        Color color2 = FriendlyFigureUtilities.darker(color);
        Color color3 = FriendlyFigureUtilities.lighter(color);
        FriendlyFigureUtilities.paintEtchedBorder(graphics, rectangle, color2, color3);
    }

    protected static void setFont(Font font) {
        if (appliedFont == font || font.equals((Object)appliedFont)) {
            return;
        }
        FriendlyFigureUtilities.getGC().setFont(font);
        appliedFont = font;
        metrics = gc.getFontMetrics();
    }

    static GC access$002(GC gC) {
        gc = gC;
        return gc;
    }

    static {
        LOCK = new Object();
        ghostFillColor = new Color(null, 31, 31, 31);
    }
}

