/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.gde.printing.ui;

import com.tssap.selena.gde.internal.DiagramMultiPageViewPart;
import com.tssap.selena.gde.internal.DiagramViewPart;
import com.tssap.selena.gde.internal.GdePlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.enum.ReferenceCollectionEnumeration;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class ScopeModelHelper {
    public static Collection allDiagramsInModel(Model model) {
        LinkedList linkedList = new LinkedList();
        ScopeModelHelper.collectSubdiagrams((Entity)model, linkedList);
        return linkedList;
    }

    public static void collectSubdiagrams(ReferenceCollection referenceCollection, Collection linkedList) {
        if ("Package Diagram".equals(ScopeModelHelper.metaclass((Element)referenceCollection))) {
            linkedList = new LinkedList();
            Entity entity = referenceCollection.getParent();
            ScopeModelHelper.collectSubdiagrams(entity, linkedList);
            linkedList.remove(referenceCollection);
        } else {
            linkedList = Collections.EMPTY_LIST;
        }
    }

    public static Collection openDiagrams() {
        LinkedList<ReferenceCollection> linkedList = new LinkedList<ReferenceCollection>();
        DiagramMultiPageViewPart diagramMultiPageViewPart = GdePlugin.getDefault().getMultiPageViewPart();
        if (diagramMultiPageViewPart != null) {
            int n2 = 0;
            while (n2 < diagramMultiPageViewPart.getPageCount()) {
                DiagramViewPart diagramViewPart = (DiagramViewPart)diagramMultiPageViewPart.getPage(n2);
                ReferenceCollection referenceCollection = (ReferenceCollection)diagramViewPart.getDiagram().getContent();
                linkedList.add(referenceCollection);
                ++n2;
            }
        }
        return linkedList;
    }

    private static Collection childEntities(Entity entity, String string) {
        LinkedList<Entity> linkedList = new LinkedList<Entity>();
        EntityEnumeration entityEnumeration = entity.childEntities();
        while (entityEnumeration.hasMoreElements()) {
            Entity entity2 = entityEnumeration.next();
            if (!string.equals(ScopeModelHelper.metaclass((Element)entity2))) continue;
            linkedList.add(entity2);
        }
        return linkedList;
    }

    private static void collectSubdiagrams(Entity entity, Collection collection) {
        Object object;
        ReferenceCollectionEnumeration referenceCollectionEnumeration = entity.childReferenceCollections();
        while (referenceCollectionEnumeration.hasMoreElements()) {
            object = referenceCollectionEnumeration.next();
            collection.add(object);
        }
        object = ScopeModelHelper.childEntities(entity, "Package").iterator();
        while (object.hasNext()) {
            ScopeModelHelper.collectSubdiagrams((Entity)object.next(), collection);
        }
    }

    private static String metaclass(Element element) {
        return element.getPropertyValue("$metaclass");
    }

    private static String name(Object object) {
        return ((Element)object).getPropertyValue("$name");
    }
}

