/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.gde.printing.ui;

import com.togethersoft.selena.gde.printing.ConstraintException;
import com.togethersoft.selena.gde.printing.DefaultPrinterOptions;
import com.togethersoft.selena.gde.printing.IPrinterDocument;
import com.togethersoft.selena.gde.printing.IPrinterOptions;
import com.togethersoft.selena.gde.printing.a.f;
import com.togethersoft.selena.gde.printing.a.m;
import com.togethersoft.selena.gde.printing.preferences.PrintPreferencePage;
import com.togethersoft.selena.gde.printing.ui.FigureCanvas;
import com.togethersoft.selena.gde.printing.ui.IScopeManager;
import com.togethersoft.selena.gde.printing.ui.Messages;
import com.togethersoft.selena.gde.printing.ui.PreviewDialog$1;
import com.togethersoft.selena.gde.printing.ui.PreviewDialog$2;
import com.togethersoft.selena.gde.printing.ui.PreviewDialogSetup;
import com.togethersoft.selena.gde.printing.ui.PrinterDocumentFigure;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PreviewDialog
extends Dialog {
    public static final int OPTIONS_ID = 1025;
    public static final int PREVIEW_ID = 1026;
    private static final boolean IS_LINUX = System.getProperty("os.name").toLowerCase().startsWith("linux");
    private String title;
    private IPrinterOptions options;
    private Group gPreview;
    private Canvas previewCanvas;
    private Button bPreview;
    private IScopeManager scopeManager;
    private PreviewDialogSetup setup;

    public PreviewDialog(Shell shell, String string, IScopeManager iScopeManager) throws ConstraintException {
        super(shell);
        this.title = string;
        this.getOptions().getConstraints().checkAll();
        this.scopeManager = iScopeManager;
        this.setup = new PreviewDialogSetup(iScopeManager.getSetupPreferencePrefix());
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void buttonPressed(int n2) {
        super.buttonPressed(n2);
        if (1025 == n2) {
            this.optionsPressed();
        } else if (1026 == n2) {
            this.previewPressed();
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.bPreview = this.createButton(composite, 1026, Messages.getString("PreviewDialog.Preview_Button_1"), false);
        this.createButton(composite, 1025, Messages.getString("PreviewDialog.Print_Options..._1"), false);
        this.createButton(composite, 0, Messages.getString("PreviewDialog.Print"), true);
        this.createButton(composite, 1, Messages.getString("PreviewDialog.Cancel"), false);
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.setScope(this.setup.getScope(), false);
        this.setScale(this.setup.getPreviewScale(), true);
        this.setupPreview(this.setup.isPreviewVisible());
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        GridData gridData;
        Combo combo;
        GridData gridData2;
        Group group;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout((Layout)new GridLayout());
        if (this.scopeManager.getCount() > 1) {
            group = new Group(composite2, 0);
            group.setLayout((Layout)new GridLayout());
            gridData2 = new GridData(768);
            gridData2.widthHint = 550;
            group.setLayoutData((Object)gridData2);
            group.setText(this.scopeManager.getTitle());
            combo = this.scopeManager.getDescriptions();
            gridData = new LinkedList();
            int n2 = 0;
            while (n2 < this.scopeManager.getCount()) {
                Button button = new Button((Composite)group, 16);
                button.setText(combo[n2]);
                gridData.add(button);
                ++n2;
            }
            int n3 = this.setup.getScope();
            Button button = (Button)gridData.get(n3);
            if (button != null) {
                button.setSelection(true);
            }
            PreviewDialog$1 previewDialog$1 = new PreviewDialog$1(this, (List)gridData);
            int n4 = 0;
            while (n4 < this.scopeManager.getCount()) {
                ((Button)gridData.get(n4)).addSelectionListener((SelectionListener)previewDialog$1);
                ++n4;
            }
        }
        this.gPreview = new Group(composite2, 0);
        this.gPreview.setText(Messages.getString("PreviewDialog.Preview_2"));
        this.gPreview.setLayout((Layout)new GridLayout());
        this.gPreview.setLayoutData((Object)new GridData(1808));
        this.previewCanvas = IS_LINUX ? new FigureCanvas((Composite)this.gPreview) : new org.eclipse.draw2d.FigureCanvas((Composite)this.gPreview);
        this.previewCanvas.setBackground(ColorConstants.gray);
        this.previewCanvas.setLayoutData((Object)new GridData(1808));
        group = new Composite((Composite)this.gPreview, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        gridData2 = new Label((Composite)group, 0);
        gridData2.setText(Messages.getString("PreviewDialog.Scale"));
        combo = new Combo((Composite)group, 8);
        gridData = new GridData(1);
        combo.setLayoutData((Object)gridData);
        combo.setItems(new String[]{"4:1", "2:1", "1:1", "1:2", "1:4", "1:8", "1:16"});
        combo.setText(this.setup.getPreviewScale());
        combo.addSelectionListener((SelectionListener)new PreviewDialog$2(this, combo));
        return composite2;
    }

    protected IPrinterOptions getOptions() {
        if (this.options == null) {
            this.options = new DefaultPrinterOptions();
        }
        return this.options;
    }

    protected void okPressed() {
        this.setReturnCode(0);
        this.close();
        f f2 = new f();
        f2.print(this.scopeManager.get(this.setup.getScope()), this.getOptions());
    }

    private float getScaleFromText(String string) {
        float f2 = "4:1".equals(string) ? 4.0f : ("2:1".equals(string) ? 2.0f : ("1:2".equals(string) ? 0.5f : ("1:4".equals(string) ? 0.25f : ("1:8".equals(string) ? 0.125f : ("1:16".equals(string) ? 0.0625f : 1.0f)))));
        return f2;
    }

    private void optionsPressed() {
        PrintPreferencePage printPreferencePage = new PrintPreferencePage();
        printPreferencePage.setTitle(Messages.getString("PreviewDialog.Print_2"));
        PreferenceManager preferenceManager = new PreferenceManager();
        preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("com.togethersoft.selena.gde.printing", (IPreferencePage)printPreferencePage));
        PreferenceDialog preferenceDialog = new PreferenceDialog(this.getShell(), preferenceManager);
        preferenceDialog.create();
        preferenceDialog.open();
        DefaultPrinterOptions defaultPrinterOptions = new DefaultPrinterOptions();
        try {
            defaultPrinterOptions.getConstraints().checkAll();
        }
        catch (ConstraintException constraintException) {
            m.a(constraintException);
            return;
        }
        this.options = defaultPrinterOptions;
        this.scopeManager.update(this.options);
        this.setPreviewContents(this.getScaleFromText(this.setup.getPreviewScale()));
    }

    private void setPreviewContents(float f2) {
        if (this.previewCanvas != null) {
            IPrinterDocument iPrinterDocument = this.scopeManager.get(this.setup.getScope());
            PrinterDocumentFigure printerDocumentFigure = PrinterDocumentFigure.create(iPrinterDocument, this.getOptions(), f2);
            if (IS_LINUX) {
                ((FigureCanvas)this.previewCanvas).setContents((IFigure)printerDocumentFigure);
            } else {
                ((org.eclipse.draw2d.FigureCanvas)this.previewCanvas).setContents((IFigure)printerDocumentFigure);
            }
        }
    }

    private void previewPressed() {
        boolean bl = !this.gPreview.isVisible();
        this.setup.setPreviewVisible(bl);
        this.setupPreview(bl);
        this.getShell().pack();
    }

    private void setScale(String string, boolean bl) {
        this.setup.setPreviewScale(string);
        if (bl) {
            this.setPreviewContents(this.getScaleFromText(string));
        }
    }

    private void setScope(int n2, boolean bl) {
        this.setup.setScope(n2);
        if (bl) {
            this.setPreviewContents(this.getScaleFromText(this.setup.getPreviewScale()));
        }
    }

    private void setupPreview(boolean bl) {
        String string;
        GridData gridData = (GridData)this.gPreview.getLayoutData();
        if (bl) {
            gridData.widthHint = 550;
            gridData.heightHint = 400;
            string = Messages.getString("PreviewDialog.Preview_Button_2");
        } else {
            gridData.widthHint = 0;
            gridData.heightHint = 0;
            string = Messages.getString("PreviewDialog.Preview_Button_1");
        }
        this.gPreview.setVisible(bl);
        this.bPreview.setText(string);
    }

    static void access$000(PreviewDialog previewDialog, int n2, boolean bl) {
        previewDialog.setScope(n2, bl);
    }

    static void access$100(PreviewDialog previewDialog, String string, boolean bl) {
        previewDialog.setScale(string, bl);
    }
}

