/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.gde.printing.ui;

import com.togethersoft.selena.gde.printing.ui.FigureCanvas$1;
import com.togethersoft.selena.gde.printing.ui.FigureCanvas$2;
import com.togethersoft.selena.gde.printing.ui.FigureCanvas$3;
import com.togethersoft.selena.gde.printing.ui.FigureCanvas$4;
import com.togethersoft.selena.gde.printing.ui.FigureCanvas$InternalLightweightSystem;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.ScrollPaneSolver;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class FigureCanvas
extends Canvas {
    public static int NEVER = 0;
    public static int AUTOMATIC = 1;
    public static int ALWAYS = 2;
    private static int DEFAULT_INCREMENT = 10;
    private int vBarVisibility = AUTOMATIC;
    private int hBarVisibility = AUTOMATIC;
    private Viewport viewport;
    private int hBarOffset;
    private int vBarOffset;
    private PropertyChangeListener horizontalChangeListener = new FigureCanvas$1(this);
    private PropertyChangeListener verticalChangeListener = new FigureCanvas$2(this);
    private FigureCanvas$InternalLightweightSystem lws;

    public FigureCanvas(Composite composite) {
        super(composite, 1311488);
        this.init();
        this.hookControl();
    }

    public IFigure getContents() {
        return this.getViewport().getContents();
    }

    public int getHorizontalScrollBarVisibility() {
        return this.hBarVisibility;
    }

    public LightweightSystem getLightweightSystem() {
        return this.lws;
    }

    public int getVerticalScrollBarVisibility() {
        return this.vBarVisibility;
    }

    public Viewport getViewport() {
        if (this.viewport == null) {
            this.setViewport(new Viewport(true));
        }
        return this.viewport;
    }

    private void hookControl() {
        this.getHorizontalBar().addSelectionListener((SelectionListener)new FigureCanvas$3(this));
        this.getVerticalBar().addSelectionListener((SelectionListener)new FigureCanvas$4(this));
    }

    private void hookViewport() {
        this.getViewport().getHorizontalRangeModel().addPropertyChangeListener(this.horizontalChangeListener);
        this.getViewport().getVerticalRangeModel().addPropertyChangeListener(this.verticalChangeListener);
    }

    private void unhookViewport() {
        this.getViewport().getHorizontalRangeModel().removePropertyChangeListener(this.horizontalChangeListener);
        this.getViewport().getVerticalRangeModel().removePropertyChangeListener(this.verticalChangeListener);
    }

    private void init() {
        this.lws = new FigureCanvas$InternalLightweightSystem(this);
        this.lws.setControl(this);
        this.getHorizontalBar().setIncrement(DEFAULT_INCREMENT);
        this.getVerticalBar().setIncrement(DEFAULT_INCREMENT);
    }

    private void layoutViewport() {
        ScrollPaneSolver.Result result = ScrollPaneSolver.solve((Rectangle)new Rectangle(this.getBounds()).setLocation(0, 0), (Viewport)this.getViewport(), (int)this.getHorizontalScrollBarVisibility(), (int)this.getVerticalScrollBarVisibility(), (int)this.computeTrim((int)0, (int)0, (int)0, (int)0).width, (int)this.computeTrim((int)0, (int)0, (int)0, (int)0).height);
        if (this.getHorizontalBar().getVisible() != result.showH) {
            this.getHorizontalBar().setVisible(result.showH);
        }
        if (this.getVerticalBar().getVisible() != result.showV) {
            this.getVerticalBar().setVisible(result.showV);
        }
    }

    public void scrollSmoothTo(int n2, int n3) {
        n2 = this.verifyScrollBarOffset(this.getViewport().getHorizontalRangeModel(), n2);
        n3 = this.verifyScrollBarOffset(this.getViewport().getVerticalRangeModel(), n3);
        int n4 = this.getViewport().getViewLocation().x;
        int n5 = this.getViewport().getViewLocation().y;
        int n6 = n2 - n4;
        int n7 = n3 - n5;
        if (n6 == 0 && n7 == 0) {
            return;
        }
        Dimension dimension = this.getViewport().getClientArea().getSize();
        int n8 = 3;
        int n9 = 6;
        if (n6 == 0 || n7 == 0) {
            n8 = 5;
            n9 = 13;
        }
        int n10 = (Math.abs(n6) + Math.abs(n7)) / 15;
        n10 = Math.max(n10, n8);
        n10 = Math.min(n10, n9);
        int n11 = Math.min(n6 / n10, dimension.width / 3);
        int n12 = Math.min(n7 / n10, dimension.height / 3);
        int n13 = 1;
        while (n13 < n10) {
            this.scrollTo(n4 + n13 * n11, n5 + n13 * n12);
            this.getViewport().getUpdateManager().performUpdate();
            ++n13;
        }
        this.scrollTo(n2, n3);
    }

    public void scrollTo(int n2, int n3) {
        n2 = this.verifyScrollBarOffset(this.getViewport().getHorizontalRangeModel(), n2);
        n3 = this.verifyScrollBarOffset(this.getViewport().getVerticalRangeModel(), n3);
        if (n2 == this.getViewport().getViewLocation().x) {
            this.scrollToY(n3);
        } else if (n3 == this.getViewport().getViewLocation().y) {
            this.scrollToX(n2);
        } else {
            this.getViewport().setViewLocation(n2, n3);
        }
    }

    public void scrollToX(int n2) {
        int n3;
        n2 = this.verifyScrollBarOffset(this.getViewport().getHorizontalRangeModel(), n2);
        if (n2 == (n3 = this.getViewport().getViewLocation().x)) {
            return;
        }
        int n4 = -n2 + n3;
        this.getHorizontalBar().setSelection(n2);
        Rectangle rectangle = this.getViewport().getBounds().getCropped(this.getViewport().getInsets());
        Rectangle rectangle2 = rectangle.getResized(-Math.abs(n4), 0);
        Rectangle rectangle3 = rectangle.getCopy();
        Point point = rectangle.getTopLeft();
        rectangle3.width = Math.abs(n4);
        if (n4 < 0) {
            rectangle2.translate(-n4, 0);
            rectangle3.x = point.x + rectangle2.width;
        } else {
            point.x += n4;
        }
        this.scroll(point.x, point.y, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, false);
        this.getViewport().setIgnoreScroll(true);
        this.getViewport().setHorizontalLocation(n2);
        this.getViewport().setIgnoreScroll(false);
        this.redraw(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, true);
    }

    public void scrollToY(int n2) {
        int n3;
        n2 = this.verifyScrollBarOffset(this.getViewport().getVerticalRangeModel(), n2);
        if (n2 == (n3 = this.getViewport().getViewLocation().y)) {
            return;
        }
        int n4 = -n2 + n3;
        this.getVerticalBar().setSelection(n2);
        Rectangle rectangle = this.getViewport().getBounds().getCropped(this.getViewport().getInsets());
        Rectangle rectangle2 = rectangle.getResized(0, -Math.abs(n4));
        Rectangle rectangle3 = rectangle.getCopy();
        Point point = rectangle.getTopLeft();
        rectangle3.height = Math.abs(n4);
        if (n4 < 0) {
            rectangle2.translate(0, -n4);
            rectangle3.y = point.y + rectangle2.height;
        } else {
            point.y += n4;
        }
        this.scroll(point.x, point.y, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, false);
        this.getViewport().setIgnoreScroll(true);
        this.getViewport().setVerticalLocation(n2);
        this.getViewport().setIgnoreScroll(false);
        this.redraw(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, true);
    }

    public void setContents(IFigure iFigure) {
        this.getViewport().setContents(iFigure);
    }

    public void setHorizontalScrollBarVisibility(int n2) {
        this.hBarVisibility = n2;
    }

    public void setScrollBarVisibility(int n2) {
        this.setHorizontalScrollBarVisibility(n2);
        this.setVerticalScrollBarVisibility(n2);
    }

    public void setVerticalScrollBarVisibility(int n2) {
        this.vBarVisibility = n2;
    }

    public void setViewport(Viewport viewport) {
        if (this.viewport != null) {
            this.unhookViewport();
        }
        this.viewport = viewport;
        this.lws.setContents((IFigure)this.viewport);
        this.hookViewport();
    }

    private int verifyScrollBarOffset(RangeModel rangeModel, int n2) {
        n2 = Math.max(rangeModel.getMinimum(), n2);
        return Math.min(rangeModel.getMaximum(), n2);
    }

    static int access$002(FigureCanvas figureCanvas, int n2) {
        figureCanvas.hBarOffset = n2;
        return figureCanvas.hBarOffset;
    }

    static int access$000(FigureCanvas figureCanvas) {
        return figureCanvas.hBarOffset;
    }

    static int access$102(FigureCanvas figureCanvas, int n2) {
        figureCanvas.vBarOffset = n2;
        return figureCanvas.vBarOffset;
    }

    static int access$100(FigureCanvas figureCanvas) {
        return figureCanvas.vBarOffset;
    }

    static void access$300(FigureCanvas figureCanvas) {
        figureCanvas.layoutViewport();
    }
}

