/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.gde.printing.preferences;

import com.togethersoft.selena.gde.printing.ConstraintException;
import com.togethersoft.selena.gde.printing.DefaultPrinterOptions;
import com.togethersoft.selena.gde.printing.PaperDimension;
import com.togethersoft.selena.gde.printing.preferences.Messages;
import com.togethersoft.selena.gde.printing.preferences.PrintPreferencePage$1;
import com.togethersoft.selena.gde.printing.preferences.PrintPreferencePage$ConstrainedBooleanFieldEditor;
import com.togethersoft.selena.gde.printing.preferences.PrintPreferencePage$ConstrainedComboFieldEditor;
import com.togethersoft.selena.gde.printing.preferences.PrintPreferencePage$ConstrainedFieldEditors;
import com.togethersoft.selena.gde.printing.preferences.PrintPreferencePage$ConstrainedStringFieldEditor;
import com.tssap.selena.model.preferences.PreferencesPlugin;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class PrintPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.togethersoft.selena.gde.printing";
    private static final int TEXT_LABEL_WIDTH_HINT = 70;
    private PrintPreferencePage$ConstrainedComboFieldEditor fePaperSize;
    private PrintPreferencePage$ConstrainedComboFieldEditor fePrintOrientation;
    private PrintPreferencePage$ConstrainedBooleanFieldEditor fePrintHeader;
    private PrintPreferencePage$ConstrainedBooleanFieldEditor fePrintFooter;
    private PrintPreferencePage$ConstrainedStringFieldEditor feZoom;
    private PrintPreferencePage$ConstrainedStringFieldEditor feCustomWidth;
    private PrintPreferencePage$ConstrainedStringFieldEditor feCustomHeight;
    private PrintPreferencePage$ConstrainedStringFieldEditor feLeftMargin;
    private PrintPreferencePage$ConstrainedStringFieldEditor feTopMargin;
    private PrintPreferencePage$ConstrainedStringFieldEditor feRightMargin;
    private PrintPreferencePage$ConstrainedStringFieldEditor feBottomMargin;
    private PrintPreferencePage$ConstrainedFieldEditors constrainedFieldEditors = new PrintPreferencePage$ConstrainedFieldEditors();

    public PrintPreferencePage() {
        super(0);
        this.setDescription(Messages.getString("PrintPreferencePage.Print_options_1"));
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        this.setValid(this.checkValidity());
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        WorkbenchHelp.setHelp((Control)control, (String)"com.togethersoft.togetherxj.nonuml.preferences_print_help");
        return control;
    }

    protected boolean checkValidity() {
        int n2;
        int n3;
        int n4;
        int n5;
        Dimension dimension;
        float f2;
        if (!this.constrainedFieldEditors.areLoaded()) {
            return true;
        }
        try {
            f2 = Float.parseFloat(this.feZoom.getStringValue());
            if (f2 <= 0.0f || f2 >= 100.0f) {
                String string = Messages.getString("GeneralPreferencePage.ZoomOutOfBounds");
                this.setErrorMessage(string);
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(Messages.getString("GeneralPreferencePage.Wrong_value"));
            return false;
        }
        catch (NullPointerException nullPointerException) {
            this.setErrorMessage(Messages.getString("GeneralPreferencePage.Missing_option"));
            return false;
        }
        try {
            float f3 = Float.parseFloat(this.feCustomWidth.getStringValue());
            float f4 = Float.parseFloat(this.feCustomHeight.getStringValue());
            dimension = new Dimension((int)(f3 * 72.0f), (int)(f4 * 72.0f));
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(Messages.getString("CustomPaperSizePreferencePage.Wrong_values"));
            return false;
        }
        catch (NullPointerException nullPointerException) {
            this.setErrorMessage(Messages.getString("CustomPaperSizePreferencePage.Missing_option"));
            return false;
        }
        try {
            float f5 = Float.parseFloat(this.feTopMargin.getStringValue());
            n5 = (int)(f5 * 72.0f);
            float f6 = Float.parseFloat(this.feBottomMargin.getStringValue());
            n4 = (int)(f6 * 72.0f);
            float f7 = Float.parseFloat(this.feLeftMargin.getStringValue());
            n3 = (int)(f7 * 72.0f);
            float f8 = Float.parseFloat(this.feRightMargin.getStringValue());
            n2 = (int)(f8 * 72.0f);
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(Messages.getString("MarginsPreferencePage.Wrong_values"));
            return false;
        }
        catch (NullPointerException nullPointerException) {
            this.setErrorMessage(Messages.getString("MarginsPreferencePage.Missing_option"));
            return false;
        }
        DefaultPrinterOptions defaultPrinterOptions = new DefaultPrinterOptions();
        try {
            defaultPrinterOptions.getConstraints().checkAll(PaperDimension.getByDescription(this.fePaperSize.getComboBoxControl(null).getText()), this.fePrintHeader.getBooleanValue(), this.fePrintFooter.getBooleanValue(), f2, n5, n4, n3, n2);
            defaultPrinterOptions.getConstraints().checkPageDimension(dimension);
        }
        catch (ConstraintException constraintException) {
            this.setErrorMessage(constraintException.getMessage());
            return false;
        }
        return true;
    }

    protected void contributeButtons(Composite composite) {
        ++((GridLayout)composite.getLayout()).numColumns;
        Button button = new Button(composite, 8);
        button.setText(Messages.getString("PrintPreferencePage.Synchronize_with_Default_Printer_Options_1"));
        GridData gridData = new GridData();
        gridData.heightHint = this.convertVerticalDLUsToPixels(14);
        int n2 = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(n2, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new PrintPreferencePage$1(this));
    }

    protected Label createDescriptionLabel(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 131072);
        label.setImage(this.getImage());
        label.setLayoutData((Object)new GridData(32));
        Label label2 = new Label(composite2, 0);
        label2.setFont(composite.getFont());
        String string = this.getDescription();
        if (string != null) {
            label2.setText(string);
        }
        label2.setLayoutData((Object)new GridData(768));
        return null;
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        TabFolder tabFolder = new TabFolder(composite, 128);
        GridData gridData2 = new GridData(1808);
        tabFolder.setLayoutData((Object)gridData2);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.getString("PrintPreferencePage.General_5"));
        Composite composite2 = this.createTabComposite(tabFolder);
        this.createGeneralPage(composite2);
        tabItem.setControl((Control)composite2);
        TabItem tabItem2 = new TabItem(tabFolder, 0);
        tabItem2.setText(Messages.getString("PrintPreferencePage.Custom_Paper_Size_6"));
        Composite composite3 = this.createTabComposite(tabFolder);
        this.createCustomPaperSizePage(composite3);
        tabItem2.setControl((Control)composite3);
        TabItem tabItem3 = new TabItem(tabFolder, 0);
        tabItem3.setText(Messages.getString("PrintPreferencePage.Margins_7"));
        Composite composite4 = this.createTabComposite(tabFolder);
        this.createMarginsPage(composite4);
        tabItem3.setControl((Control)composite4);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return PreferencesPlugin.getPreferenceStore((String)"workspace", null);
    }

    private void createGeneralPage(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayoutData((Object)new GridData(768));
        this.fePaperSize = new PrintPreferencePage$ConstrainedComboFieldEditor("pp_paper_size", Messages.getString("GeneralPreferencePage.Paper_size_2"), new String[][]{{PaperDimension.CUSTOM.getDescription(), PaperDimension.CUSTOM.getValue()}, {PaperDimension.A0.getDescription(), PaperDimension.A0.getValue()}, {PaperDimension.A1.getDescription(), PaperDimension.A1.getValue()}, {PaperDimension.A2.getDescription(), PaperDimension.A2.getValue()}, {PaperDimension.A3.getDescription(), PaperDimension.A3.getValue()}, {PaperDimension.A4.getDescription(), PaperDimension.A4.getValue()}, {PaperDimension.A5.getDescription(), PaperDimension.A5.getValue()}, {PaperDimension.B5.getDescription(), PaperDimension.B5.getValue()}, {PaperDimension.LETTER.getDescription(), PaperDimension.LETTER.getValue()}, {PaperDimension.LEGAL.getDescription(), PaperDimension.LEGAL.getValue()}, {PaperDimension.EXECUTIVE.getDescription(), PaperDimension.EXECUTIVE.getValue()}, {PaperDimension.ENV_DL.getDescription(), PaperDimension.ENV_DL.getValue()}, {PaperDimension.A.getDescription(), PaperDimension.A.getValue()}, {PaperDimension.B.getDescription(), PaperDimension.B.getValue()}, {PaperDimension.C.getDescription(), PaperDimension.C.getValue()}, {PaperDimension.D.getDescription(), PaperDimension.D.getValue()}, {PaperDimension.E.getDescription(), PaperDimension.E.getValue()}}, composite2);
        this.constrainedFieldEditors.add(this.fePaperSize);
        this.addField((FieldEditor)this.fePaperSize);
        this.fePrintOrientation = new PrintPreferencePage$ConstrainedComboFieldEditor("pp_print_orientation", Messages.getString("GeneralPreferencePage.Print_orientation_4"), new String[][]{{Messages.getString("GeneralPreferencePage.Portrait_5"), "portrait"}, {Messages.getString("GeneralPreferencePage.Landscape_6"), "landscape"}}, composite2);
        this.constrainedFieldEditors.add(this.fePrintOrientation);
        this.addField((FieldEditor)this.fePrintOrientation);
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout((Layout)new GridLayout());
        composite3.setLayoutData((Object)new GridData(768));
        PrintPreferencePage$ConstrainedBooleanFieldEditor printPreferencePage$ConstrainedBooleanFieldEditor = new PrintPreferencePage$ConstrainedBooleanFieldEditor("pp_print_border", Messages.getString("GeneralPreferencePage.Print_border_7"), composite3);
        this.constrainedFieldEditors.add(printPreferencePage$ConstrainedBooleanFieldEditor);
        this.addField((FieldEditor)printPreferencePage$ConstrainedBooleanFieldEditor);
        this.fePrintHeader = new PrintPreferencePage$ConstrainedBooleanFieldEditor("pp_print_header", Messages.getString("GeneralPreferencePage.Print_header_8"), composite3);
        this.constrainedFieldEditors.add(this.fePrintHeader);
        this.addField((FieldEditor)this.fePrintHeader);
        String string = Messages.getString("PrintPreferencePage.The_following_system_macros_can_be_used_inside_the_text__n_%PAGE%_-_page_number,_n_%PROJECT%_-_project_name,_n_%ELEMENT%_-_element_name,_n_%DATE%_-_current_date,_n_%TIME%_-_current_time._8");
        Composite composite4 = new Composite(composite3, 0);
        composite4.setLayout((Layout)new GridLayout(2, true));
        GridData gridData = new GridData(768);
        composite4.setLayoutData((Object)gridData);
        PrintPreferencePage$ConstrainedStringFieldEditor printPreferencePage$ConstrainedStringFieldEditor = new PrintPreferencePage$ConstrainedStringFieldEditor("pp_header_text", Messages.getString("PrintPreferencePage.Header_text_9"), composite4);
        GridData gridData2 = new GridData();
        gridData2.widthHint = 70;
        printPreferencePage$ConstrainedStringFieldEditor.getLabelControl(composite4).setLayoutData((Object)gridData2);
        printPreferencePage$ConstrainedStringFieldEditor.getTextControl(composite4).setToolTipText(string);
        this.constrainedFieldEditors.add(printPreferencePage$ConstrainedStringFieldEditor);
        this.addField((FieldEditor)printPreferencePage$ConstrainedStringFieldEditor);
        this.fePrintFooter = new PrintPreferencePage$ConstrainedBooleanFieldEditor("pp_print_footer", Messages.getString("GeneralPreferencePage.Print_footer_9"), composite3);
        this.constrainedFieldEditors.add(this.fePrintFooter);
        this.addField((FieldEditor)this.fePrintFooter);
        Composite composite5 = new Composite(composite3, 0);
        composite5.setLayout((Layout)new GridLayout(2, true));
        GridData gridData3 = new GridData(768);
        composite5.setLayoutData((Object)gridData3);
        PrintPreferencePage$ConstrainedStringFieldEditor printPreferencePage$ConstrainedStringFieldEditor2 = new PrintPreferencePage$ConstrainedStringFieldEditor("pp_footer_text", Messages.getString("PrintPreferencePage.Footer_text_10"), composite5);
        GridData gridData4 = new GridData();
        gridData4.widthHint = 70;
        printPreferencePage$ConstrainedStringFieldEditor2.getLabelControl(composite5).setLayoutData((Object)gridData4);
        printPreferencePage$ConstrainedStringFieldEditor2.getTextControl(composite5).setToolTipText(string);
        this.constrainedFieldEditors.add(printPreferencePage$ConstrainedStringFieldEditor2);
        this.addField((FieldEditor)printPreferencePage$ConstrainedStringFieldEditor2);
        PrintPreferencePage$ConstrainedBooleanFieldEditor printPreferencePage$ConstrainedBooleanFieldEditor2 = new PrintPreferencePage$ConstrainedBooleanFieldEditor("pp_print_empty_pages", Messages.getString("GeneralPreferencePage.Print_empty_pages_10"), composite3);
        this.constrainedFieldEditors.add(printPreferencePage$ConstrainedBooleanFieldEditor2);
        this.addField((FieldEditor)printPreferencePage$ConstrainedBooleanFieldEditor2);
        PrintPreferencePage$ConstrainedBooleanFieldEditor printPreferencePage$ConstrainedBooleanFieldEditor3 = new PrintPreferencePage$ConstrainedBooleanFieldEditor("pp_fit_to_page", Messages.getString("GeneralPreferencePage.Fit_to_page_11"), composite3);
        this.constrainedFieldEditors.add(printPreferencePage$ConstrainedBooleanFieldEditor3);
        this.addField((FieldEditor)printPreferencePage$ConstrainedBooleanFieldEditor3);
        Composite composite6 = new Composite(composite, 0);
        composite6.setLayout((Layout)new GridLayout(2, true));
        composite6.setLayoutData((Object)new GridData(768));
        this.feZoom = new PrintPreferencePage$ConstrainedStringFieldEditor("pp_print_zoom", Messages.getString("GeneralPreferencePage.Print_zoom_12"), composite6);
        GridData gridData5 = new GridData();
        gridData5.widthHint = 70;
        this.feZoom.getLabelControl(composite6).setLayoutData((Object)gridData5);
        this.constrainedFieldEditors.add(this.feZoom);
        this.addField((FieldEditor)this.feZoom);
    }

    private void createCustomPaperSizePage(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        this.feCustomWidth = new PrintPreferencePage$ConstrainedStringFieldEditor("pp_custom_width", Messages.getString("CustomPaperSizePreferencePage.Width"), composite2);
        this.constrainedFieldEditors.add(this.feCustomWidth);
        this.addField((FieldEditor)this.feCustomWidth);
        GridData gridData = new GridData();
        gridData.widthHint = 70;
        this.feCustomWidth.getLabelControl(composite2).setLayoutData((Object)gridData);
        this.feCustomHeight = new PrintPreferencePage$ConstrainedStringFieldEditor("pp_custom_height", Messages.getString("CustomPaperSizePreferencePage.Height"), composite2);
        this.constrainedFieldEditors.add(this.feCustomHeight);
        this.addField((FieldEditor)this.feCustomHeight);
    }

    private void createMarginsPage(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        this.feTopMargin = new PrintPreferencePage$ConstrainedStringFieldEditor("pp_top_margin", Messages.getString("MarginsPreferencePage.Top"), composite2);
        this.constrainedFieldEditors.add(this.feTopMargin);
        this.addField((FieldEditor)this.feTopMargin);
        GridData gridData = new GridData();
        gridData.widthHint = 70;
        this.feTopMargin.getLabelControl(composite2).setLayoutData((Object)gridData);
        this.feBottomMargin = new PrintPreferencePage$ConstrainedStringFieldEditor("pp_bottom_margin", Messages.getString("MarginsPreferencePage.Bottom"), composite2);
        this.constrainedFieldEditors.add(this.feBottomMargin);
        this.addField((FieldEditor)this.feBottomMargin);
        this.feLeftMargin = new PrintPreferencePage$ConstrainedStringFieldEditor("pp_left_margin", Messages.getString("MarginsPreferencePage.Left"), composite2);
        this.constrainedFieldEditors.add(this.feLeftMargin);
        this.addField((FieldEditor)this.feLeftMargin);
        this.feRightMargin = new PrintPreferencePage$ConstrainedStringFieldEditor("pp_right_margin", Messages.getString("MarginsPreferencePage.Right"), composite2);
        this.constrainedFieldEditors.add(this.feRightMargin);
        this.addField((FieldEditor)this.feRightMargin);
    }

    private Composite createTabComposite(TabFolder tabFolder) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        return composite;
    }

    private void synchronizeWithDefaultPrinterOptions() {
        String string;
        String string2;
        String string3;
        PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
        PaperDimension paperDimension = PaperDimension.get((int)pageFormat.getWidth(), (int)pageFormat.getHeight());
        String string4 = string3 = paperDimension == null ? PaperDimension.CUSTOM.getDescription() : paperDimension.getDescription();
        if (pageFormat.getOrientation() == 1) {
            string2 = "portrait";
            string = Messages.getString("GeneralPreferencePage.Portrait_5");
        } else {
            string2 = "landscape";
            string = Messages.getString("GeneralPreferencePage.Landscape_6");
        }
        MessageBox messageBox = new MessageBox(this.getShell(), 288);
        messageBox.setText(Messages.getString("PrintPreferencePage.Default_Printer_Options_4"));
        messageBox.setMessage(Messages.getString("PrintPreferencePage.Paper_Size___5") + string3 + "\n" + Messages.getString("PrintPreferencePage.Orientation___7") + string);
        int n2 = messageBox.open();
        if (n2 == 32) {
            if (paperDimension == null) {
                this.fePaperSize.updateComboForValue(PaperDimension.CUSTOM.getValue());
                float f2 = (float)(pageFormat.getWidth() / 72.0);
                float f3 = (float)(pageFormat.getHeight() / 72.0);
                this.feCustomWidth.getTextControl().setText(Float.toString(f2));
                this.feCustomHeight.getTextControl().setText(Float.toString(f3));
            } else {
                this.fePaperSize.updateComboForValue(paperDimension.getValue());
            }
            this.fePrintOrientation.updateComboForValue(string2);
        }
    }

    static void access$000(PrintPreferencePage printPreferencePage) {
        printPreferencePage.synchronizeWithDefaultPrinterOptions();
    }
}

