/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.gde.printing;

import com.togethersoft.selena.gde.printing.DefaultPrinterOptions$Constraints;
import com.togethersoft.selena.gde.printing.IPrinterOptionConstraints;
import com.togethersoft.selena.gde.printing.PaperDimension;
import com.togethersoft.selena.gde.printing.a.k;
import com.tssap.selena.model.preferences.PreferencesPlugin;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.preference.IPreferenceStore;

public class DefaultPrinterOptions
extends k {
    public static final Dimension MIN_BODY = new Dimension(50, 50);
    private IPreferenceStore prefStore = PreferencesPlugin.getPreferenceStore((String)"workspace", null);
    private Dimension pageDimension;
    private int printOrientation;
    private float printZoom;
    private IPrinterOptionConstraints constraints = new DefaultPrinterOptions$Constraints(this);

    public DefaultPrinterOptions() {
        this.init();
    }

    public int getBottomMargin() {
        return Math.round(this.getFloat("pp_bottom_margin", 1.0f) * 72.0f);
    }

    public int getLeftMargin() {
        return Math.round(this.getFloat("pp_left_margin", 1.0f) * 72.0f);
    }

    public Dimension getPageDimension() {
        return this.pageDimension;
    }

    public int getPrintOrientation() {
        return this.printOrientation;
    }

    public int getCustomWidth() {
        return Math.round(this.getFloat("pp_custom_width", 8.5f) * 72.0f);
    }

    public int getCustomHeight() {
        return Math.round(this.getFloat("pp_custom_height", 11.0f) * 72.0f);
    }

    public int getRightMargin() {
        return Math.round(this.getFloat("pp_right_margin", 1.0f) * 72.0f);
    }

    public int getTopMargin() {
        return Math.round(this.getFloat("pp_top_margin", 1.0f) * 72.0f);
    }

    public boolean printBorder() {
        return this.prefStore.getBoolean("pp_print_border");
    }

    public boolean printFooter() {
        return this.prefStore.getBoolean("pp_print_footer");
    }

    public boolean printHeader() {
        return this.prefStore.getBoolean("pp_print_header");
    }

    public String getFooterText() {
        return this.prefStore.getString("pp_footer_text");
    }

    public String getHeaderText() {
        return this.prefStore.getString("pp_header_text");
    }

    public boolean fitToPage() {
        return this.prefStore.getBoolean("pp_fit_to_page");
    }

    public float getPrintZoom() {
        return this.printZoom;
    }

    public boolean printEmptyPages() {
        return this.prefStore.getBoolean("pp_print_empty_pages");
    }

    public IPrinterOptionConstraints getConstraints() {
        return this.constraints;
    }

    private float getFloat(String string, float f2) {
        String string2 = this.prefStore.getString(string);
        float f3 = f2;
        try {
            f3 = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return f3;
    }

    private void init() {
        String string = this.prefStore.getString("pp_print_orientation");
        this.printOrientation = this.a(string);
        string = this.prefStore.getString("pp_paper_size");
        this.pageDimension = PaperDimension.getByValue(string);
        if (this.pageDimension == null) {
            this.pageDimension = PaperDimension.A4.getCopy();
        } else if (PaperDimension.CUSTOM.equals(this.pageDimension)) {
            this.pageDimension = new Dimension(this.getCustomWidth(), this.getCustomHeight());
        }
        if (this.printOrientation == 2) {
            this.pageDimension.transpose();
        }
        this.printZoom = this.getFloat("pp_print_zoom", 1.0f);
        if (this.printZoom == 0.0f) {
            this.printZoom = 1.0f;
        }
    }

    static Rectangle access$001(Dimension dimension, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        return k.c(dimension, n2, n3, n4, n5, bl, bl2);
    }

    static Rectangle access$101(Dimension dimension, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        return k.b(dimension, n2, n3, n4, n5, bl, bl2);
    }

    static Rectangle access$201(Dimension dimension, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        return k.a(dimension, n2, n3, n4, n5, bl, bl2);
    }

    static float access$300(DefaultPrinterOptions defaultPrinterOptions) {
        return defaultPrinterOptions.printZoom;
    }
}

