/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.util.warning;

import com.sap.cms.util.logging.CmsLogger;
import com.sap.cms.util.warning.WarningMessage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

public class WarningContainer
implements Serializable {
    private boolean warningFlag = false;
    private Vector messages = new Vector();
    private HashMap messageHashMap = new HashMap();

    public void addWarning(WarningMessage msg) {
        this.warningFlag = true;
        if (!this.messageHashMap.containsKey(msg.getMessage())) {
            this.messageHashMap.put(msg.getMessage(), msg.getMessage());
            this.messages.add(msg);
        }
    }

    public void addWarningContainer(WarningContainer container) {
        Vector messageVector = container.getMessages();
        int i = 0;
        while (i < messageVector.size()) {
            this.addWarning((WarningMessage)messageVector.get(i));
            ++i;
        }
    }

    public Vector getMessages() {
        return this.messages;
    }

    public boolean isWarningFlag() {
        return this.warningFlag;
    }

    public void toLog(CmsLogger log) {
        log.warning("Warning flag: " + this.warningFlag);
        int i = 0;
        while (i < this.messages.size()) {
            log.warning("" + (i + 1) + ": " + ((WarningMessage)this.messages.get(i)).getType() + "  " + ((WarningMessage)this.messages.get(i)).getMessage());
            ++i;
        }
    }

    public void toInfo(CmsLogger log) {
        log.warning("Warning flag: " + this.warningFlag);
        int i = 0;
        while (i < this.messages.size()) {
            log.warning("" + (i + 1) + ": " + ((WarningMessage)this.messages.get(i)).getType() + "  " + ((WarningMessage)this.messages.get(i)).getMessage());
            ++i;
        }
    }
}

