/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.util.logging;

import com.sap.cms.util.logging.CmsSeverity;
import com.sap.cms.util.logging.TraceLevel;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.PropertiesConfigurator;
import com.sap.tc.logging.TraceFormatter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

public class CmsLogger {
    private Location loc = null;
    private Category cat = null;
    GregorianCalendar cale;
    boolean fileLog = false;
    boolean println = false;
    private final Map fileLogMap = new HashMap();
    private static final TraceFormatter LOG_FILE_FORMATTER = new TraceFormatter("%24d %7s: %m");
    private String className = null;

    public static CmsLogger getLogger(String className) {
        CmsLogger cmsLogger = new CmsLogger(className);
        return cmsLogger;
    }

    public static CmsLogger getLogger(String className, boolean readProperties) {
        if (readProperties) {
            PropertiesConfigurator pC = new PropertiesConfigurator(new File(".\\saplogging.config"));
            pC.configure();
        }
        CmsLogger cmsLogger = new CmsLogger(className);
        return cmsLogger;
    }

    CmsLogger(String className) {
        this.className = className;
        String application = null;
        this.loc = Location.getLocation((String)className);
        if (className.indexOf("com.sap.cms.pcs") != -1) {
            application = "/Applications/CMS/PCS";
        }
        if (className.indexOf("com.sap.cms.tcs") != -1) {
            application = "/Applications/CMS/TCS";
        }
        if (className.indexOf("com.sap.sdm") != -1) {
            application = "/Applications/CMS/SDM";
        }
        if (className.indexOf("com.sap.cms.tcs.beans") != -1 || className.indexOf("com.sap.cms.tcs.client") != -1 || className.indexOf("com.sap.cms.tcs.core.TCSFileSystem") != -1) {
            application = "/Applications/TCSDeployer";
        }
        if (application == null) {
            application = "/Applications/CMS";
        }
        this.cat = Category.getCategory((String)application);
        this.cale = new GregorianCalendar();
        this.loc.pathT(this.cale.get(11) + ":" + this.cale.get(12) + ":" + this.cale.get(13) + " " + application + " entering class " + className);
    }

    public void startLoggingTo(String logFileName) {
        if (logFileName == null) {
            return;
        }
        if (this.fileLogMap.containsKey(logFileName)) {
            this.loc.addLog((Log)((FileLog)this.fileLogMap.get(logFileName)));
            return;
        }
        FileLog additionalFileLog = new FileLog(logFileName, (Formatter)LOG_FILE_FORMATTER, true);
        this.loc.addLog((Log)additionalFileLog);
        this.fileLogMap.put(logFileName, additionalFileLog);
    }

    public void endLoggingTo(String logFileName) {
        if (logFileName == null) {
            return;
        }
        FileLog additionalFileLog = (FileLog)this.fileLogMap.get(logFileName);
        if (additionalFileLog == null) {
            return;
        }
        try {
            this.loc.removeLog((Log)additionalFileLog);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static CmsLogger getLogger() {
        CmsLogger cmsLogger = new CmsLogger();
        return cmsLogger;
    }

    CmsLogger() {
        this.loc = Location.getLocation((String)"cms");
        this.cat = Category.getCategory((String)"/CMSLogs");
        this.fileLog = true;
    }

    public void newFile(String file) {
        if (this.fileLog) {
            FileLog fileLog = new FileLog(file);
            fileLog.setFormatter((Formatter)LOG_FILE_FORMATTER);
            this.cat.removeLogs();
            this.cat.addPrivateLog((Log)fileLog);
            this.cat.setEffectiveSeverity(300);
        }
    }

    public Category getCategory() {
        return this.cat;
    }

    public void entering(String method) {
        if (this.loc.getEffectiveSeverity((LogController)this.loc) <= 200) {
            this.cale = new GregorianCalendar();
            this.cmstrace(TraceLevel.PATH, "", "-> " + this.cale.get(11) + ":" + this.cale.get(12) + ":" + this.cale.get(13) + " -> entering " + method, null);
        }
    }

    public void entering(String method, Object[] args) {
        if (this.loc.getEffectiveSeverity((LogController)this.loc) <= 200) {
            this.cale = new GregorianCalendar();
            StringBuffer argList = new StringBuffer(40);
            if (args != null && args.length > 0) {
                if (args[0] != null) {
                    argList.append(args[0].toString());
                } else {
                    argList.append("null");
                }
                int i = 1;
                while (i < args.length) {
                    argList.append(", ");
                    if (args[i] != null) {
                        argList.append(args[i].toString());
                    } else {
                        argList.append("null");
                    }
                    ++i;
                }
            }
            argList.append(')');
            this.cmstrace(TraceLevel.PATH, "", "-> " + this.cale.get(11) + ":" + this.cale.get(12) + ":" + this.cale.get(13) + " -> entering " + method + argList.toString(), null);
        }
    }

    public void exiting(String method) {
        this.cmstrace(TraceLevel.PATH, "", "<--- exiting " + method, null);
    }

    public void exiting(String method, Object returnValue) {
        String myReturn = "null";
        if (returnValue != null) {
            myReturn = returnValue.toString();
        }
        this.cmstrace(TraceLevel.PATH, "", "<--- exiting " + method + " (" + myReturn + ")", null);
    }

    public void exiting(String method, String returnValue) {
        this.cmstrace(TraceLevel.PATH, "", "<--- exiting " + method + " (" + returnValue + ")", null);
    }

    public void path(String message) {
        this.cmstrace(TraceLevel.PATH, "", message, null);
    }

    public void path(String user, String message) {
        this.cmstrace(TraceLevel.PATH, user, message, null);
    }

    public void debug(String message) {
        this.cmstrace(TraceLevel.DEBUG, "", message, null);
    }

    public void debug(Throwable throwable) {
        this.cmstrace(TraceLevel.DEBUG, "", "", throwable);
    }

    public void debug(String message, Throwable throwable) {
        this.cmstrace(TraceLevel.DEBUG, "", message, throwable);
    }

    public void debug(String user, String message) {
        this.cmstrace(TraceLevel.DEBUG, user, message, null);
    }

    public void debug(String user, String message, Throwable throwable) {
        this.cmstrace(TraceLevel.DEBUG, user, message, throwable);
    }

    public void trace(TraceLevel traceLevel, String message) {
        this.cmstrace(traceLevel, "", message, null);
    }

    public void trace(TraceLevel traceLevel, Throwable throwable) {
        this.cmstrace(traceLevel, "", "", throwable);
    }

    public void trace(TraceLevel traceLevel, String message, Throwable throwable) {
        this.cmstrace(traceLevel, "", message, throwable);
    }

    public void trace(TraceLevel traceLevel, String user, String message) {
        this.cmstrace(traceLevel, user, message, null);
    }

    public void trace(TraceLevel traceLevel, String user, String message, Throwable throwable) {
        this.cmstrace(traceLevel, user, message, throwable);
    }

    public void trace(String message) {
        this.cmstrace(TraceLevel.DEBUG, "", message, null);
    }

    public void trace(Throwable throwable) {
        this.cmstrace(TraceLevel.DEBUG, "", "", throwable);
    }

    public void trace(String message, Throwable throwable) {
        this.cmstrace(TraceLevel.DEBUG, "", message, throwable);
    }

    public void trace(String user, String message) {
        this.cmstrace(TraceLevel.DEBUG, user, message, null);
    }

    public void trace(String user, String message, Throwable throwable) {
        this.cmstrace(TraceLevel.DEBUG, user, message, throwable);
    }

    private void cmstrace(TraceLevel traceLevel, String user, String message, Throwable throwable) {
        if (this.loc.getEffectiveSeverity((LogController)this.loc) <= 200 || this.println) {
            String msg = user.toString().equalsIgnoreCase("") ? message : "User=" + user + " Msg=" + message;
            switch (traceLevel.intValue()) {
                case 1: {
                    if (throwable != null) {
                        msg = msg.toString().equalsIgnoreCase("") ? "Exc=" + throwable.toString() : msg + " Exc=" + throwable.toString();
                    }
                    if (this.println) {
                        System.out.println("CMS Path >" + msg);
                    }
                    this.loc.pathT(msg);
                    break;
                }
                case 2: {
                    if (this.loc.getEffectiveSeverity((LogController)this.loc) > 100 && !this.println) break;
                    if (throwable != null) {
                        ByteArrayOutputStream stream = new ByteArrayOutputStream();
                        PrintWriter printWriter = new PrintWriter(stream);
                        throwable.printStackTrace(printWriter);
                        printWriter.flush();
                        String stringException = stream.toString();
                        printWriter.close();
                        msg = msg.toString().equalsIgnoreCase("") ? "Exc=" + stringException : msg + " Exc=" + stringException;
                    }
                    if (this.println) {
                        System.out.println("CMS Debug>" + msg);
                    }
                    this.loc.debugT("  " + msg);
                    break;
                }
                default: {
                    if (this.println) {
                        System.out.println("CMS Path>" + msg);
                    }
                    this.loc.pathT(msg);
                }
            }
        }
        if (throwable != null) {
            this.cat.logThrowableT(500, this.loc, message, throwable);
        }
    }

    public void info(String message) {
        this.cmsalert(CmsSeverity.INFO, "", message, null);
    }

    public void info(Throwable throwable) {
        this.cmsalert(CmsSeverity.INFO, "", "", throwable);
    }

    public void info(String message, Throwable throwable) {
        this.cmsalert(CmsSeverity.INFO, "", message, throwable);
    }

    public void info(String user, String message) {
        this.cmsalert(CmsSeverity.INFO, user, message, null);
    }

    public void info(String user, String message, Throwable throwable) {
        this.cmsalert(CmsSeverity.INFO, user, message, throwable);
    }

    public void warning(String message) {
        this.cmsalert(CmsSeverity.WARNING, "", message, null);
    }

    public void warning(Throwable throwable) {
        this.cmsalert(CmsSeverity.WARNING, "", "", throwable);
    }

    public void warning(String message, Throwable throwable) {
        this.cmsalert(CmsSeverity.WARNING, "", message, throwable);
    }

    public void warning(String user, String message) {
        this.cmsalert(CmsSeverity.WARNING, user, message, null);
    }

    public void warning(String user, String message, Throwable throwable) {
        this.cmsalert(CmsSeverity.WARNING, user, message, throwable);
    }

    public void error(String message) {
        this.cmsalert(CmsSeverity.ERROR, "", message, null);
    }

    public void error(Throwable throwable) {
        this.cmsalert(CmsSeverity.ERROR, "", "", throwable);
    }

    public void error(String message, Throwable throwable) {
        this.cmsalert(CmsSeverity.ERROR, "", message, throwable);
    }

    public void error(String user, String message) {
        this.cmsalert(CmsSeverity.ERROR, user, message, null);
    }

    public void error(String user, String message, Throwable throwable) {
        this.cmsalert(CmsSeverity.ERROR, user, message, throwable);
    }

    public void fatal(String message) {
        this.cmsalert(CmsSeverity.FATAL, "", message, null);
    }

    public void fatal(Throwable throwable) {
        this.cmsalert(CmsSeverity.FATAL, "", "", throwable);
    }

    public void fatal(String message, Throwable throwable) {
        this.cmsalert(CmsSeverity.FATAL, "", message, throwable);
    }

    public void fatal(String user, String message) {
        this.cmsalert(CmsSeverity.FATAL, user, message, null);
    }

    public void fatal(String user, String message, Throwable throwable) {
        this.cmsalert(CmsSeverity.FATAL, user, message, throwable);
    }

    public void alert(CmsSeverity severity, String message) {
        this.cmsalert(severity, "", message, null);
    }

    public void alert(CmsSeverity severity, Throwable throwable) {
        this.cmsalert(severity, "", "", throwable);
    }

    public void alert(CmsSeverity severity, String message, Throwable throwable) {
        this.cmsalert(severity, "", message, throwable);
    }

    public void alert(CmsSeverity severity, String user, String message) {
        this.cmsalert(severity, user, message, null);
    }

    public void alert(CmsSeverity severity, String user, String message, Throwable throwable) {
        this.cmsalert(severity, user, message, throwable);
    }

    public void log(String message) {
        this.cat.infoT(this.loc, message);
    }

    public void log(String user, String message) {
        this.cat.infoT(this.loc, "User=" + user + " Msg=" + message);
    }

    public void alert(String message) {
        this.cmsalert(CmsSeverity.ERROR, "", message, null);
    }

    public void alert(Throwable throwable) {
        this.cmsalert(CmsSeverity.ERROR, "", "", throwable);
    }

    public void alert(String message, Throwable throwable) {
        this.cmsalert(CmsSeverity.ERROR, "", message, throwable);
    }

    public void alert(String user, String message) {
        this.cmsalert(CmsSeverity.ERROR, user, message, null);
    }

    public void alert(String user, String message, Throwable throwable) {
        this.cmsalert(CmsSeverity.ERROR, user, message, throwable);
    }

    private void cmsalert(CmsSeverity severity, String user, String message, Throwable throwable) {
        String msg = user.toString() == "" ? message : "User=" + user + " Msg=" + message;
        if (throwable != null) {
            msg = msg.toString().equalsIgnoreCase("") ? "Exc=" + throwable.toString() : msg + " Exc=" + throwable.toString();
        }
        switch (severity.intValue()) {
            case 1: {
                if (this.println) {
                    System.out.println("CMS Fatal>" + msg);
                }
                this.cat.fatalT(this.loc, msg);
                break;
            }
            case 2: {
                if (this.println) {
                    System.out.println("CMS Error>" + msg);
                }
                this.cat.errorT(this.loc, msg);
                break;
            }
            case 3: {
                if (this.println) {
                    System.out.println("CMS Warning>" + msg);
                }
                this.cat.warningT(this.loc, msg);
                break;
            }
            case 4: {
                if (this.println) {
                    System.out.println("CMS Info>" + msg);
                }
                this.cat.infoT(this.loc, msg);
                break;
            }
            default: {
                if (this.println) {
                    System.out.println("CMS Error>" + msg);
                }
                this.cat.errorT(this.loc, msg);
            }
        }
        if (throwable != null) {
            this.cmstrace(TraceLevel.DEBUG, "", "stack trace:", throwable);
        }
    }
}

