/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.util;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

public class PCSTime {
    public static final String TS_MILLI_FORMAT = "yyyyMMddHHmmssSSSS";
    public static final String TS_SEC_FORMAT = "yyyyMMddHHmmss";
    public static final String YEAR_SEC_FORMAT = "yyyy/MM/dd HH:mm:ss";
    public static final String HOUR_SEC_FORMAT = "HH:mm:ss";
    public static final String DATE_FORMAT = "yyyyMMdd";
    public static final String UPDATE_VERSION_FORMAT = "MMddHHmm";

    public static long getTimeStampValue() {
        return PCSTime.getTimeStampValue(TS_MILLI_FORMAT);
    }

    public static long getTimeStampValue(String format) {
        String dateString = PCSTime.getTimeStamp(format);
        return Long.parseLong(dateString);
    }

    public static String getTimeStamp() {
        return PCSTime.getTimeStamp(TS_SEC_FORMAT);
    }

    public static String getTimeStamp(String format) {
        GregorianCalendar calendar = new GregorianCalendar();
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(calendar.getTime());
    }

    public static String getFormattedTimeStamp(String _stamp) {
        if (_stamp == null) {
            return null;
        }
        if (_stamp.length() < 14) {
            return _stamp;
        }
        StringBuffer buffer = new StringBuffer(YEAR_SEC_FORMAT);
        StringBuffer stamp = new StringBuffer(_stamp);
        buffer.replace(0, 4, stamp.substring(0, 4));
        int i = 5;
        int j = 4;
        while (j < 14) {
            buffer.replace(i, i + 2, stamp.substring(j, j + 2));
            i += 3;
            j += 2;
        }
        return buffer.toString();
    }

    public static String getFormattedTime(String _time) {
        if (_time == null) {
            return null;
        }
        if (_time.length() < 6) {
            return _time;
        }
        StringBuffer buffer = new StringBuffer(HOUR_SEC_FORMAT);
        StringBuffer stamp = new StringBuffer(_time);
        int i = 0;
        int j = 0;
        while (j < 6) {
            buffer.replace(i, i + 2, stamp.substring(j, j + 2));
            i += 3;
            j += 2;
        }
        return buffer.toString();
    }
}

