/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.usage;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.event.MetamodelUserEvent;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.repository.ComponentInterfaceDefinitionRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.ComponentRepositoryManager;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectFilter;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.PreRemoveReferencedObjectEvent;
import com.sap.ide.webdynpro.service.core.model.ServiceWithUI;
import java.util.ArrayList;

public class ModelUsageService {
    public static MMRepositoryObject[] getRepositoryObjectsAffectedByModelUsageCreation(Component component) {
        ArrayList<MMRepositoryObject> result = new ArrayList<MMRepositoryObject>();
        result.add(ComponentRepositoryManager.getRepositioryObject((Component)component, (boolean)false));
        return result.toArray(new MMRepositoryObject[0]);
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByModelUsageCreation(ComponentInterfaceDefinition componentInterfaceDefinition) {
        ArrayList<MMRepositoryObject> result = new ArrayList<MMRepositoryObject>();
        result.add(ComponentInterfaceDefinitionRepositoryManager.getRepositioryObject((ComponentInterfaceDefinition)componentInterfaceDefinition, (boolean)false));
        return result.toArray(new MMRepositoryObject[0]);
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByModelUsageDeletion(Component component) {
        return ModelUsageService.getRepositoryObjectsAffectedByModelUsageCreation(component);
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByModelUsageDeletion(ComponentInterfaceDefinition componentInterfaceDefinition) {
        return ModelUsageService.getRepositoryObjectsAffectedByModelUsageCreation(componentInterfaceDefinition);
    }

    public static Model[] createModelUsage(Component component, ComponentInterfaceDefinition componentInterfaceDefinition, Model[] usedModels) {
        String projectName = null;
        if (component != null) {
            projectName = component.getRoot().getMetamodel().getName();
        } else if (componentInterfaceDefinition != null) {
            projectName = componentInterfaceDefinition.getRoot().getMetamodel().getName();
        } else {
            return null;
        }
        Model[] models = ServiceWithUI.selectModel((DevelopmentObjectFilter)new ModelFilter(usedModels), (String)projectName);
        if (models != null) {
            WebDynproRoot root = MetamodelServices.getWebDynproRoot((String)projectName);
            try {
                root.disableAutoNotify();
                int i = 0;
                while (i < models.length) {
                    if (component != null) {
                        component.addUsedModel(models[i]);
                    } else if (componentInterfaceDefinition != null) {
                        componentInterfaceDefinition.addUsedModel(models[i]);
                    }
                    ++i;
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                root.notifyObservers();
                root.enableAutoNotify();
                throw throwable;
            }
            root.notifyObservers();
            root.enableAutoNotify();
            {
            }
        }
        return models;
    }

    public static void deleteModelUsage(Component usingComponent, Model usedModel) {
        PreRemoveReferencedObjectEvent event = new PreRemoveReferencedObjectEvent((DevelopmentObject)usedModel);
        usingComponent.fireUserEvent((MetamodelUserEvent)event);
        usingComponent.removeUsedModel(usedModel);
    }

    public static void deleteModelUsage(ComponentInterfaceDefinition usingComponentInterfaceDefinition, Model usedModel) {
        PreRemoveReferencedObjectEvent event = new PreRemoveReferencedObjectEvent((DevelopmentObject)usedModel);
        usingComponentInterfaceDefinition.fireUserEvent((MetamodelUserEvent)event);
        usingComponentInterfaceDefinition.removeUsedModel(usedModel);
    }

    private static class ModelFilter
    implements DevelopmentObjectFilter {
        private Model[] mUsedModels = null;

        public ModelFilter(Model[] usedModels) {
            this.mUsedModels = usedModels;
        }

        public boolean isValidObject(DevelopmentObject object) {
            if (object instanceof Model) {
                Model model = (Model)object;
                int i = 0;
                while (i < this.mUsedModels.length) {
                    if (model.equals(this.mUsedModels[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
    }
}

