/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.usage;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.webdynpro.base.EventHandler;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.metamodel.webdynpro.repository.ComponentRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.MMRepositoryObjectProvider;
import com.sap.ide.webdynpro.service.controllereditor.ComponentAndControllerStorage;
import com.sap.ide.webdynpro.service.controllereditor.ServiceControllerEditorPlugin;
import com.sap.ide.webdynpro.service.controllereditor.context.ServicesDeletion;
import com.sap.ide.webdynpro.service.controllereditor.usage.ControllerFilterForComponentControllerUsageImpl;
import com.sap.ide.webdynpro.service.controllereditor.usage.ControllerFilterImpl;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import java.util.ArrayList;

public class ControllerUsageService {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final String USAGE_POSTFIX = "Usage";
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$controllereditor$usage$ControllerUsageService;

    public static void deleteControllerUsage(ControllerUsage controllerUsage) {
        ControllerUsageService.removeEventReferences(controllerUsage);
        ServicesDeletion.deleteMappings(controllerUsage);
        try {
            controllerUsage.delete();
        }
        catch (DeleteException e) {
            ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$usage$ControllerUsageService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$usage$ControllerUsageService = ControllerUsageService.class$("com.sap.ide.webdynpro.service.controllereditor.usage.ControllerUsageService")) : class$com$sap$ide$webdynpro$service$controllereditor$usage$ControllerUsageService, "deleteControllerUsage(ControllerUsage)", e.getMessage(), e, false);
        }
    }

    public static String getComponentUsageDisplayName(ControllerUsage usage) {
        return ControllerUsageService.getComponentUsageDisplayName(usage.getComponentUsage(), usage.getUsedController());
    }

    public static String getComponentUsageDisplayName(ComponentAndControllerStorage storage) {
        return ControllerUsageService.getComponentUsageDisplayName(storage.getComponentUsage(), storage.getController());
    }

    private static String getComponentUsageDisplayName(ComponentUsage componentUsage, Controller controller) {
        if (componentUsage == null) {
            if (controller != null) {
                return ControllerUsageService.getControllerName(controller) + " - " + controller.getPackage();
            }
            return "<ERROR>";
        }
        if (controller == null) {
            if (componentUsage.getUsedComponent() != null && componentUsage.getUsedComponent() instanceof ComponentInterfaceImplementation && componentUsage.getUsedComponent().getParent() != null) {
                return componentUsage.getName() + " (" + mCoreTextPool.getText(129) + ") <" + componentUsage.getUsedComponent().getParent().getName() + " - " + ((MainDevelopmentObject)componentUsage.getUsedComponent().getParent()).getPackage() + ">";
            }
            if (componentUsage.getUsedComponent() != null && componentUsage.getUsedComponent() instanceof ComponentInterfaceDefinition) {
                return componentUsage.getName() + " (" + mCoreTextPool.getText(129) + ") <" + componentUsage.getUsedComponent().getName() + " - " + ((ComponentInterfaceDefinition)componentUsage.getUsedComponent()).getPackage() + ">";
            }
            return "<ERROR>";
        }
        String controllerNameText = "";
        if (controller.getType().equals(ControllerTypeEnum.COMPONENT_INTERFACE)) {
            controllerNameText = mCoreTextPool.getText(122);
        } else if (controller.getType().equals(ControllerTypeEnum.COMPONENT_CONFIGURATION)) {
            controllerNameText = mCoreTextPool.getText(124);
        }
        if (componentUsage.getUsedComponent() != null && componentUsage.getUsedComponent() instanceof ComponentInterfaceImplementation && componentUsage.getUsedComponent().getParent() != null) {
            return componentUsage.getName() + " (" + controllerNameText + ") <" + componentUsage.getUsedComponent().getParent().getName() + " - " + ((MainDevelopmentObject)componentUsage.getUsedComponent().getParent()).getPackage() + ">";
        }
        if (componentUsage.getUsedComponent() != null && componentUsage.getUsedComponent() instanceof ComponentInterfaceDefinition) {
            return componentUsage.getName() + " (" + controllerNameText + ") <" + componentUsage.getUsedComponent().getName() + " - " + ((ComponentInterfaceDefinition)componentUsage.getUsedComponent()).getPackage() + ">";
        }
        return "<ERROR>";
    }

    private static String getControllerName(Controller controller) {
        if (controller != null) {
            if (controller.getType().equals(ControllerTypeEnum.COMPONENT_INTERFACE)) {
                if (controller.getParent() != null && controller.getParent().getParent() instanceof Component) {
                    return controller.getParent().getParent().getName() + " (" + mCoreTextPool.getText(122) + ")";
                }
                return "<ERROR>";
            }
            if (controller.getType().equals(ControllerTypeEnum.COMPONENT_CONFIGURATION)) {
                if (controller.getParent() != null && controller.getParent().getParent() instanceof Component) {
                    return controller.getParent().getParent().getName() + " (" + mCoreTextPool.getText(124) + ")";
                }
                return "<ERROR>";
            }
            return controller.getName();
        }
        return "<ERROR>";
    }

    private static void removeEventReferences(ControllerUsage controllerUsage) {
        if (controllerUsage == null) {
            return;
        }
        if (controllerUsage.getParent() instanceof Controller) {
            Controller controller = (Controller)controllerUsage.getParent();
            EventHandler[] eventHandlers = controller.getEventHandlers();
            int i = 0;
            while (i < eventHandlers.length) {
                if (controllerUsage.equals(eventHandlers[i].getEventSource())) {
                    eventHandlers[i].setEventSource(null);
                    eventHandlers[i].setSubscribedEvent(null);
                }
                ++i;
            }
        }
    }

    public static String createControllerUsage(ComponentAndControllerStorage object, Controller usingController) {
        Controller controller;
        String usageName = "";
        usageName = object.getComponentUsage() == null ? ControllerUsageService.getControllerUsageName(object.getController()) : ((controller = object.getController()) != null ? object.getComponentUsage().getName() + ControllerUsageService.getControllerUsageName(object.getController()) : object.getComponentUsage().getName() + USAGE_POSTFIX);
        ControllerUsage usage = null;
        if (!usingController.hasOutgoingControllerUsage(usageName)) {
            try {
                usage = usingController.createOutgoingControllerUsage(usageName);
            }
            catch (CreateException e) {
                ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$usage$ControllerUsageService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$usage$ControllerUsageService = ControllerUsageService.class$("com.sap.ide.webdynpro.service.controllereditor.usage.ControllerUsageService")) : class$com$sap$ide$webdynpro$service$controllereditor$usage$ControllerUsageService, "createControllerUsage(ComponentAndControllerStorage, Controller)", e.getMessage(), e, false);
                return e.getMessage();
            }
        } else {
            usage = usingController.getOutgoingControllerUsage(usageName);
        }
        usage.setComponentUsage(object.getComponentUsage());
        usage.setUsedController(object.getController());
        return null;
    }

    public static String createControllerUsage(ComponentAndControllerStorage object, ComponentControllerUsage usingComponentControllerUsage) {
        Controller controller;
        String usageName = "";
        usageName = object.getComponentUsage() == null ? ControllerUsageService.getControllerUsageName(object.getController()) : ((controller = object.getController()) != null ? ControllerUsageService.getControllerUsageName(controller) + "." + object.getComponentUsage().getName() : object.getComponentUsage().getName() + USAGE_POSTFIX);
        ControllerUsage usage = null;
        try {
            usage = usingComponentControllerUsage.createOutgoingControllerUsage(usageName);
        }
        catch (CreateException e) {
            ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$usage$ControllerUsageService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$usage$ControllerUsageService = ControllerUsageService.class$("com.sap.ide.webdynpro.service.controllereditor.usage.ControllerUsageService")) : class$com$sap$ide$webdynpro$service$controllereditor$usage$ControllerUsageService, "createControllerUsage(ComponentAndControllerStorage, ComponentControllerUsage)", e.getMessage(), e, false);
            return e.getMessage();
        }
        usage.setComponentUsage(object.getComponentUsage());
        usage.setUsedController(object.getController());
        return null;
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByControllerUsageCreation(Controller controller) {
        ArrayList<MMRepositoryObject> result = new ArrayList<MMRepositoryObject>();
        result.add(MMRepositoryObjectProvider.getRepositoryObject((Controller)controller, (boolean)false));
        return result.toArray(new MMRepositoryObject[0]);
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByControllerUsageCreation(ComponentControllerUsage componentControllerUsage) {
        ArrayList<MMRepositoryObject> result = new ArrayList<MMRepositoryObject>();
        result.add(ComponentRepositoryManager.getRepositioryObject((Component)componentControllerUsage.getComponentUsage().getUsingComponent(), (boolean)false));
        return result.toArray(new MMRepositoryObject[0]);
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByControllerUsageDeletion(ControllerUsage usage) {
        if (usage.getParent() instanceof Controller) {
            return ControllerUsageService.getRepositoryObjectsAffectedByControllerUsageCreation((Controller)usage.getParent());
        }
        if (usage.getParent() instanceof ComponentControllerUsage) {
            return ControllerUsageService.getRepositoryObjectsAffectedByControllerUsageCreation((ComponentControllerUsage)usage.getParent());
        }
        ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$usage$ControllerUsageService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$usage$ControllerUsageService = ControllerUsageService.class$("com.sap.ide.webdynpro.service.controllereditor.usage.ControllerUsageService")) : class$com$sap$ide$webdynpro$service$controllereditor$usage$ControllerUsageService, "getRepositoryObjectsAffectedByControllerUsageDeletion(ControllerUsage)", "Controller usage parent is no controller", new Exception(), false);
        return new MMRepositoryObject[0];
    }

    public static boolean isRequiredControllerRelationshipAllowed(Controller sourceController, Controller targetController) {
        ControllerFilterImpl filter = new ControllerFilterImpl(sourceController);
        ComponentAndControllerStorage storage = null;
        Component targetComponent = MetamodelServices.getComponent((DevelopmentObject)targetController);
        Component sourceComponent = MetamodelServices.getComponent((DevelopmentObject)sourceController);
        Object targetComponentInterface = null;
        Object sourceComponentInterface = null;
        targetComponentInterface = targetComponent != null ? targetComponent.getComponentInterface() : MetamodelServices.getComponentInterfaceDefinition((DevelopmentObject)targetController);
        sourceComponentInterface = sourceComponent != null ? sourceComponent.getComponentInterface() : MetamodelServices.getComponentInterfaceDefinition((DevelopmentObject)sourceController);
        if (targetComponent != null && targetComponent.equals(sourceComponent)) {
            storage = new ComponentAndControllerStorage(targetController);
        } else if (targetComponentInterface != null && targetComponentInterface.equals(sourceComponentInterface)) {
            storage = new ComponentAndControllerStorage(targetController);
        } else if (sourceComponent != null) {
            ComponentUsage[] componentUsages = sourceComponent.getComponentUsages();
            ComponentUsage componentUsage = null;
            int i = 0;
            while (i < componentUsages.length) {
                if (componentUsages[i].getUsedComponent() != null && componentUsages[i].getUsedComponent().equals(targetComponentInterface)) {
                    componentUsage = componentUsages[i];
                }
                ++i;
            }
            if (componentUsage == null) {
                return false;
            }
            storage = new ComponentAndControllerStorage(componentUsage, targetController);
        }
        boolean result = false;
        if (storage != null) {
            result = filter.isValidObject(storage);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isRequiredControllerRelationshipAllowed(ComponentControllerUsage sourceCompContrUsage, Controller targetController) {
        ControllerFilterForComponentControllerUsageImpl filter = new ControllerFilterForComponentControllerUsageImpl(sourceCompContrUsage);
        ComponentAndControllerStorage storage = null;
        if (targetController == null) return false;
        Component targetComponent = MetamodelServices.getComponent((DevelopmentObject)targetController);
        ComponentInterfaceDefinition targetCID = MetamodelServices.getComponentInterfaceDefinition((DevelopmentObject)targetController);
        Component sourceComponent = MetamodelServices.getComponent((DevelopmentObject)sourceCompContrUsage.getUsedComponentController());
        ComponentInterfaceDefinition sourceCID = MetamodelServices.getComponentInterfaceDefinition((DevelopmentObject)sourceCompContrUsage.getUsedComponentController());
        if (sourceComponent != null) {
            if (sourceComponent.equals(targetComponent)) {
                return false;
            }
        } else {
            if (sourceCID == null) return false;
            if (sourceCID.equals(targetCID)) {
                return false;
            }
        }
        storage = new ComponentAndControllerStorage(targetController);
        return filter.isValidObject(storage);
    }

    public static boolean isRequiredControllerRelationshipAllowed(Controller sourceController, Component targetComponent) {
        ComponentUsage componentUsage;
        ControllerFilterImpl filter = new ControllerFilterImpl(sourceController);
        ComponentAndControllerStorage storage = null;
        Component sourceComponent = MetamodelServices.getComponent((DevelopmentObject)sourceController);
        if (targetComponent != null) {
            ComponentUsage[] componentUsages = sourceComponent.getComponentUsages();
            componentUsage = null;
            int i = 0;
            while (i < componentUsages.length) {
                if (componentUsages[i].getUsedComponent() != null && componentUsages[i].getUsedComponent().equals(targetComponent.getComponentInterface())) {
                    componentUsage = componentUsages[i];
                }
                ++i;
            }
            if (componentUsage == null) {
                return false;
            }
        } else {
            return false;
        }
        storage = new ComponentAndControllerStorage(componentUsage, null);
        boolean result = filter.isValidObject(storage);
        return result;
    }

    private static String getControllerUsageName(Controller usedController) {
        return usedController.getQualifiedName() + USAGE_POSTFIX;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

