/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.usage;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.metamodel.webdynpro.repository.ComponentRepositoryManager;
import com.sap.ide.webdynpro.checklayer.RepairResult;
import com.sap.ide.webdynpro.service.controllereditor.componentcontrollerusage.ComponentControllerUsageService;
import com.sap.ide.webdynpro.service.controllereditor.context.ServicesRepair;
import java.util.ArrayList;

public class ComponentUsageRepair {
    public static MMRepositoryObject[] getRepositoryObjectsAffectedByComponentReparation(ComponentUsage componentUsage) {
        ArrayList<MMRepositoryObject> result = new ArrayList<MMRepositoryObject>();
        result.add(ComponentRepositoryManager.getRepositioryObject((Component)componentUsage.getUsingComponent(), (boolean)false));
        MMRepositoryObject[] repositoryObjects = new MMRepositoryObject[result.size()];
        return result.toArray(repositoryObjects);
    }

    public static void repair(ComponentUsage componentUsage, RepairResult repairResult) {
        if (!componentUsage.hasComponentControllerUsage("Interface") && componentUsage.getUsedComponent() != null) {
            ComponentControllerUsageService.createComponentControllerControllerUsage(componentUsage, componentUsage.getUsedComponent().getInterfaceController());
            repairResult.addEntry((DevelopmentObject)componentUsage, true, "created ComponentControllerUsage for interface controller");
        }
        if (!componentUsage.hasComponentControllerUsage("Configuration") && componentUsage.getUsedComponent() != null) {
            ComponentControllerUsageService.createComponentControllerControllerUsage(componentUsage, componentUsage.getUsedComponent().getConfigurationController());
            repairResult.addEntry((DevelopmentObject)componentUsage, true, "created ComponentControllerUsage for configuration controller");
        }
        ComponentControllerUsage[] componentControllerUsages = componentUsage.getComponentControllerUsages();
        int i = 0;
        while (i < componentControllerUsages.length) {
            if (componentControllerUsages[i].hasUsedComponentController() && componentControllerUsages[i].getOutgoingControllerUsageCount() > 0) {
                ServicesRepair.repairReverseContextMappings(componentControllerUsages[i].getUsedComponentController().getContext(), componentControllerUsages[i].getOutgoingControllerUsages(), repairResult);
            }
            ++i;
        }
    }
}

