/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.procedure;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.service.controllereditor.IControllerEditorPart;
import com.sap.ide.webdynpro.service.controllereditor.ServiceControllerEditorPlugin;
import com.sap.ide.webdynpro.service.controllereditor.implementation.IJavaImplementationEditor;
import com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService;
import com.sap.ide.webdynpro.service.core.EditorService;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IEditorPart;

public class RenameProcedureService {
    private Controller mController = null;
    private ImplementationService mImplementationService = null;

    public RenameProcedureService(Controller controller) {
        this.mController = controller;
        IEditorPart editor = EditorService.findDevelopmentObjectEditor((DevelopmentObject)this.mController);
        IJavaImplementationEditor javaImplementationEditor = null;
        if (editor instanceof IControllerEditorPart) {
            IControllerEditorPart controllerEditorPart = (IControllerEditorPart)editor;
            javaImplementationEditor = controllerEditorPart.getImplementationEditorAsInterface();
        }
        this.mImplementationService = new ImplementationService(this.mController);
        this.mImplementationService.setJavaEditor(javaImplementationEditor);
    }

    public RenameProcedureWrapper getProcedureWrapper(String oldProcedureName, String newProcedureName) {
        this.mImplementationService.updateImplementationFromXML();
        ResourcesPlugin.getWorkspace().checkpoint(true);
        IMethod method = ImplementationService.getJDTMethod(this.mController, oldProcedureName, null);
        String completeSource = null;
        if (method != null) {
            try {
                completeSource = method.getSource();
            }
            catch (JavaModelException e) {
                ServiceControllerEditorPlugin.internalError(this.getClass(), "performFinish()", e.getMessage(), e, true);
                return null;
            }
        } else {
            return null;
        }
        String source = ImplementationService.stripOffSurroundingComments(completeSource);
        String comment = ImplementationService.stripOffMethod(completeSource);
        RenameProcedureWrapper wrapper = new RenameProcedureWrapper(oldProcedureName, newProcedureName);
        wrapper.setCoding(source);
        wrapper.setComment(comment);
        ImplementationService.setMethodBody(this.mController, oldProcedureName, "", "", null);
        return wrapper;
    }

    public void applyRenameProcedureWrappers(RenameProcedureWrapper[] wrappers) {
        this.mImplementationService.updateImplementationFromXML();
        ResourcesPlugin.getWorkspace().checkpoint(true);
        int i = 0;
        while (i < wrappers.length) {
            IMethod method = ImplementationService.getJDTMethod(this.mController, wrappers[i].getNewProcedureName(), null);
            String completeTargetSource = null;
            String targetSource = null;
            String targetComment = null;
            if (method != null) {
                try {
                    completeTargetSource = method.getSource();
                }
                catch (JavaModelException e) {
                    ServiceControllerEditorPlugin.internalError(this.getClass(), "performFinish()", e.getMessage(), e, true);
                }
                targetSource = ImplementationService.embedSourceInTargetComments(completeTargetSource, wrappers[i].getCoding(), true);
                targetComment = ImplementationService.embedCommentInTargetComments(completeTargetSource, wrappers[i].getComment());
                wrappers[i].setCoding(targetSource);
                wrappers[i].setComment(targetComment);
            } else {
                ServiceControllerEditorPlugin.internalError(this.getClass(), "applyRenameProcedureWrappers(RenameProcedureWrapper[])", "Could not find new method", new Exception(), false);
            }
            ++i;
        }
        if (!ImplementationService.setMethodBodies(this.mController, wrappers, null)) {
            return;
        }
        this.mImplementationService.updateImplementationFromXML();
        ResourcesPlugin.getWorkspace().checkpoint(true);
    }

    public static class RenameProcedureWrapper {
        private String mOldName = null;
        private String mNewName = null;
        private String mCoding = null;
        private String mComment = null;

        public RenameProcedureWrapper(String oldProcedureName, String newProcedureName) {
            this.mOldName = oldProcedureName;
            this.mNewName = newProcedureName;
            this.mCoding = "";
            this.mComment = "";
        }

        public String getOldProcedureName() {
            return this.mOldName;
        }

        public String getNewProcedureName() {
            return this.mNewName;
        }

        public void setNewProcedureName(String newProcedureName) {
            this.mNewName = newProcedureName;
        }

        public String getCoding() {
            return this.mCoding;
        }

        public void setCoding(String coding) {
            this.mCoding = coding;
        }

        public String getComment() {
            return this.mComment;
        }

        public void setComment(String comment) {
            this.mComment = comment;
        }
    }
}

