/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.internal;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterface;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.webdynpro.service.controllereditor.ComponentAndControllerStorage;
import com.sap.ide.webdynpro.service.controllereditor.ControllerFilter;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.controller.ControllerService;
import com.sap.ide.webdynpro.service.controllereditor.usage.ControllerUsageService;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectNameComparator;
import com.tssap.util.ui.dialog.StructuredObjectSelectionDialog;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ControllerSelection
implements ITreeContentProvider,
ILabelProvider {
    private static final TextPool mTextPool = TextPool.getInstance();
    private ControllerFilter mFilter = null;
    private String mTitle = null;

    public ControllerSelection(ControllerFilter filter) {
        this(filter, mTextPool.getText(507));
    }

    public ControllerSelection(ControllerFilter filter, String title) {
        this.mFilter = filter;
        this.mTitle = title;
    }

    public ComponentAndControllerStorage[] select(Component component) {
        return this.select((DevelopmentObject)component);
    }

    public ComponentAndControllerStorage[] select(ComponentControllerUsage componentControllerUsage) {
        return this.select((DevelopmentObject)componentControllerUsage);
    }

    private ComponentAndControllerStorage[] select(DevelopmentObject object) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ControllerStructuredSelectionDialog dialog = new ControllerStructuredSelectionDialog(shell, this.mTitle, mTextPool.getText(558));
        dialog.setBlockOnOpen(true);
        dialog.setLabelProvider(this);
        dialog.setTreeInput(object);
        Object[] objects = dialog.openDialog(this, true, 1);
        if (objects == null || objects.length < 1) {
            return new ComponentAndControllerStorage[0];
        }
        ComponentAndControllerStorage[] storage = new ComponentAndControllerStorage[objects.length];
        int i = 0;
        while (i < storage.length) {
            storage[i] = (ComponentAndControllerStorage)objects[i];
            ++i;
        }
        return storage;
    }

    public Object[] getChildren(Object inputElement) {
        if (inputElement instanceof ComponentAndControllerStorage) {
            ComponentAndControllerStorage storage = (ComponentAndControllerStorage)inputElement;
            return storage.getChildren();
        }
        return new ComponentAndControllerStorage[0];
    }

    public Object getParent(Object element) {
        if (element instanceof ComponentAndControllerStorage) {
            ComponentAndControllerStorage storage = (ComponentAndControllerStorage)element;
            return storage.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ComponentAndControllerStorage) {
            ComponentAndControllerStorage storage = (ComponentAndControllerStorage)element;
            return storage.getChildren().length > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<ComponentAndControllerStorage> list;
        block16: {
            block15: {
                list = new ArrayList<ComponentAndControllerStorage>();
                if (!(inputElement instanceof Component)) break block15;
                Component component = (Component)inputElement;
                Controller[] controllers = component.getControllers();
                Arrays.sort(controllers, new DevelopmentObjectNameComparator());
                int i = 0;
                while (i < controllers.length) {
                    ComponentAndControllerStorage storage = new ComponentAndControllerStorage(controllers[i]);
                    if (this.mFilter.isValidObject(storage)) {
                        list.add(storage);
                    }
                    ++i;
                }
                controllers = component.getComponentInterface().getControllers();
                Arrays.sort(controllers, new DevelopmentObjectNameComparator());
                int i2 = 0;
                while (i2 < controllers.length) {
                    ComponentAndControllerStorage storage;
                    if (controllers[i2].getType() != ControllerTypeEnum.COMPONENT_CONFIGURATION && this.mFilter.isValidObject(storage = new ComponentAndControllerStorage(controllers[i2]))) {
                        list.add(storage);
                    }
                    ++i2;
                }
                ComponentUsage[] componentUsages = component.getComponentUsages();
                int i3 = 0;
                while (i3 < componentUsages.length) {
                    ComponentAndControllerStorage storage = new ComponentAndControllerStorage(componentUsages[i3], null);
                    if (this.mFilter.isValidObject(storage)) {
                        ArrayList<ComponentAndControllerStorage> childrenList = new ArrayList<ComponentAndControllerStorage>();
                        if (componentUsages[i3].hasUsedComponent()) {
                            ComponentInterface usedComponentInterface;
                            ComponentAndControllerStorage childStorage = new ComponentAndControllerStorage(componentUsages[i3], null, storage);
                            if (this.mFilter.isValidObject(childStorage)) {
                                childrenList.add(childStorage);
                            }
                            if ((usedComponentInterface = componentUsages[i3].getUsedComponent()).hasInterfaceController() && this.mFilter.isValidObject(childStorage = new ComponentAndControllerStorage(componentUsages[i3], usedComponentInterface.getInterfaceController(), storage))) {
                                childrenList.add(childStorage);
                            }
                        }
                        storage.setChildren(childrenList.toArray(new ComponentAndControllerStorage[childrenList.size()]));
                        list.add(storage);
                    }
                    ++i3;
                }
                break block16;
            }
            if (!(inputElement instanceof ComponentControllerUsage)) break block16;
            ComponentControllerUsage componentControllerUsage = (ComponentControllerUsage)inputElement;
            Component component = (Component)componentControllerUsage.getComponentUsage().getParent();
            ComponentAndControllerStorage storage = null;
            Controller[] controllers = component.getControllers();
            Arrays.sort(controllers, new DevelopmentObjectNameComparator());
            int i = 0;
            while (i < controllers.length) {
                storage = new ComponentAndControllerStorage(controllers[i]);
                if (this.mFilter.isValidObject(storage)) {
                    list.add(storage);
                }
                ++i;
            }
            ComponentUsage[] componentUsages = component.getComponentUsages();
            int i4 = 0;
            while (i4 < componentUsages.length) {
                if (!componentControllerUsage.getComponentUsage().equals(componentUsages[i4])) {
                    storage = new ComponentAndControllerStorage(componentUsages[i4], null);
                    ArrayList<ComponentAndControllerStorage> childrenList = new ArrayList<ComponentAndControllerStorage>();
                    if (this.mFilter.isValidObject(storage)) {
                        ComponentInterface usedComponentInterface = componentUsages[i4].getUsedComponent();
                        ComponentAndControllerStorage childStorage = new ComponentAndControllerStorage(componentUsages[i4], usedComponentInterface.getInterfaceController(), storage);
                        if (this.mFilter.isValidObject(childStorage)) {
                            childrenList.add(childStorage);
                        }
                        storage.setChildren(childrenList.toArray(new ComponentAndControllerStorage[childrenList.size()]));
                        list.add(storage);
                    }
                }
                ++i4;
            }
        }
        return list.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getImage(Object element) {
        if (element instanceof ComponentAndControllerStorage) {
            ComponentAndControllerStorage storage = (ComponentAndControllerStorage)element;
            if (storage.getController() != null) {
                return ControllerService.getIcon(storage.getController());
            }
            return null;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof ComponentAndControllerStorage) {
            ComponentAndControllerStorage storage = (ComponentAndControllerStorage)element;
            return ControllerUsageService.getComponentUsageDisplayName(storage);
        }
        return "<ERROR>";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    private class ControllerStructuredSelectionDialog
    extends StructuredObjectSelectionDialog {
        public ControllerStructuredSelectionDialog(Shell parentShell, String title, String message) {
            super(parentShell, title, message);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }
    }
}

