/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.internal;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.webdynpro.service.controllereditor.ServiceControllerEditorPlugin;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectFilter;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.dialog.ObjectSelectionDialog;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ComponentInterfaceSelection
implements ILabelProvider {
    private static final TextPool mTextPool = TextPool.getInstance();
    private DevelopmentObjectFilter mFilter = null;

    public ComponentInterfaceSelection(DevelopmentObjectFilter filter) {
        this.mFilter = filter;
    }

    public DevelopmentObject select(WebDynproRoot root) {
        ObjectSelectionDialog dialog = new ObjectSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), mTextPool.getText(543), mTextPool.getText(559));
        dialog.setSingleSelection(true);
        dialog.setBlockOnOpen(true);
        dialog.setLabelProvider((ILabelProvider)this);
        dialog.setObjectSorter(new ViewerSorter(){});
        Object[] objects = dialog.openDialog((Object[])this.getElements(root));
        if (objects == null || objects.length < 1) {
            return null;
        }
        return (DevelopmentObject)objects[0];
    }

    private DevelopmentObject[] getElements(WebDynproRoot root) {
        Component[] components = null;
        try {
            components = root.getComponents();
        }
        catch (LoadException e) {
            ServiceControllerEditorPlugin.internalError(this.getClass(), "select(WebDynproRoot)", e.getMessage(), e, false);
            return new DevelopmentObject[0];
        }
        ComponentInterfaceDefinition[] componentInterfaceDefinitions = null;
        try {
            componentInterfaceDefinitions = root.getComponentInterfaceDefinitions();
        }
        catch (LoadException e) {
            ServiceControllerEditorPlugin.internalError(this.getClass(), "select(WebDynproRoot)", e.getMessage(), e, false);
            return new DevelopmentObject[0];
        }
        DevelopmentObject[] developmentObjects = new DevelopmentObject[components.length + componentInterfaceDefinitions.length];
        int i = 0;
        while (i < components.length) {
            developmentObjects[i] = components[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < componentInterfaceDefinitions.length) {
            developmentObjects[components.length + i2] = componentInterfaceDefinitions[i2];
            ++i2;
        }
        return developmentObjects;
    }

    public Image getImage(Object element) {
        if (element instanceof Component) {
            return SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_COMPONENT);
        }
        if (element instanceof ComponentInterfaceDefinition) {
            return SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_COMPONENT_INTERFACE_DEFINITION);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof MainDevelopmentObject) {
            MainDevelopmentObject object = (MainDevelopmentObject)element;
            return object.getName() + " - " + object.getPackage();
        }
        return null;
    }

    public void dispose() {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

