/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.internal;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.webdynpro.service.controllereditor.ServiceControllerEditorPlugin;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class ComponentInterfaceDefinitionSelectionInput
implements IStructuredContentProvider,
ILabelProvider {
    private DevelopmentObjectFilter mFilter = null;

    public ComponentInterfaceDefinitionSelectionInput(DevelopmentObjectFilter filter) {
        this.mFilter = filter;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof WebDynproRoot) {
            ComponentInterfaceDefinition[] componentInterfaceDefinitions = null;
            try {
                componentInterfaceDefinitions = ((WebDynproRoot)inputElement).getComponentInterfaceDefinitions();
            }
            catch (LoadException e) {
                ServiceControllerEditorPlugin.internalError(this.getClass(), "getElements(Object)", e.getMessage(), e, false);
            }
            Arrays.sort(componentInterfaceDefinitions, new ComponentInterfaceDefinitionComparator());
            ArrayList<ComponentInterfaceDefinition> list = new ArrayList<ComponentInterfaceDefinition>();
            int i = 0;
            while (i < componentInterfaceDefinitions.length) {
                if (this.mFilter.isValidObject((DevelopmentObject)componentInterfaceDefinitions[i])) {
                    list.add(componentInterfaceDefinitions[i]);
                }
                ++i;
            }
            return list.toArray(new ComponentInterfaceDefinition[list.size()]);
        }
        return null;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof ComponentInterfaceDefinition) {
            return ((ComponentInterfaceDefinition)element).getName() + " - " + ((ComponentInterfaceDefinition)element).getPackage();
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    private class ComponentInterfaceDefinitionComparator
    implements Comparator {
        private ComponentInterfaceDefinitionComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((ComponentInterfaceDefinition)o1).getName().compareTo(((ComponentInterfaceDefinition)o2).getName());
        }
    }
}

