/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.implementation;

import com.sap.ide.generationfwk.eclipse.progressmonitor.StatusLineProgressMonitor;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.generation.Generation;
import com.sap.ide.webdynpro.generation.eclipse.GenerationEclipse;
import com.sap.ide.webdynpro.generation.naming.NamingService;
import com.sap.ide.webdynpro.service.controllereditor.ServiceControllerEditorPlugin;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.implementation.AmbiguousImportsException;
import com.sap.ide.webdynpro.service.controllereditor.implementation.IJavaImplementationEditor;
import com.sap.ide.webdynpro.service.controllereditor.procedure.RenameProcedureService;
import com.sap.ide.webdynpro.service.core.BrowseHelper;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMType;
import org.eclipse.jdt.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.FileEditorInput;

public class ImplementationService {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final String COMMENT_BEGIN = "//@@begin";
    private static final String COMMENT_END = "//@@end";
    private static final String COMMENT_BEGIN_JAVADOC = "//@@begin javadoc";
    private static final String COMMENT_END_JAVADOC = "//@@end";
    private Controller mController = null;
    private IJavaImplementationEditor mJavaEditor = null;
    private Shell mShell = null;
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService;

    public ImplementationService(Controller controller) {
        this(controller, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
    }

    public ImplementationService(Controller controller, Shell shell) {
        this.mController = controller;
        this.mShell = shell;
    }

    public Controller getController() {
        return this.mController;
    }

    public void setJavaEditor(IJavaImplementationEditor javaEditor) {
        this.mJavaEditor = javaEditor;
    }

    public void generateImplementation(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = StatusLineProgressMonitor.getStatusLineProgressMonitor((boolean)false);
        }
        this.generateImplementationInternal(monitor, false);
    }

    public void generateEmptyImplementation() {
        IProgressMonitor monitor = StatusLineProgressMonitor.getStatusLineProgressMonitor((boolean)false);
        try {
            try {
                this.mJavaEditor.setNoUpdateOfMetadata(true);
                this.mJavaEditor.doRevertToSaved();
                this.generateImplementationInternal(monitor, true);
            }
            catch (Exception e) {
                ServiceControllerEditorPlugin.internalError(this.getClass(), "generateEmptyImplementation()", e.getMessage(), e, false);
                Object var4_3 = null;
                this.mJavaEditor.setNoUpdateOfMetadata(false);
            }
            Object var4_2 = null;
            this.mJavaEditor.setNoUpdateOfMetadata(false);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.mJavaEditor.setNoUpdateOfMetadata(false);
            throw throwable;
        }
    }

    private boolean generateImplementationInternal(IProgressMonitor monitor, boolean generateEmptyClass) {
        boolean succeeded = true;
        GenerationEclipse generator = new GenerationEclipse(monitor);
        IProject project = ServicesEclipse.getEclipseProject((DevelopmentObject)this.mController);
        generator.setTargetPath(project.getLocation().toFile().getAbsolutePath());
        generator.refreshConfiguration();
        if (generateEmptyClass) {
            generator.setIncremental(false);
            generator.generatePersistentControllerEmpty(this.mController, true, true);
        } else {
            generator.setIncremental(true);
            generator.generatePersistentController(this.mController, true, true, true, true);
        }
        if (Generation.isErrorIndicator()) {
            succeeded = false;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window instanceof WorkbenchWindow) {
                try {
                    window.getActivePage().showView("org.eclipse.ui.views.TaskList");
                }
                catch (Exception e) {
                    ServiceControllerEditorPlugin.internalError(this.getClass(), "generateImplementationInternal(IProgressMonitor, boolean)", e.getMessage(), e, true);
                }
                ((WorkbenchWindow)window).getActionBars().getStatusLineManager().setErrorMessage(SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_ERROR), mTextPool.getText(594));
            }
            NamingService namingService = new NamingService(project.getLocation().toFile().getAbsolutePath() + GenerationEclipse.getGenerationOutputPathInfix());
            Path path = new Path(namingService.getControllerEditableNaming(this.mController).getAbsoluteFilePath());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            BrowseHelper.ensureFolderExists((IResource)file);
            if (!file.exists()) {
                if (this.mController.getCodeBody() != null && this.mController.getCodeBody().length() != 0) {
                    ByteArrayInputStream in = new ByteArrayInputStream(this.mController.getCodeBody().getBytes());
                    try {
                        file.create((InputStream)in, true, monitor);
                    }
                    catch (CoreException e) {
                        ServiceControllerEditorPlugin.internalError(this.getClass(), "generateImplementationInternal(IProgressMonitor monitor, boolean)", e.getMessage(), e, true);
                    }
                } else if (!generateEmptyClass) {
                    generator.setIncremental(false);
                    generator.generatePersistentControllerEmpty(this.mController, true, true);
                }
            }
        }
        generator.cleanup();
        if (generator.getProgressMonitor() != null) {
            generator.getProgressMonitor().setTaskName(mTextPool.getText(508));
        }
        NamingService namingService = new NamingService(project.getLocation().toFile().getAbsolutePath() + GenerationEclipse.getGenerationOutputPathInfix());
        Path path = new Path(namingService.getControllerEditableNaming(this.mController).getAbsoluteFilePath());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        FileEditorInput javaFileEditorInput = new FileEditorInput(file);
        PlatformUI.getWorkbench().getEditorRegistry().setDefaultEditor(file, "com.sap.ide.webdynpro.editors.controller");
        if (generator.getProgressMonitor() != null) {
            generator.getProgressMonitor().done();
        }
        return succeeded;
    }

    public void updateImplementationFromXML() {
        IProgressMonitor monitor = StatusLineProgressMonitor.getStatusLineProgressMonitor((boolean)false);
        try {
            block8: {
                try {
                    if (this.mJavaEditor != null) {
                        this.mJavaEditor.setNoUpdateOfMetadata(true);
                        this.mJavaEditor.doRevertToSaved();
                    }
                    this.generateImplementation(monitor);
                    if (this.mJavaEditor == null) break block8;
                    this.mJavaEditor.doRevertToSaved();
                }
                catch (Exception e) {
                    ServiceControllerEditorPlugin.internalError(this.getClass(), "updateImplementationFromXML()", e.getMessage(), e, true);
                    Object var4_3 = null;
                    if (this.mJavaEditor != null) {
                        this.mJavaEditor.setNoUpdateOfMetadata(false);
                    }
                }
            }
            Object var4_2 = null;
            if (this.mJavaEditor != null) {
                this.mJavaEditor.setNoUpdateOfMetadata(false);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.mJavaEditor != null) {
                this.mJavaEditor.setNoUpdateOfMetadata(false);
            }
            throw throwable;
        }
    }

    public void updateXMLFromImplementation() {
        String content;
        if (this.mJavaEditor != null && this.mJavaEditor.isDirty() && (content = this.mJavaEditor.getEditorContent()) != null) {
            this.mController.setCodeBody(content);
        }
    }

    public void organizeImports(boolean doGenerate, IProgressMonitor monitor) throws AmbiguousImportsException {
        if (doGenerate && !this.generateImplementationInternal(monitor, false)) {
            return;
        }
        try {
            String source;
            IProject project = ServicesEclipse.getEclipseProject((DevelopmentObject)this.mController);
            NamingService namingService = new NamingService(project.getLocation().toFile().getAbsolutePath() + GenerationEclipse.getGenerationOutputPathInfix());
            Path path = new Path(namingService.getControllerEditableNaming(this.mController).getAbsoluteFilePath());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            if (file == null) {
                return;
            }
            ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)file);
            if (!cu.isWorkingCopy()) {
                cu = JavaModelUtil.toWorkingCopy((ICompilationUnit)cu);
            }
            if ((source = this.readFromFile(file)) == null) {
                return;
            }
            try {
                cu.getBuffer().setContents(source);
                cu.reconcile();
            }
            catch (JavaModelException e) {
                ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "organizeImports(boolean, IProgressMonitor)", e.getMessage(), e, true);
                return;
            }
            IPreferenceStore store = PreferenceConstants.getPreferenceStore();
            String[] prefOrder = JavaPreferencesSettings.getImportOrderPreference((IPreferenceStore)store);
            int threshold = JavaPreferencesSettings.getImportNumberThreshold((IPreferenceStore)store);
            boolean ignoreLowerCaseNames = store.getBoolean("org.eclipse.jdt.ui.ignorelowercasenames");
            boolean ambiguousImports = false;
            try {
                OrganizeImportsOperation op = new OrganizeImportsOperation(cu, prefOrder, threshold, ignoreLowerCaseNames, !cu.isWorkingCopy(), true, this.createImportQuery(this.mController));
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)op, monitor);
            }
            catch (CoreException e) {
                ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "organizeImports(boolean, IProgressMonitor)", "Error occured in organize imports operation", e, true);
                return;
            }
            catch (OperationCanceledException e) {
                ambiguousImports = true;
            }
            try {
                cu.save(monitor, false);
            }
            catch (JavaModelException e) {
                ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "organizeImports(boolean, IProgressMonitor)", e.getMessage(), e, true);
                return;
            }
            try {
                this.mController.setCodeBody(cu.getSource());
            }
            catch (JavaModelException e) {
                ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "organizeImports(boolean, IProgressMonitor)", e.getMessage(), e, true);
                return;
            }
            if (this.mJavaEditor != null) {
                this.mJavaEditor.doRevertToSaved();
            }
            if (ambiguousImports) {
                throw new AmbiguousImportsException(this.mController);
            }
        }
        catch (AmbiguousImportsException e) {
            throw e;
        }
        catch (Throwable t) {
            ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "organizeImports(boolean, IProgressMonitor)", "Error occured in organize imports operation", t, true);
        }
    }

    private OrganizeImportsOperation.IChooseImportQuery createImportQuery(final Controller controller) {
        return new OrganizeImportsOperation.IChooseImportQuery(){

            public TypeInfo[] chooseImports(TypeInfo[][] openChoices, ISourceRange[] ranges) {
                ArrayList<TypeInfo> choices = new ArrayList<TypeInfo>();
                String controllerPackage = controller.getPackage();
                int i = 0;
                while (i < openChoices.length) {
                    TypeInfo[] choice = openChoices[i];
                    int j = 0;
                    while (j < choice.length) {
                        TypeInfo info = choice[j];
                        String typePackage = info.getPackageName();
                        if (typePackage != null && controllerPackage != null && typePackage.startsWith(controllerPackage)) {
                            choices.add(info);
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (!choices.isEmpty()) {
                    return choices.toArray(new TypeInfo[choices.size()]);
                }
                return null;
            }
        };
    }

    private String readFromFile(IFile file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file.getLocation().toFile());
            InputStreamReader reader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(reader);
            StringBuffer buffer = new StringBuffer();
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                buffer.append(line);
                buffer.append(LINE_SEPARATOR);
            }
            return buffer.toString();
        }
        catch (FileNotFoundException e) {
            ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "readFromFile(IFile)", e.getMessage(), e, true);
        }
        catch (IOException ioe) {
            ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "readFromFile(IFile)", ioe.getMessage(), ioe, true);
        }
        return null;
    }

    public static IMethod getJDTMethod(Controller controller, String methodName, IProgressMonitor monitor) {
        IMethod method = null;
        IProject project = ServicesEclipse.getEclipseProject((DevelopmentObject)controller);
        if (project != null && project.isAccessible()) {
            NamingService namingService = new NamingService(project.getLocation().toFile().getAbsolutePath() + GenerationEclipse.getGenerationOutputPathInfix());
            String filePath = namingService.getControllerEditableNaming(controller).getAbsoluteFilePath();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(filePath));
            if (file != null && file.isAccessible()) {
                try {
                    file.refreshLocal(0, monitor);
                }
                catch (CoreException e) {
                    ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "getJDTMethod(Controller, String, IProgressMonitor)", e.getMessage(), e, false);
                    return null;
                }
                ResourcesPlugin.getWorkspace().checkpoint(false);
                ICompilationUnit compilationUnit = JavaCore.createCompilationUnitFrom((IFile)file);
                if (compilationUnit != null) {
                    IType type = compilationUnit.getType(namingService.getControllerEditableNaming(controller).getClassName());
                    if (type != null) {
                        IMethod[] methods = null;
                        try {
                            methods = type.getMethods();
                        }
                        catch (JavaModelException e) {
                            ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "getJDTMethod(Controller, String, IProgressMonitor)", e.getMessage(), e, false);
                            return null;
                        }
                        int i = 0;
                        while (i < methods.length) {
                            if (methods[i].getElementName().equals(methodName)) {
                                method = methods[i];
                                break;
                            }
                            ++i;
                        }
                    } else {
                        ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "getJDTMethod(Controller, String, IProgressMonitor)", "Type '" + namingService.getControllerEditableNaming(controller).getClassName() + "' not found in the source implementation file", new Exception(), false);
                    }
                } else {
                    ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "getJDTMethod(Controller, String, IProgressMonitor)", "Compilation unit for the source controller implementation file not found (" + filePath + ")", new Exception(), false);
                }
            } else {
                ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "getJDTMethod(Controller, String, IProgressMonitor)", "Source controller implementation file is not accessible (" + filePath + ")", new Exception(), false);
            }
        } else {
            ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "getJDTMethod(Controller, String, IProgressMonitor)", "Project for the source controller is not accessible (" + controller.getName() + ")", new Exception(), false);
        }
        return method;
    }

    public static String stripOffSurroundingComments(String source) {
        int index = (source = ImplementationService.stripOffJavaDocComments(source)).indexOf(COMMENT_BEGIN);
        if (index != -1) {
            source = source.substring(index);
        }
        if ((index = source.indexOf(LINE_SEPARATOR)) != -1) {
            source = source.substring(index + LINE_SEPARATOR.length());
        }
        if ((index = source.indexOf("//@@end")) != -1) {
            source = source.substring(0, index);
        }
        if (source.endsWith(LINE_SEPARATOR)) {
            source = source.substring(0, source.length() - LINE_SEPARATOR.length());
        }
        return source;
    }

    public static String stripOffMethod(String source) {
        int index = source.indexOf(COMMENT_BEGIN_JAVADOC);
        if (index != -1) {
            source = source.substring(index);
        }
        if ((index = source.indexOf(LINE_SEPARATOR)) != -1) {
            source = source.substring(index + LINE_SEPARATOR.length());
        }
        if ((index = source.indexOf("//@@end")) != -1) {
            source = source.substring(0, index);
        }
        while (source.endsWith(" ")) {
            source = source.substring(0, source.length() - 1);
        }
        if (source.endsWith(LINE_SEPARATOR)) {
            source = source.substring(0, source.length() - LINE_SEPARATOR.length());
        }
        return source;
    }

    public static String embedSourceInTargetComments(String targetSource, String source) {
        return ImplementationService.embedSourceInTargetComments(targetSource, source, false);
    }

    public static String embedSourceInTargetComments(String targetSource, String source, boolean ignoreExistingSourceCode) {
        int indexBeginCommentEnd;
        if (source == null || targetSource == null) {
            return "";
        }
        int indexBeginCodingBracket = (targetSource = ImplementationService.stripOffJavaDocComments(targetSource)).indexOf("{");
        if (indexBeginCodingBracket != -1) {
            targetSource = targetSource.substring(indexBeginCodingBracket);
        }
        int indexBeginCommentBegin = targetSource.indexOf(COMMENT_BEGIN);
        String indentCoding = "";
        if (!source.startsWith(" ") && !source.startsWith("\t") && (indentCoding = targetSource.substring(1, indexBeginCommentBegin)).startsWith(LINE_SEPARATOR)) {
            indentCoding = indentCoding.substring(LINE_SEPARATOR.length());
        }
        if (ignoreExistingSourceCode) {
            int indexLineEndCommentBegin;
            int indexEndCommentBegin = targetSource.indexOf("//@@end");
            if (indexEndCommentBegin != -1 && (indexLineEndCommentBegin = targetSource.lastIndexOf(LINE_SEPARATOR, indexEndCommentBegin)) != -1) {
                int indexLineBeginCommentEnd;
                indexLineEndCommentBegin += LINE_SEPARATOR.length();
                if (indexBeginCommentBegin != -1 && (indexLineBeginCommentEnd = targetSource.indexOf(LINE_SEPARATOR, indexBeginCommentBegin)) != -1) {
                    targetSource = targetSource.substring(0, indexLineBeginCommentEnd += LINE_SEPARATOR.length()) + indentCoding + source + targetSource.substring(indexLineEndCommentBegin);
                }
            }
        } else if (indexBeginCommentBegin != -1 && (indexBeginCommentEnd = targetSource.indexOf(LINE_SEPARATOR, indexBeginCommentBegin)) != -1) {
            targetSource = targetSource.substring(0, indexBeginCommentEnd += LINE_SEPARATOR.length()) + indentCoding + source + targetSource.substring(indexBeginCommentEnd);
        }
        return targetSource;
    }

    public static String embedCommentInTargetComments(String targetSource, String comment) {
        if (targetSource == null) {
            return null;
        }
        int index = targetSource.indexOf("//@@end");
        if (index != -1 && (index = targetSource.indexOf(LINE_SEPARATOR, index)) != -1) {
            targetSource = targetSource.substring(0, index + LINE_SEPARATOR.length());
        }
        int startIndex = -1;
        int endIndex = -1;
        index = targetSource.indexOf(COMMENT_BEGIN_JAVADOC);
        if (index != -1) {
            if ((index = targetSource.indexOf(LINE_SEPARATOR, index)) != -1) {
                startIndex = index + LINE_SEPARATOR.length();
            }
            if ((index = targetSource.indexOf("//@@end")) != -1 && (index = targetSource.lastIndexOf(LINE_SEPARATOR, index)) != -1) {
                endIndex = index;
            }
        }
        if (startIndex != -1 && endIndex != -1) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(targetSource.substring(0, startIndex));
            buffer.append(comment);
            buffer.append(targetSource.substring(endIndex, targetSource.length()));
            targetSource = buffer.toString();
        }
        return targetSource;
    }

    private static String stripOffJavaDocComments(String source) {
        int index;
        if (source.indexOf(COMMENT_BEGIN_JAVADOC) != -1 && (index = source.indexOf("//@@end" + LINE_SEPARATOR)) != -1) {
            source = source.substring(index + "//@@end".length() + LINE_SEPARATOR.length());
        }
        return source;
    }

    public static boolean setMethodBody(Controller controller, String methodName, String source, String comment, IProgressMonitor monitor) {
        RenameProcedureService.RenameProcedureWrapper[] wrappers = new RenameProcedureService.RenameProcedureWrapper[]{new RenameProcedureService.RenameProcedureWrapper("Dummy", methodName)};
        wrappers[0].setCoding(source);
        wrappers[0].setComment(comment);
        return ImplementationService.setMethodBodies(controller, wrappers, monitor);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean setMethodBodies(Controller controller, RenameProcedureService.RenameProcedureWrapper[] wrappers, IProgressMonitor monitor) {
        project = ServicesEclipse.getEclipseProject((DevelopmentObject)controller);
        if (project == null || !project.isAccessible()) ** GOTO lbl50
        namingService = new NamingService(project.getLocation().toFile().getAbsolutePath() + GenerationEclipse.getGenerationOutputPathInfix());
        filePath = namingService.getControllerEditableNaming(controller).getAbsoluteFilePath();
        file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(filePath));
        if (file == null || !file.isAccessible()) ** GOTO lbl48
        try {
            file.refreshLocal(0, monitor);
        }
        catch (CoreException e) {
            ServiceControllerEditorPlugin.internalError(ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "setMethodBody(Controller, String, String)", e.getMessage(), e, false);
            return false;
        }
        compilationUnit = JavaCore.createCompilationUnitFrom((IFile)file);
        if (compilationUnit == null) ** GOTO lbl46
        completeSource = null;
        try {
            completeSource = compilationUnit.getBuffer().getContents();
        }
        catch (JavaModelException e) {
            ServiceControllerEditorPlugin.internalError(ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "setMethodBody(Controller, String, String)", e.getMessage(), e, false);
            return false;
        }
        factory = new DOMFactory();
        unit = factory.createCompilationUnit(completeSource, namingService.getControllerEditableNaming(controller).getClassName());
        if (unit == null) ** GOTO lbl44
        node = unit.getChild(namingService.getControllerEditableNaming(controller).getClassName());
        if (node instanceof IDOMType) {
            type = (IDOMType)node;
            i = 0;
            while (i < wrappers.length) {
                node = type.getChild(wrappers[i].getNewProcedureName());
                if (!(node instanceof IDOMMethod)) {
                    ServiceControllerEditorPlugin.internalError(ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "setMethodBody(Controller, String, String)", "Method '" + wrappers[i].getNewProcedureName() + "' not found", new Exception(), false);
                    return false;
                }
                method = (IDOMMethod)node;
                method.setBody(wrappers[i].getCoding());
                method.setComment(wrappers[i].getComment());
                completeSource = unit.getContents();
                controller.setCodeBody(completeSource);
                ++i;
            }
        } else {
            ServiceControllerEditorPlugin.internalError(ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "setMethodBody(Controller, String, String)", "Type '" + namingService.getControllerEditableNaming(controller).getClassName() + "' not found", new Exception(), false);
            return false;
lbl44:
            // 1 sources

            ServiceControllerEditorPlugin.internalError(ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "setMethodBody(Controller, String, String)", "Cannot build up dom for the source controller implementation file (" + filePath + ")", new Exception(), false);
            return false;
lbl46:
            // 1 sources

            ServiceControllerEditorPlugin.internalError(ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "setMethodBody(Controller, String, String)", "Compilation unit for the source controller implementation file not found (" + filePath + ")", new Exception(), false);
            return false;
lbl48:
            // 1 sources

            ServiceControllerEditorPlugin.internalError(ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "setMethodBody(Controller, String, String)", "Source controller implementation file is not accessible (" + filePath + ")", new Exception(), false);
            return false;
lbl50:
            // 1 sources

            ServiceControllerEditorPlugin.internalError(ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService == null ? (ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService = ImplementationService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService")) : ImplementationService.class$com$sap$ide$webdynpro$service$controllereditor$implementation$ImplementationService, "setMethodBody(Controller, String, String)", "Project for the source controller is not accessible (" + controller.getName() + ")", new Exception(), false);
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

