/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.implementation;

import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.webdynpro.WebDynproMDOEnum;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.webdynpro.generation.dependency.ControllerDependency;
import com.sap.ide.webdynpro.service.core.BrowseHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public class ImplementationFileFindService {
    public static Controller isControllerImplementationFile(IFile file, Component[] components) {
        if (file == null) {
            return null;
        }
        if (components == null) {
            return null;
        }
        if (!file.getName().endsWith(".java")) {
            return null;
        }
        IJavaProject javaProject = ServicesEclipse.getJavaProject((String)file.getProject().getName());
        if (javaProject == null) {
            return null;
        }
        String packageName = null;
        try {
            packageName = BrowseHelper.getPackageName((IResource)file, (IJavaProject)ServicesEclipse.getJavaProject((String)file.getProject().getName()));
        }
        catch (JavaModelException e) {
            return null;
        }
        Controller controller = ControllerDependency.getControllerFromControllerEditableFile((String)packageName, (String)file.getName().substring(0, file.getName().lastIndexOf(".")), (String)file.getFileExtension(), (Component[])components);
        return controller;
    }

    public static Controller isControllerEditorMetadataFile(IFile file, Component[] components, ComponentInterfaceDefinition[] componentInterfaceDefinitions) {
        if (file == null || !file.exists()) {
            return null;
        }
        IJavaProject javaProject = ServicesEclipse.getJavaProject((String)file.getProject().getName());
        if (javaProject == null) {
            return null;
        }
        String packageName = null;
        try {
            packageName = javaProject.findPackageFragment(file.getParent().getFullPath()).getElementName();
        }
        catch (JavaModelException e) {
            return null;
        }
        String objectName = file.getName();
        objectName = objectName.substring(0, objectName.lastIndexOf("."));
        String extension = file.getFileExtension();
        if (extension.equals(WebDynproMDOEnum.COMPONENT.getFileExtension())) {
            int i = 0;
            while (i < components.length) {
                if (components[i].getName().equals(objectName) && components[i].getPackage().equals(packageName)) {
                    return components[i].getComponentController();
                }
                ++i;
            }
            return null;
        }
        if (extension.equals(WebDynproMDOEnum.COMPONENTINTERFACEDEFINITION.getFileExtension())) {
            int i = 0;
            while (i < componentInterfaceDefinitions.length) {
                if (componentInterfaceDefinitions[i].getName().equals(objectName) && componentInterfaceDefinitions[i].getPackage().equals(packageName)) {
                    return componentInterfaceDefinitions[i].getInterfaceController();
                }
                ++i;
            }
            return null;
        }
        if (extension.equals(WebDynproMDOEnum.VIEW.getFileExtension())) {
            int i = 0;
            while (i < components.length) {
                View[] views = components[i].getViews();
                int j = 0;
                while (j < views.length) {
                    if (views[j].getName().equals(objectName) && views[j].getPackage().equals(packageName)) {
                        return views[j].getViewController();
                    }
                    ++j;
                }
                ++i;
            }
            return null;
        }
        if (extension.equals(WebDynproMDOEnum.INTERFACEVIEW.getFileExtension())) {
            int j;
            InterfaceView[] views;
            int i = 0;
            while (i < components.length) {
                ComponentInterfaceImplementation componentInterface = components[i].getComponentInterface();
                views = componentInterface.getInterfaceViews();
                j = 0;
                while (j < views.length) {
                    if (views[j].getName().equals(objectName) && views[j].getPackage().equals(packageName)) {
                        return views[j].getViewController();
                    }
                    ++j;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < componentInterfaceDefinitions.length) {
                views = componentInterfaceDefinitions[i2].getInterfaceViews();
                j = 0;
                while (j < views.length) {
                    if (views[j].getName().equals(objectName) && views[j].getPackage().equals(packageName)) {
                        return views[j].getViewController();
                    }
                    ++j;
                }
                ++i2;
            }
            return null;
        }
        if (extension.equals(WebDynproMDOEnum.CONTROLLER.getFileExtension())) {
            int i = 0;
            while (i < components.length) {
                Controller[] controllers = components[i].getControllers();
                int j = 0;
                while (j < controllers.length) {
                    if (controllers[j].getName().equals(objectName) && controllers[j].getPackage().equals(packageName)) {
                        return controllers[j];
                    }
                    ++j;
                }
                ComponentInterfaceImplementation componentInterface = components[i].getComponentInterface();
                controllers = componentInterface.getControllers();
                int j2 = 0;
                while (j2 < controllers.length) {
                    if (controllers[j2].getName().equals(objectName) && controllers[j2].getPackage().equals(packageName)) {
                        return controllers[j2];
                    }
                    ++j2;
                }
                ++i;
            }
            int i3 = 0;
            while (i3 < componentInterfaceDefinitions.length) {
                Controller[] controllers = componentInterfaceDefinitions[i3].getControllers();
                int j = 0;
                while (j < controllers.length) {
                    if (controllers[j].getName().equals(objectName) && controllers[j].getPackage().equals(packageName)) {
                        return controllers[j];
                    }
                    ++j;
                }
                ++i3;
            }
            return null;
        }
        if (extension.equals(WebDynproMDOEnum.COMPONENTINTERFACEIMPLEMENTATION.getFileExtension())) {
            int i = 0;
            while (i < components.length) {
                if (components[i].getComponentInterface() != null && components[i].getComponentInterface().getInterfaceController() != null && components[i].getComponentInterface().getInterfaceController().getName().equals(objectName) && components[i].getComponentInterface().getInterfaceController().getPackage().equals(packageName)) {
                    return components[i].getComponentInterface().getInterfaceController();
                }
                ++i;
            }
            return null;
        }
        return null;
    }
}

