/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.implementation;

import com.sap.ide.metamodel.webdynpro.base.Procedure;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.service.controllereditor.ServiceControllerEditorPlugin;
import com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService;
import com.sap.ide.webdynpro.service.core.UIHelper;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;

public class CodingService {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String COMMENT_BEGIN = "//@@begin";
    private static final String COMMENT_END = "//@@end";
    public static final String RESULT_PREFIX_WARNING = "Warning: ";
    public static final int INSERT_POSITION_BEGINNING = 0;
    public static final int INSERT_POSITION_END = 1;
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$controllereditor$implementation$CodingService;

    public static String insertCoding(Procedure procedure, String coding, String comment, int position) {
        String result = null;
        if (procedure != null && procedure.getParent() instanceof Controller) {
            Controller controller = (Controller)procedure.getParent();
            ImplementationService implementationService = new ImplementationService(controller);
            implementationService.updateImplementationFromXML();
            ResourcesPlugin.getWorkspace().checkpoint(true);
            IMethod method = ImplementationService.getJDTMethod(controller, procedure.getName(), null);
            if (method != null) {
                String originalSource = null;
                try {
                    originalSource = method.getSource();
                }
                catch (JavaModelException e) {
                    ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$implementation$CodingService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$implementation$CodingService = CodingService.class$("com.sap.ide.webdynpro.service.controllereditor.implementation.CodingService")) : class$com$sap$ide$webdynpro$service$controllereditor$implementation$CodingService, "insertCoding(Procedure, String, String, int)", e.getMessage(), e, true);
                    UIHelper.displayWarningMessage((String)"Could not insert coding", (String)"Could not get original coding");
                    return "Could not get original coding";
                }
                String codeBlock = CodingService.stripOffHeader(originalSource);
                if (!CodingService.isUCABlockEmpty(codeBlock)) {
                    result = "Warning: Coding block was not empty, please check the generated coding for correctness.";
                }
                switch (position) {
                    case 0: {
                        codeBlock = CodingService.embedSourceInTargetUCAatBeginning(codeBlock, coding);
                        break;
                    }
                    case 1: {
                        codeBlock = CodingService.embedSourceInTargetUCAatEnd(codeBlock, coding);
                        break;
                    }
                    default: {
                        UIHelper.displayWarningMessage((String)"Could not insert coding", (String)"Invalid insert position");
                    }
                }
                if (!ImplementationService.setMethodBody(controller, procedure.getName(), codeBlock, comment, null)) {
                    UIHelper.displayWarningMessage((String)"Could not insert coding", (String)"Could not set new coding");
                    return "Could not set new coding";
                }
                implementationService.updateImplementationFromXML();
                ResourcesPlugin.getWorkspace().checkpoint(true);
            }
        }
        return result;
    }

    private static String embedSourceInTargetUCAatBeginning(String targetSource, String source) {
        int indexBeginCommentEnd;
        if (source == null) {
            return targetSource;
        }
        if (targetSource == null) {
            return source;
        }
        String newTargetSource = "";
        int indexBeginCommentBegin = targetSource.indexOf(COMMENT_BEGIN);
        String indentCoding = CodingService.getIndentString(targetSource, COMMENT_BEGIN);
        if (indexBeginCommentBegin != -1 && (indexBeginCommentEnd = targetSource.indexOf(LINE_SEPARATOR, indexBeginCommentBegin)) != -1) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(targetSource.substring(0, indexBeginCommentEnd += LINE_SEPARATOR.length()));
            String leftCoding = source;
            int index = -1;
            while ((index = leftCoding.indexOf(LINE_SEPARATOR)) != -1) {
                String line = leftCoding.substring(0, index);
                leftCoding = leftCoding.substring(index + LINE_SEPARATOR.length());
                buffer.append(indentCoding);
                buffer.append(line);
                buffer.append(LINE_SEPARATOR);
            }
            buffer.append(leftCoding);
            buffer.append(targetSource.substring(indexBeginCommentEnd + LINE_SEPARATOR.length()));
            newTargetSource = buffer.toString();
        }
        return newTargetSource;
    }

    private static String embedSourceInTargetUCAatEnd(String targetSource, String source) {
        if (source == null) {
            return targetSource;
        }
        if (targetSource == null) {
            return source;
        }
        String newTargetSource = "";
        int indexEndCommentBegin = targetSource.indexOf(COMMENT_END);
        String indentCoding = CodingService.getIndentString(targetSource, COMMENT_END);
        if (indexEndCommentBegin != -1) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(targetSource.substring(0, indexEndCommentBegin));
            String leftCoding = source;
            int index = -1;
            while ((index = leftCoding.indexOf(LINE_SEPARATOR)) != -1) {
                String line = leftCoding.substring(0, index);
                leftCoding = leftCoding.substring(index + LINE_SEPARATOR.length());
                buffer.append(indentCoding);
                buffer.append(line);
                buffer.append(LINE_SEPARATOR);
            }
            buffer.append(leftCoding);
            buffer.append(targetSource.substring(indexEndCommentBegin + LINE_SEPARATOR.length()));
            newTargetSource = buffer.toString();
        }
        return newTargetSource;
    }

    private static String getIndentString(String source, String indentTo) {
        String indentCoding = "";
        if (source != null && indentTo != null) {
            int indexFirstLineSeparator = source.indexOf(LINE_SEPARATOR);
            int indexBeginCommentBegin = source.indexOf(COMMENT_BEGIN);
            if (!source.startsWith(" ") && !source.startsWith("\t")) {
                if (indexFirstLineSeparator == -1) {
                    indexFirstLineSeparator = 0;
                }
                if (indexFirstLineSeparator > indexBeginCommentBegin) {
                    indexFirstLineSeparator = indexBeginCommentBegin;
                }
                if ((indentCoding = source.substring(indexFirstLineSeparator + LINE_SEPARATOR.length(), indexBeginCommentBegin)).startsWith(LINE_SEPARATOR)) {
                    indentCoding = indentCoding.substring(LINE_SEPARATOR.length());
                }
            }
        }
        return indentCoding;
    }

    private static String stripOffHeader(String methodCoding) {
        int indexClosingCodeBlockBracket;
        int indexOpeningCodeBlockBracket = methodCoding.indexOf("{");
        if (indexOpeningCodeBlockBracket == -1) {
            indexOpeningCodeBlockBracket = 0;
        }
        if ((indexClosingCodeBlockBracket = methodCoding.lastIndexOf("}")) == -1) {
            indexClosingCodeBlockBracket = methodCoding.length();
        }
        String codeBlock = methodCoding.substring(indexOpeningCodeBlockBracket, indexClosingCodeBlockBracket + 1);
        return codeBlock;
    }

    private static boolean isUCABlockEmpty(String block) {
        String content;
        int indexEndCommentBegin;
        int indexBeginCommentEnd;
        boolean result = true;
        int indexBeginCommentBegin = block.indexOf(COMMENT_BEGIN);
        if (indexBeginCommentBegin != -1 && (indexBeginCommentEnd = block.indexOf(LINE_SEPARATOR, indexBeginCommentBegin)) != -1 && (indexEndCommentBegin = block.indexOf(COMMENT_END)) != -1 && (content = block.substring(indexBeginCommentEnd += LINE_SEPARATOR.length(), indexEndCommentBegin)) != null) {
            result = content.trim().length() == 0;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

