/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.fieldgroup;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.base.Validator;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.FieldGroup;
import com.sap.ide.metamodel.webdynpro.repository.MMRepositoryObjectProvider;
import com.sap.ide.webdynpro.service.controllereditor.ServiceControllerEditorPlugin;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import java.util.ArrayList;

public class FieldGroupService {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$controllereditor$fieldgroup$FieldGroupService;

    public static String isNewFieldGroupNameValid(String fieldGroupName, Controller controller) {
        if (!CheckServices.isValidIdentifier((String)fieldGroupName)) {
            return mCoreTextPool.getText(39, (Object)fieldGroupName);
        }
        if (controller.hasFieldGroup(fieldGroupName)) {
            return mTextPool.getText(1024, mTextPool.getText(14), fieldGroupName);
        }
        return null;
    }

    public static String isNewFieldNameValid(String fieldName) {
        if (!CheckServices.isValidIdentifier((String)fieldName)) {
            return mCoreTextPool.getText(39, (Object)fieldName);
        }
        return null;
    }

    public static Parameter getValidatorParameterForField(FieldGroup group, ContextAttribute attribute) {
        Validator validator = group.getValidator();
        if (validator == null) {
            return null;
        }
        int attributeIndex = -1;
        ContextAttribute[] attributes = group.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            if (attributes[i].equals(attribute)) {
                attributeIndex = i;
            }
            ++i;
        }
        if (attributeIndex == -1) {
            return null;
        }
        Parameter[] parameters = validator.getParameters();
        if (parameters.length <= attributeIndex) {
            return null;
        }
        return parameters[attributeIndex];
    }

    public static String createFieldGroup(Controller controller, String fieldGroupName, String validatorName) {
        WebDynproRoot webDynproRoot = (WebDynproRoot)controller.getRoot();
        try {
            webDynproRoot.disableAutoNotify();
            FieldGroup fieldGroup = null;
            Validator validator = null;
            try {
                fieldGroup = controller.createFieldGroup(fieldGroupName);
                validator = controller.createValidator(validatorName);
            }
            catch (CreateException e) {
                String string = e.getMessage();
                Object var9_8 = null;
                webDynproRoot.notifyObservers();
                webDynproRoot.enableAutoNotify();
                return string;
            }
            fieldGroup.setValidator(validator);
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            webDynproRoot.notifyObservers();
            webDynproRoot.enableAutoNotify();
            throw throwable;
        }
        webDynproRoot.notifyObservers();
        webDynproRoot.enableAutoNotify();
        return null;
    }

    public static String deleteFieldGroup(FieldGroup fieldGroup) {
        WebDynproRoot webDynproRoot = (WebDynproRoot)fieldGroup.getRoot();
        try {
            try {
                webDynproRoot.disableAutoNotify();
                fieldGroup.delete();
            }
            catch (DeleteException e) {
                ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$fieldgroup$FieldGroupService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$fieldgroup$FieldGroupService = FieldGroupService.class$("com.sap.ide.webdynpro.service.controllereditor.fieldgroup.FieldGroupService")) : class$com$sap$ide$webdynpro$service$controllereditor$fieldgroup$FieldGroupService, "deleteFieldGroup(FieldGroup)", e.getMessage(), e, false);
                String string = e.getMessage();
                Object var5_3 = null;
                webDynproRoot.notifyObservers();
                webDynproRoot.enableAutoNotify();
                return string;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            webDynproRoot.notifyObservers();
            webDynproRoot.enableAutoNotify();
            throw throwable;
        }
        webDynproRoot.notifyObservers();
        webDynproRoot.enableAutoNotify();
        return null;
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByFieldGroupCreation(Controller controller) {
        ArrayList<MMRepositoryObject> result = new ArrayList<MMRepositoryObject>();
        result.add(MMRepositoryObjectProvider.getRepositoryObject((Controller)controller, (boolean)false));
        return result.toArray(new MMRepositoryObject[0]);
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByFieldGroupModification(FieldGroup fieldGroup) {
        if (fieldGroup.getParent() instanceof Controller) {
            return FieldGroupService.getRepositoryObjectsAffectedByFieldGroupCreation((Controller)fieldGroup.getParent());
        }
        ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$fieldgroup$FieldGroupService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$fieldgroup$FieldGroupService = FieldGroupService.class$("com.sap.ide.webdynpro.service.controllereditor.fieldgroup.FieldGroupService")) : class$com$sap$ide$webdynpro$service$controllereditor$fieldgroup$FieldGroupService, "getRepositoryObjectsAffectedByFieldGroupModification(FieldGroup)", "Field group parent is no controller", new Exception(), false);
        return new MMRepositoryObject[0];
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByFieldGroupDeletion(FieldGroup fieldGroup) {
        return FieldGroupService.getRepositoryObjectsAffectedByFieldGroupModification(fieldGroup);
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByFieldCreation(FieldGroup fieldGroup) {
        ArrayList<MMRepositoryObject> result = new ArrayList<MMRepositoryObject>();
        DevelopmentObject object = fieldGroup.getParent();
        if (object instanceof Controller) {
            result.add(MMRepositoryObjectProvider.getRepositoryObject((Controller)((Controller)object), (boolean)false));
        } else {
            ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$fieldgroup$FieldGroupService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$fieldgroup$FieldGroupService = FieldGroupService.class$("com.sap.ide.webdynpro.service.controllereditor.fieldgroup.FieldGroupService")) : class$com$sap$ide$webdynpro$service$controllereditor$fieldgroup$FieldGroupService, "getRepositoryObjectsAffectedByFieldCreation(FieldGroup)", "Field group parent is no controller", new Exception(), false);
        }
        return result.toArray(new MMRepositoryObject[0]);
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByFieldModification(ContextAttribute field) {
        if (field.getParent() instanceof FieldGroup) {
            FieldGroup fieldGroup = (FieldGroup)field.getParent();
            return FieldGroupService.getRepositoryObjectsAffectedByFieldCreation(fieldGroup);
        }
        ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$fieldgroup$FieldGroupService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$fieldgroup$FieldGroupService = FieldGroupService.class$("com.sap.ide.webdynpro.service.controllereditor.fieldgroup.FieldGroupService")) : class$com$sap$ide$webdynpro$service$controllereditor$fieldgroup$FieldGroupService, "getRepositoryObjectsAffectedByFieldModification(ContextAttribute)", "Field parent is no field group", new Exception(), false);
        return new MMRepositoryObject[0];
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByFieldDeletion(ContextAttribute field) {
        return FieldGroupService.getRepositoryObjectsAffectedByFieldModification(field);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

