/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.eventhandler;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.webdynpro.base.EventHandler;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.base.ParameterizedFeature;
import com.sap.ide.metamodel.webdynpro.component.controller.Action;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerEventHandler;
import com.sap.ide.metamodel.webdynpro.component.navigation.InboundPlug;
import com.sap.ide.metamodel.webdynpro.component.view.AbstractView;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.metamodel.webdynpro.repository.MMRepositoryObjectProvider;
import com.sap.ide.webdynpro.service.controllereditor.ServiceControllerEditorPlugin;
import com.sap.ide.webdynpro.service.controllereditor.ServiceException;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.method.MethodService;
import com.sap.ide.webdynpro.service.controllereditor.parameter.ParameterService;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import java.util.ArrayList;

public class EventhandlerService {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    public static final String EVENT_HANDLER_PREFIX = "on";
    public static final String ACTION_EVENT_HANDLER_PREFIX = "onAction";
    public static final String PLUG_EVENT_HANDLER_PREFIX = "onPlug";
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$controllereditor$eventhandler$EventhandlerService;

    public static String isNewEventHandlerNameValid(String eventHandlerName, Controller controller) {
        return MethodService.isNewMethodNameValid(eventHandlerName, controller);
    }

    public static String isNewEventSourceNameValid(String eventSourceName) {
        return null;
    }

    public static String isNewSubscribedEventNameValid(String subscribedEventName) {
        if (subscribedEventName.equals("")) {
            return null;
        }
        if (!CheckServices.isValidIdentifier((String)subscribedEventName)) {
            return mCoreTextPool.getText(39, (Object)subscribedEventName);
        }
        return null;
    }

    public static EventHandler createEventHandlerForParameterizedFeature(ParameterizedFeature object, Controller controller, String eventHandlerName) throws ServiceException {
        if (controller.hasEventHandler(eventHandlerName)) {
            ServiceException e = new ServiceException(1);
            e.setObjectType(mTextPool.getText(900));
            e.setObjectName(eventHandlerName);
            throw e;
        }
        ControllerEventHandler eventHandler = null;
        try {
            eventHandler = controller.createEventHandler(eventHandlerName);
        }
        catch (CreateException e) {
            ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$eventhandler$EventhandlerService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$eventhandler$EventhandlerService = EventhandlerService.class$("com.sap.ide.webdynpro.service.controllereditor.eventhandler.EventhandlerService")) : class$com$sap$ide$webdynpro$service$controllereditor$eventhandler$EventhandlerService, "createEventHandlerForParameterizedFeature(ParameterizedFeature, Controller, String)", e.getMessage(), e, false);
            ServiceException se = new ServiceException(0, (Exception)((Object)e));
            se.setMessage(e.getMessage());
            throw se;
        }
        Parameter[] parameters = object.getParameters();
        int i = 0;
        while (i < parameters.length) {
            ParameterService.copyParameterToOtherObject(parameters[i], (ParameterizedFeature)eventHandler);
            ++i;
        }
        return eventHandler;
    }

    public static Action[] getActionsForEventhandler(EventHandler eventHandler) {
        Controller controller = (Controller)eventHandler.getParent();
        Action[] actions = controller.getActions();
        ArrayList<Action> list = new ArrayList<Action>();
        int i = 0;
        while (i < actions.length) {
            if (actions[i].getEventHandler() != null && actions[i].getEventHandler().equals(eventHandler)) {
                list.add(actions[i]);
            }
            ++i;
        }
        if (list.size() == 0) {
            return null;
        }
        actions = new Action[list.size()];
        actions = list.toArray(actions);
        return actions;
    }

    public static InboundPlug[] getInboundPlugsForEventhandler(EventHandler eventHandler) {
        Controller controller = (Controller)eventHandler.getParent();
        if (!controller.getType().equals(ControllerTypeEnum.VIEW)) {
            return null;
        }
        AbstractView view = controller.getView();
        InboundPlug[] plugs = view.getInboundPlugs();
        ArrayList<InboundPlug> list = new ArrayList<InboundPlug>();
        int i = 0;
        while (i < plugs.length) {
            if (plugs[i].getEventHandler() != null && plugs[i].getEventHandler().equals(eventHandler)) {
                list.add(plugs[i]);
            }
            ++i;
        }
        if (list.size() == 0) {
            return null;
        }
        plugs = new InboundPlug[list.size()];
        plugs = list.toArray(plugs);
        return plugs;
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByEventHandlerCreation(Controller controller) {
        ArrayList<MMRepositoryObject> result = new ArrayList<MMRepositoryObject>();
        result.add(MMRepositoryObjectProvider.getRepositoryObject((Controller)controller, (boolean)false));
        return result.toArray(new MMRepositoryObject[0]);
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByEventHandlerModification(EventHandler eventHandler) {
        if (eventHandler.getParent() instanceof Controller) {
            return EventhandlerService.getRepositoryObjectsAffectedByEventHandlerCreation((Controller)eventHandler.getParent());
        }
        ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$eventhandler$EventhandlerService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$eventhandler$EventhandlerService = EventhandlerService.class$("com.sap.ide.webdynpro.service.controllereditor.eventhandler.EventhandlerService")) : class$com$sap$ide$webdynpro$service$controllereditor$eventhandler$EventhandlerService, "getRepositoryObjectsAffectedByEventHandlerModification(EventHandler)", "Event handler parent is no controller", new Exception(), false);
        return new MMRepositoryObject[0];
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByEventHandlerDeletion(EventHandler eventHandler) {
        return EventhandlerService.getRepositoryObjectsAffectedByEventHandlerModification(eventHandler);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

