/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.event;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.base.CustomEvent;
import com.sap.ide.metamodel.webdynpro.base.EventHandler;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.event.Event;
import com.sap.ide.metamodel.webdynpro.repository.MMRepositoryObjectProvider;
import com.sap.ide.webdynpro.service.controllereditor.ServiceControllerEditorPlugin;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.controller.ControllerService;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import java.util.ArrayList;

public class EventService {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$controllereditor$event$EventService;

    public static String isNewEventNameValid(String eventName, Controller controller) {
        if (!CheckServices.isValidIdentifier((String)eventName)) {
            return mCoreTextPool.getText(39, (Object)eventName);
        }
        if (controller.hasEvent(eventName)) {
            return mTextPool.getText(1024, mTextPool.getText(12), eventName);
        }
        return null;
    }

    public static String createEvent(Controller controller, String eventName) {
        WebDynproRoot webDynproRoot = (WebDynproRoot)controller.getRoot();
        try {
            try {
                webDynproRoot.disableAutoNotify();
                controller.createEvent(eventName);
            }
            catch (CreateException e) {
                ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$event$EventService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$event$EventService = EventService.class$("com.sap.ide.webdynpro.service.controllereditor.event.EventService")) : class$com$sap$ide$webdynpro$service$controllereditor$event$EventService, "createEvent(Controller, String)", e.getMessage(), e, false);
                String string = e.getMessage();
                Object var6_4 = null;
                webDynproRoot.notifyObservers();
                webDynproRoot.enableAutoNotify();
                return string;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            webDynproRoot.notifyObservers();
            webDynproRoot.enableAutoNotify();
            throw throwable;
        }
        webDynproRoot.notifyObservers();
        webDynproRoot.enableAutoNotify();
        return null;
    }

    public static String deleteEvent(CustomEvent event) {
        WebDynproRoot webDynproRoot = (WebDynproRoot)event.getRoot();
        try {
            try {
                webDynproRoot.disableAutoNotify();
                EventService.removeEventhandlerReferences(event);
                event.delete();
            }
            catch (DeleteException e) {
                ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$event$EventService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$event$EventService = EventService.class$("com.sap.ide.webdynpro.service.controllereditor.event.EventService")) : class$com$sap$ide$webdynpro$service$controllereditor$event$EventService, "deleteEvent(ApplicationEvent)", e.getMessage(), e, false);
                String string = e.getMessage();
                Object var5_3 = null;
                webDynproRoot.notifyObservers();
                webDynproRoot.enableAutoNotify();
                return string;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            webDynproRoot.notifyObservers();
            webDynproRoot.enableAutoNotify();
            throw throwable;
        }
        webDynproRoot.notifyObservers();
        webDynproRoot.enableAutoNotify();
        return null;
    }

    private static void removeEventhandlerReferences(CustomEvent event) {
        if (event == null) {
            return;
        }
        Controller controller = (Controller)event.getParent();
        Controller[] incomingUsages = ControllerService.getAllUsingControllersWithinItsComponent(controller);
        int i = 0;
        while (i < incomingUsages.length) {
            Controller otherController = incomingUsages[i];
            EventHandler[] eventHandlers = otherController.getEventHandlers();
            int j = 0;
            while (j < eventHandlers.length) {
                if (event.equals(eventHandlers[j].getSubscribedEvent())) {
                    eventHandlers[j].setSubscribedEvent(null);
                }
                ++j;
            }
            ++i;
        }
    }

    public static String getExternalEventName(Event event) {
        if (event.getParent() instanceof MainDevelopmentObject) {
            return event.getName() + " <" + event.getParent().getName() + " - " + ((MainDevelopmentObject)event.getParent()).getPackage() + ">";
        }
        return event.getName();
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByEventCreation(Controller controller) {
        ArrayList<MMRepositoryObject> result = new ArrayList<MMRepositoryObject>();
        result.add(MMRepositoryObjectProvider.getRepositoryObject((Controller)controller, (boolean)false));
        return result.toArray(new MMRepositoryObject[0]);
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByEventModification(CustomEvent event) {
        if (event.getParent() instanceof Controller) {
            return EventService.getRepositoryObjectsAffectedByEventCreation((Controller)event.getParent());
        }
        ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$event$EventService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$event$EventService = EventService.class$("com.sap.ide.webdynpro.service.controllereditor.event.EventService")) : class$com$sap$ide$webdynpro$service$controllereditor$event$EventService, "getRepositoryObjectsAffectedByEventModification(CustomEvent)", "Event parent is no controller", new Exception(), false);
        return new MMRepositoryObject[0];
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByEventDeletion(CustomEvent event) {
        return EventService.getRepositoryObjectsAffectedByEventModification(event);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

