/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.controller;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.WebDynproMDOEnum;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.webdynpro.service.controllereditor.controller.ControllerService;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.refac.RefactoringServices;
import com.sap.ide.webdynpro.ui.dialog.WDCopyDialog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WDCopyControllerDialog
extends WDCopyDialog {
    private static final CoreTextPool mCPool = CoreTextPool.getInstance();
    private static final String CONTROLLER = mCPool.getText(100);
    private static final String COPY_CONTROLLER = mCPool.getText(155, (Object)CONTROLLER);
    private Metamodel mMetamodel = null;
    private String mControllerName = null;
    private String mControllerPackage = null;
    private IPackageFragmentRoot mPreselectedRoot = null;
    private boolean mEnableSourceFolderList = true;
    private ClipboardObject[] mClipboardObjects = null;
    private Component mNewComponent = null;
    private boolean mDeleteNameMessage = true;
    private boolean mDeletePackageMessage = true;

    public WDCopyControllerDialog(IPackageFragmentRoot[] allValidRoots, IPackageFragmentRoot preselectedRoot, Metamodel newMetamodel, Component newComponent, String controllerName, String controllerPackage, ClipboardObject[] clipboardObjects, boolean enableSourceFolderList) {
        super(allValidRoots, COPY_CONTROLLER, "");
        this.mPreselectedRoot = preselectedRoot;
        this.mMetamodel = newMetamodel;
        this.mNewComponent = newComponent;
        this.mControllerName = controllerName;
        this.mControllerPackage = controllerPackage;
        this.mClipboardObjects = clipboardObjects;
        this.mEnableSourceFolderList = enableSourceFolderList;
    }

    protected void initializeListeners() {
        this.getNameField().addModifyListener((ModifyListener)new ControllerNameModifyListener());
        this.getPackageField().addModifyListener((ModifyListener)new ControllerPackageModifyListener());
        this.getBrowsePackageButton().addSelectionListener((SelectionListener)new BrowseControllerPackageButtonListener());
        this.getSourcePathListField().addSelectionListener((SelectionListener)new ControllerSourceSelectionListener());
    }

    protected void initializeFields() {
        if (this.mControllerName != null) {
            String oldName = this.mControllerName;
            String searchName = this.mControllerName;
            int nr = 0;
            while (this.mMetamodel.objectExists(this.mControllerPackage, searchName, WebDynproMDOEnum.CONTROLLER) || ControllerService.isNewControllerNameValid(searchName, this.mControllerPackage, this.mMetamodel, (MainDevelopmentObject)this.mNewComponent) != null) {
                String number = "_" + nr++;
                if (nr == 1) {
                    number = "";
                }
                searchName = "Copy" + number + "_of_" + oldName;
                this.setMessage(mCPool.getText(310));
            }
            this.getNameField().setText(searchName);
            this.getNameField().setSelection(0, searchName.length() + 8);
            this.setName(this.getNameField().getText());
        }
        if (this.mControllerPackage != null) {
            this.getPackageField().setText(this.mControllerPackage);
            this.setPackage(this.mControllerPackage);
        }
        int preselectionIndex = 0;
        IPackageFragmentRoot[] roots = this.getAllValidRoots();
        if (roots == null || roots.length <= 0) {
            return;
        }
        int i = 0;
        while (i < roots.length) {
            if (this.mPreselectedRoot != null && roots[i].equals(this.mPreselectedRoot)) {
                preselectionIndex = i;
            }
            ++i;
        }
        this.getSourcePathListField().setSelection(preselectionIndex);
        this.setSourceRoot(roots[preselectionIndex]);
        this.getSourcePathListField().setEnabled(this.mEnableSourceFolderList);
    }

    public void handlePageCompletion() {
        if (this.mDeleteNameMessage && this.mDeletePackageMessage) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        this.setPageComplete(true);
        this.setName(this.getNameField().getText());
        this.setPackage(this.getPackageField().getText());
    }

    private boolean isValidNameField() {
        this.mDeleteNameMessage = true;
        String nameInput = this.getNameField().getText();
        String packageInput = this.getPackageField().getText();
        nameInput = CheckServices.checkFirstCharacter((Text)this.getNameField());
        IStatus checkResult = ControllerService.isNewControllerNameValid(nameInput, packageInput, this.mMetamodel, (MainDevelopmentObject)this.mNewComponent, 0);
        if (checkResult.getSeverity() == 2) {
            this.setMessage(checkResult.getMessage(), 2);
            this.mDeleteNameMessage = false;
        } else if (checkResult.getSeverity() == 4) {
            this.setErrorMessage(checkResult.getMessage());
            return false;
        }
        boolean existsInClip = RefactoringServices.nameExistsInClipboard((String)nameInput, (String)packageInput, (DevelopmentObjectEnum)WebDynproDevelopmentObjectEnum.CONTROLLER, (ClipboardObject[])this.mClipboardObjects);
        if (existsInClip) {
            this.setErrorMessage(mCPool.getText(33, (Object)nameInput, (Object)packageInput));
            return false;
        }
        return true;
    }

    private boolean isValidPackageField() {
        this.mDeletePackageMessage = true;
        String packageInput = CheckServices.convertToLowerCase((Text)this.getPackageField());
        IStatus validatedStatus = CheckServices.isValidPackage((String)this.getPackageField().getText());
        if (validatedStatus.getSeverity() == 2) {
            this.setMessage(validatedStatus.getMessage(), 2);
            this.mDeletePackageMessage = false;
        } else if (validatedStatus.getSeverity() == 4) {
            this.setErrorMessage(validatedStatus.getMessage());
            return false;
        }
        return true;
    }

    protected void okPressed() {
        IPath sourcePath;
        MetamodelManager manager;
        SourcePathIdentifier identifier;
        String packageInput;
        String nameInput = this.getNameField().getText();
        IStatus status = CheckServices.isValidMDOPath((Metamodel)this.mMetamodel, (MDOEnum)WebDynproMDOEnum.CONTROLLER, (String)nameInput, (String)(packageInput = this.getPackageField().getText()), (SourcePathIdentifier)(identifier = (manager = MetamodelManager.getMetamodelManager((String)this.mMetamodel.getName())).getSourcePathIdentifier(sourcePath = manager.makePathAbsolute(this.getSourceRoot().getPath()))));
        if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
            return;
        }
        boolean controllerExists = this.mMetamodel.objectExists(this.getPackageField().getText(), this.getNameField().getText(), WebDynproMDOEnum.CONTROLLER);
        if (controllerExists) {
            this.setErrorMessage(CoreTextPool.getInstance().getText(25, (Object)nameInput, (Object)packageInput));
            this.setPageComplete(false);
            return;
        }
        if (status.getSeverity() == 0 && !controllerExists) {
            super.okPressed();
        }
    }

    class BrowseControllerPackageButtonListener
    extends SelectionAdapter {
        BrowseControllerPackageButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            IPackageFragment packageFragment = ServicesUI.browsePackages((IPackageFragmentRoot)WDCopyControllerDialog.this.getSourceRoot(), (Shell)WDCopyControllerDialog.this.getShell());
            if (packageFragment != null) {
                WDCopyControllerDialog.this.getPackageField().setText(packageFragment.getElementName());
            }
            if (WDCopyControllerDialog.this.isValidPackageField() && WDCopyControllerDialog.this.isValidNameField() && WDCopyControllerDialog.this.getSourcePathListField().getItemCount() > 0) {
                WDCopyControllerDialog.this.handlePageCompletion();
            } else {
                WDCopyControllerDialog.this.setPageComplete(false);
            }
        }
    }

    class ControllerSourceSelectionListener
    implements SelectionListener {
        ControllerSourceSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int selectionIndex = WDCopyControllerDialog.this.getSourcePathListField().getSelectionIndex();
            if (selectionIndex >= 0) {
                IPackageFragmentRoot selectedRoot = WDCopyControllerDialog.this.getAllValidRoots()[selectionIndex];
                WDCopyControllerDialog.this.setSourceRoot(selectedRoot);
            }
        }
    }

    class ControllerPackageModifyListener
    implements ModifyListener {
        ControllerPackageModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (WDCopyControllerDialog.this.isValidPackageField() && WDCopyControllerDialog.this.isValidNameField() && WDCopyControllerDialog.this.getSourcePathListField().getItemCount() > 0) {
                WDCopyControllerDialog.this.handlePageCompletion();
            } else {
                WDCopyControllerDialog.this.setPageComplete(false);
            }
        }
    }

    class ControllerNameModifyListener
    implements ModifyListener {
        ControllerNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (WDCopyControllerDialog.this.isValidNameField() && WDCopyControllerDialog.this.isValidPackageField() && WDCopyControllerDialog.this.getSourcePathListField().getItemCount() > 0) {
                WDCopyControllerDialog.this.handlePageCompletion();
            } else {
                WDCopyControllerDialog.this.setPageComplete(false);
            }
        }
    }
}

