/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.controller;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.MMRepositoryObjectList;
import com.sap.ide.metamodel.core.services.MMCCheckServices;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.webdynpro.WebDynproMDOEnum;
import com.sap.ide.metamodel.webdynpro.WebDynproObject;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterface;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.enum.CardinalityEnum;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.metamodel.webdynpro.repository.ComponentRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.CustomControllerRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.MMRepositoryObjectProvider;
import com.sap.ide.metamodel.webdynpro.repository.ViewRepositoryManager;
import com.sap.ide.webdynpro.generation.eclipse.GenerationEclipse;
import com.sap.ide.webdynpro.generation.eclipse.deletion.DeletionService;
import com.sap.ide.webdynpro.generation.naming.NamingService;
import com.sap.ide.webdynpro.service.controllereditor.ServiceControllerEditorPlugin;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.EditorService;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class ControllerService {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$controllereditor$controller$ControllerService;

    public static String isNewControllerNameValid(String controllerName, String packageName, Metamodel metamodel, MainDevelopmentObject topParentMDO) {
        MMCCheckServices.CheckResult checkResult = MMCCheckServices.isValidMDOName((String)controllerName);
        if (!checkResult.isOk()) {
            return checkResult.getMessage();
        }
        if (Character.isLowerCase(controllerName.charAt(0))) {
            return mCoreTextPool.getText(17, (Object)controllerName);
        }
        if (metamodel.objectExists(packageName, controllerName, WebDynproMDOEnum.CONTROLLER)) {
            return mTextPool.getText(1024, mCoreTextPool.getText(100), controllerName);
        }
        if (topParentMDO instanceof Component ? ControllerService.doesAnyControllerExist((Component)topParentMDO, controllerName) : topParentMDO instanceof ComponentInterfaceDefinition && ControllerService.doesAnyControllerExist((ComponentInterfaceDefinition)topParentMDO, controllerName)) {
            return mTextPool.getText(1024, mCoreTextPool.getText(100), controllerName);
        }
        return null;
    }

    public static IStatus isNewControllerNameValid(String controllerName, String packageName, Metamodel metamodel, MainDevelopmentObject topParentMDO, int DummyParameter) {
        String pluginID = ServiceControllerEditorPlugin.getDefault().getDescriptor().getUniqueIdentifier();
        String warningMessage = null;
        MMCCheckServices.CheckResult checkResult = MMCCheckServices.isValidMDOName((String)controllerName);
        if (!checkResult.isOk()) {
            return new Status(4, pluginID, 4, checkResult.getMessage(), null);
        }
        IStatus lengthStatus = MMCCheckServices.isValidMDONameLength((String)controllerName);
        if (lengthStatus.getSeverity() == 2) {
            warningMessage = lengthStatus.getMessage();
        } else if (lengthStatus.getSeverity() == 4) {
            return new Status(4, pluginID, 4, lengthStatus.getMessage(), lengthStatus.getException());
        }
        if (controllerName != null && controllerName.length() > 0 && Character.isLowerCase(controllerName.charAt(0))) {
            return new Status(4, pluginID, 4, mCoreTextPool.getText(17, (Object)controllerName), null);
        }
        if (metamodel.objectExists(packageName, controllerName, WebDynproMDOEnum.CONTROLLER)) {
            return new Status(4, pluginID, 4, mTextPool.getText(1024, mCoreTextPool.getText(100), controllerName), null);
        }
        if (topParentMDO instanceof Component ? ControllerService.doesAnyControllerExist((Component)topParentMDO, controllerName) : topParentMDO instanceof ComponentInterfaceDefinition && ControllerService.doesAnyControllerExist((ComponentInterfaceDefinition)topParentMDO, controllerName)) {
            return new Status(4, pluginID, 4, mTextPool.getText(1024, mCoreTextPool.getText(100), controllerName), null);
        }
        if (warningMessage != null) {
            return new Status(2, pluginID, 2, warningMessage, null);
        }
        return new Status(0, pluginID, 0, "", null);
    }

    public static View findViewForViewController(Component component, Controller controller) {
        if (controller.getType().equals(ControllerTypeEnum.VIEW)) {
            View[] views = component.getViews();
            int i = 0;
            while (i < views.length) {
                if (views[i].getViewController() != null && views[i].getViewController().equals(controller)) {
                    return views[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByCustomControllerCreation(Component component) {
        ArrayList<MMRepositoryObject> result = new ArrayList<MMRepositoryObject>();
        result.add(ComponentRepositoryManager.getRepositioryObject((Component)component, (boolean)false));
        return result.toArray(new MMRepositoryObject[0]);
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByCustomControllerDeletion(Controller controller) {
        MMRepositoryObjectList list = new MMRepositoryObjectList();
        list.addRepositoryObject(CustomControllerRepositoryManager.getRepositioryObject((Controller)controller, (boolean)true));
        Component component = (Component)controller.getParent();
        if (component != null) {
            list.addRepositoryObject(ComponentRepositoryManager.getRepositioryObject((Component)component, (boolean)false));
        }
        ControllerService.getRepositoryObjectsOfUsingControllers(controller, list);
        return list.getRepositoryObjects();
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByViewControllerModification(Controller viewController) {
        MMRepositoryObjectList list = new MMRepositoryObjectList();
        list.addRepositoryObject(ViewRepositoryManager.getRepositioryObject((Controller)viewController, (boolean)true));
        return list.getRepositoryObjects();
    }

    public static Controller createCustomController(Component component, String packageName, String controllerName, SourcePathIdentifier sourcePathIdentifier) throws CreateException {
        return ControllerService.createCustomController(component, packageName, controllerName, sourcePathIdentifier, true);
    }

    public static Controller createCustomController(Component component, String packageName, String controllerName, SourcePathIdentifier sourcePathIdentifier, boolean generateImplementation) throws CreateException {
        Controller controller = ControllerService.createControllerMetadata((WebDynproObject)component, packageName, controllerName, sourcePathIdentifier);
        controller.setType(ControllerTypeEnum.CUSTOM);
        if (generateImplementation) {
            ControllerService.createControllerImplementation(controller, null);
        }
        return controller;
    }

    public static Controller createViewController(View view, String packageName, String controllerName) throws CreateException {
        return ControllerService.createViewController(view, packageName, controllerName, true);
    }

    public static Controller createViewController(View view, String packageName, String controllerName, SourcePathIdentifier sourcePathId) throws CreateException {
        return ControllerService.createViewController(view, packageName, controllerName, sourcePathId, true);
    }

    public static Controller createViewController(View view, String packageName, String controllerName, boolean generateImplementation) throws CreateException {
        return ControllerService.createViewController(view, packageName, controllerName, null, generateImplementation);
    }

    public static Controller createViewController(View view, String packageName, String controllerName, SourcePathIdentifier sourcePathId, boolean generateImplementation) throws CreateException {
        Component component = (Component)view.getParent();
        Controller controller = ControllerService.createControllerMetadata((WebDynproObject)component, packageName, controllerName, sourcePathId);
        controller.setType(ControllerTypeEnum.VIEW);
        view.setViewController(controller);
        if (generateImplementation) {
            ControllerService.createControllerImplementation(controller, null);
        }
        return controller;
    }

    public static Controller createInterfaceViewController(InterfaceView view, String packageName, String controllerName) throws CreateException {
        return ControllerService.createInterfaceViewController(view, packageName, controllerName, true);
    }

    public static Controller createInterfaceViewController(InterfaceView view, String packageName, String controllerName, boolean generateImplementation) throws CreateException {
        return ControllerService.createInterfaceViewController(view, packageName, controllerName, generateImplementation, null);
    }

    public static Controller createInterfaceViewController(InterfaceView view, String packageName, String controllerName, SourcePathIdentifier sourcePathId) throws CreateException {
        return ControllerService.createInterfaceViewController(view, packageName, controllerName, sourcePathId, true);
    }

    public static Controller createInterfaceViewController(InterfaceView view, String packageName, String controllerName, SourcePathIdentifier sourcePathId, boolean generateImplementation) throws CreateException {
        return ControllerService.createInterfaceViewController(view, packageName, controllerName, sourcePathId, generateImplementation, null);
    }

    public static Controller createInterfaceViewController(InterfaceView view, String packageName, String controllerName, boolean generateImplementation, ProgressMonitorDialog dialog) throws CreateException {
        return ControllerService.createInterfaceViewController(view, packageName, controllerName, null, generateImplementation, dialog);
    }

    public static Controller createInterfaceViewController(InterfaceView view, String packageName, String controllerName, SourcePathIdentifier sourcePathId, boolean generateImplementation, ProgressMonitorDialog dialog) throws CreateException {
        ComponentInterface componentInterface = (ComponentInterface)view.getParent();
        Controller controller = ControllerService.createControllerMetadata((WebDynproObject)componentInterface, packageName, controllerName, sourcePathId);
        controller.setType(ControllerTypeEnum.INTERFACE_VIEW);
        view.setViewController(controller);
        if (generateImplementation) {
            ControllerService.createControllerImplementation(controller, dialog);
        }
        return controller;
    }

    public static Controller createComponentController(Component component, String packageName, String controllerName) throws CreateException {
        return ControllerService.createComponentController(component, packageName, controllerName, true);
    }

    public static Controller createComponentController(Component component, String packageName, String controllerName, boolean generateImplementation) throws CreateException {
        return ControllerService.createComponentController(component, packageName, controllerName, generateImplementation, null);
    }

    public static Controller createComponentController(Component component, String packageName, String controllerName, SourcePathIdentifier sourcePathId) throws CreateException {
        return ControllerService.createComponentController(component, packageName, controllerName, sourcePathId, true);
    }

    public static Controller createComponentController(Component component, String packageName, String controllerName, SourcePathIdentifier sourcePathId, boolean generateImplementation) throws CreateException {
        return ControllerService.createComponentController(component, packageName, controllerName, sourcePathId, generateImplementation, null);
    }

    public static Controller createComponentController(Component component, String packageName, String controllerName, boolean generateImplementation, ProgressMonitorDialog dialog) throws CreateException {
        return ControllerService.createComponentController(component, packageName, controllerName, null, generateImplementation, dialog);
    }

    public static Controller createComponentController(Component component, String packageName, String controllerName, SourcePathIdentifier sourcePathId, boolean generateImplementation, ProgressMonitorDialog dialog) throws CreateException {
        Controller controller = ControllerService.createControllerMetadata((WebDynproObject)component, packageName, controllerName, sourcePathId);
        controller.setType(ControllerTypeEnum.COMPONENT);
        component.setComponentController(controller);
        if (generateImplementation) {
            ControllerService.createControllerImplementation(controller, dialog);
        }
        return controller;
    }

    public static Controller createComponentInterfaceController(ComponentInterface componentInterface, String packageName, String controllerName) throws CreateException {
        return ControllerService.createComponentInterfaceController(componentInterface, packageName, controllerName, true);
    }

    public static Controller createComponentInterfaceController(ComponentInterface componentInterface, String packageName, String controllerName, boolean generateImplementation) throws CreateException {
        return ControllerService.createComponentInterfaceController(componentInterface, packageName, controllerName, generateImplementation, null);
    }

    public static Controller createComponentInterfaceController(ComponentInterface componentInterface, String packageName, String controllerName, SourcePathIdentifier sourcePathId) throws CreateException {
        return ControllerService.createComponentInterfaceController(componentInterface, packageName, controllerName, sourcePathId, true);
    }

    public static Controller createComponentInterfaceController(ComponentInterface componentInterface, String packageName, String controllerName, SourcePathIdentifier sourcePathId, boolean generateImplementation) throws CreateException {
        return ControllerService.createComponentInterfaceController(componentInterface, packageName, controllerName, sourcePathId, generateImplementation, null);
    }

    public static Controller createComponentInterfaceController(ComponentInterface componentInterface, String packageName, String controllerName, boolean generateImplementation, ProgressMonitorDialog dialog) throws CreateException {
        return ControllerService.createComponentInterfaceController(componentInterface, packageName, controllerName, null, generateImplementation, dialog);
    }

    public static Controller createComponentInterfaceController(ComponentInterface componentInterface, String packageName, String controllerName, SourcePathIdentifier sourcePathId, boolean generateImplementation, ProgressMonitorDialog dialog) throws CreateException {
        Controller controller = ControllerService.createControllerMetadata((WebDynproObject)componentInterface, packageName, controllerName, sourcePathId);
        controller.setType(ControllerTypeEnum.COMPONENT_INTERFACE);
        componentInterface.setInterfaceController(controller);
        if (generateImplementation) {
            ControllerService.createControllerImplementation(controller, dialog);
        }
        return controller;
    }

    public static Controller createComponentConfigurationController(ComponentInterface componentInterface, String packageName, String controllerName) throws CreateException {
        return ControllerService.createComponentConfigurationController(componentInterface, packageName, controllerName, true);
    }

    public static Controller createComponentConfigurationController(ComponentInterface componentInterface, String packageName, String controllerName, boolean generateImplementation) throws CreateException {
        return ControllerService.createComponentConfigurationController(componentInterface, packageName, controllerName, generateImplementation, null);
    }

    public static Controller createComponentConfigurationController(ComponentInterface componentInterface, String packageName, String controllerName, SourcePathIdentifier sourcePathId) throws CreateException {
        return ControllerService.createComponentConfigurationController(componentInterface, packageName, controllerName, sourcePathId, true);
    }

    public static Controller createComponentConfigurationController(ComponentInterface componentInterface, String packageName, String controllerName, SourcePathIdentifier sourcePathId, boolean generateImplementation) throws CreateException {
        return ControllerService.createComponentConfigurationController(componentInterface, packageName, controllerName, sourcePathId, generateImplementation, null);
    }

    public static Controller createComponentConfigurationController(ComponentInterface componentInterface, String packageName, String controllerName, boolean generateImplementation, ProgressMonitorDialog dialog) throws CreateException {
        return ControllerService.createComponentConfigurationController(componentInterface, packageName, controllerName, null, generateImplementation, dialog);
    }

    public static Controller createComponentConfigurationController(ComponentInterface componentInterface, String packageName, String controllerName, SourcePathIdentifier sourcePathId, boolean generateImplementation, ProgressMonitorDialog dialog) throws CreateException {
        Controller controller = ControllerService.createControllerMetadata((WebDynproObject)componentInterface, packageName, controllerName, sourcePathId);
        controller.setType(ControllerTypeEnum.COMPONENT_CONFIGURATION);
        componentInterface.setConfigurationController(controller);
        if (generateImplementation) {
            ControllerService.createControllerImplementation(controller, dialog);
        }
        return controller;
    }

    private static Controller createControllerMetadata(WebDynproObject webDynproObject, String packageName, String controllerName, SourcePathIdentifier sourcePathId) throws CreateException {
        if (webDynproObject.getRoot().getMetamodel().objectExists(packageName, controllerName, WebDynproMDOEnum.CONTROLLER)) {
            ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$controller$ControllerService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$controller$ControllerService = ControllerService.class$("com.sap.ide.webdynpro.service.controllereditor.controller.ControllerService")) : class$com$sap$ide$webdynpro$service$controllereditor$controller$ControllerService, "createControllerMetadata(WebDynproObject, String, String)", "File already exists", new Exception(), false);
            return null;
        }
        Controller controller = null;
        if (webDynproObject instanceof Component) {
            controller = ((Component)webDynproObject).createController(packageName, controllerName, sourcePathId);
        } else if (webDynproObject instanceof ComponentInterface) {
            controller = ((ComponentInterface)webDynproObject).createController(packageName, controllerName, sourcePathId);
        } else {
            ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$controller$ControllerService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$controller$ControllerService = ControllerService.class$("com.sap.ide.webdynpro.service.controllereditor.controller.ControllerService")) : class$com$sap$ide$webdynpro$service$controllereditor$controller$ControllerService, "createControllerMetadata(WebDynproObject, String, String)", "WebDnyproObject is neither a component nor a component interface", new Exception(), false);
            return null;
        }
        controller.createContext();
        ContextValueNode context = controller.getContext();
        context.setSingleton(true);
        context.setSelection(CardinalityEnum._1_1);
        context.setCardinality(CardinalityEnum._1_1);
        return controller;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createControllerImplementation(Controller controller, ProgressMonitorDialog givenDialog) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ProgressMonitorDialog dialog = null;
        if (givenDialog == null) {
            dialog = new ProgressMonitorDialog(shell);
            dialog.open();
        } else {
            dialog = givenDialog;
        }
        try {
            dialog.getProgressMonitor().setTaskName(mTextPool.getText(30));
            ImplementationService implementationService = new ImplementationService(controller);
            implementationService.generateImplementation(dialog.getProgressMonitor());
            Object var6_5 = null;
            if (givenDialog != null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (givenDialog != null) throw throwable;
            dialog.close();
            throw throwable;
        }
        dialog.close();
    }

    public static void getRepositoryObjectsOfUsingControllers(Controller usedController, MMRepositoryObjectList list) {
        Controller[] controllers = ControllerService.getAllUsingControllersWithinItsComponent(usedController);
        int i = 0;
        while (i < controllers.length) {
            MMRepositoryObject repositoryObject = MMRepositoryObjectProvider.getRepositoryObject((Controller)controllers[i], (boolean)false);
            if (repositoryObject != null) {
                list.addRepositoryObject(repositoryObject);
            }
            ++i;
        }
    }

    public static void deleteController(Controller controller) {
        DevelopmentObject parent;
        IEditorPart editor = EditorService.findDevelopmentObjectEditor((DevelopmentObject)controller);
        if (editor != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editor, false);
        }
        if ((parent = controller.getParent()) instanceof ComponentInterface) {
            parent = parent.getParent();
        }
        if (parent instanceof Component) {
            ControllerService.removeAllReferences(controller);
        }
        DeletionService deletionService = new DeletionService(ServicesEclipse.getEclipseProject((DevelopmentObject)controller));
        deletionService.deleteController(controller, true);
        try {
            controller.delete();
        }
        catch (DeleteException e) {
            ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$controller$ControllerService == null ? (class$com$sap$ide$webdynpro$service$controllereditor$controller$ControllerService = ControllerService.class$("com.sap.ide.webdynpro.service.controllereditor.controller.ControllerService")) : class$com$sap$ide$webdynpro$service$controllereditor$controller$ControllerService, "deleteController(Controller)", e.getMessage(), e, false);
            return;
        }
    }

    private static void removeAllReferences(Controller controller) {
        Controller[] usingControllers = ControllerService.getAllUsingControllersWithinItsComponent(controller);
        int i = 0;
        while (i < usingControllers.length) {
            ControllerUsage[] outgoingUsages = usingControllers[i].getOutgoingControllerUsages();
            int j = 0;
            while (j < outgoingUsages.length) {
                if (outgoingUsages[j] != null && outgoingUsages[j].getUsedController() != null && outgoingUsages[j].getUsedController().equals(controller) && !usingControllers[i].isReadOnly()) {
                    try {
                        outgoingUsages[j].delete();
                    }
                    catch (DeleteException e) {
                        ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$controller$ControllerService == null ? ControllerService.class$("com.sap.ide.webdynpro.service.controllereditor.controller.ControllerService") : class$com$sap$ide$webdynpro$service$controllereditor$controller$ControllerService, "removeAllReferences(Controller)", e.getMessage(), e, false);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static Image getIcon(Controller controller) {
        if (controller == null) {
            return null;
        }
        if (controller.getType().equals(ControllerTypeEnum.COMPONENT)) {
            return SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_COMPONENT_CONTROLLER);
        }
        if (controller.getType().equals(ControllerTypeEnum.COMPONENT_INTERFACE)) {
            return SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_COMPONENT_INTERFACE_CONTROLLER);
        }
        if (controller.getType().equals(ControllerTypeEnum.COMPONENT_CONFIGURATION)) {
            return SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_COMPONENT_CONFIGURATION_CONTROLLER);
        }
        if (controller.getType().equals(ControllerTypeEnum.INTERFACE_VIEW)) {
            return SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_INTERFACE_VIEW_CONTROLLER);
        }
        if (controller.getType().equals(ControllerTypeEnum.VIEW)) {
            return SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_VIEW_CONTROLLER);
        }
        if (controller.getType().equals(ControllerTypeEnum.CUSTOM)) {
            return SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_CUSTOM_CONTROLLER);
        }
        return null;
    }

    public static String getText(Controller controller) {
        if (controller == null) {
            return "";
        }
        if (controller.getType().equals(ControllerTypeEnum.COMPONENT)) {
            return mCoreTextPool.getText(102);
        }
        if (controller.getType().equals(ControllerTypeEnum.COMPONENT_INTERFACE)) {
            return mCoreTextPool.getText(122);
        }
        if (controller.getType().equals(ControllerTypeEnum.COMPONENT_CONFIGURATION)) {
            return mCoreTextPool.getText(124);
        }
        if (controller.getType().equals(ControllerTypeEnum.INTERFACE_VIEW)) {
            return mCoreTextPool.getText(125);
        }
        if (controller.getType().equals(ControllerTypeEnum.VIEW)) {
            return mCoreTextPool.getText(103);
        }
        if (controller.getType().equals(ControllerTypeEnum.CUSTOM)) {
            return mCoreTextPool.getText(101);
        }
        return "";
    }

    public static Controller[] getAllUsingControllers(ComponentUsage componentUsage) {
        if (componentUsage == null) {
            return new Controller[0];
        }
        ArrayList<Controller> list = new ArrayList<Controller>();
        Controller[] controllers = componentUsage.getUsingComponent().getControllers();
        int i = 0;
        while (i < controllers.length) {
            if (ControllerService.hasReference(controllers[i], componentUsage)) {
                list.add(controllers[i]);
            }
            ++i;
        }
        ComponentInterfaceImplementation componentInterface = componentUsage.getUsingComponent().getComponentInterface();
        if (ControllerService.hasReference(componentInterface.getInterfaceController(), componentUsage)) {
            list.add(componentInterface.getInterfaceController());
        }
        if (ControllerService.hasReference(componentInterface.getConfigurationController(), componentUsage)) {
            list.add(componentInterface.getConfigurationController());
        }
        controllers = componentInterface.getControllers();
        int i2 = 0;
        while (i2 < controllers.length) {
            if (ControllerService.hasReference(controllers[i2], componentUsage)) {
                list.add(controllers[i2]);
            }
            ++i2;
        }
        controllers = new Controller[list.size()];
        controllers = list.toArray(controllers);
        return controllers;
    }

    public static Controller[] getAllUsingControllersWithinItsComponent(Controller controller) {
        DevelopmentObject object = controller.getParent();
        while (!(object instanceof Component)) {
            if (object != null) {
                object = object.getParent();
                continue;
            }
            return new Controller[0];
        }
        Component component = (Component)object;
        return ControllerService.getAllUsingControllers(controller, component);
    }

    public static Controller[] getAllUsingControllers(Controller controller, Component component) {
        if (!component.isValid()) {
            return new Controller[0];
        }
        ArrayList<Controller> list = new ArrayList<Controller>();
        Controller[] controllers = component.getControllers();
        int i = 0;
        while (i < controllers.length) {
            if (ControllerService.hasReference(controllers[i], controller)) {
                list.add(controllers[i]);
            }
            ++i;
        }
        ComponentInterfaceImplementation componentInterface = component.getComponentInterface();
        if (ControllerService.hasReference(componentInterface.getInterfaceController(), controller)) {
            list.add(componentInterface.getInterfaceController());
        }
        if (ControllerService.hasReference(componentInterface.getConfigurationController(), controller)) {
            list.add(componentInterface.getConfigurationController());
        }
        controllers = componentInterface.getControllers();
        int i2 = 0;
        while (i2 < controllers.length) {
            if (ControllerService.hasReference(controllers[i2], controller)) {
                list.add(controllers[i2]);
            }
            ++i2;
        }
        controllers = new Controller[list.size()];
        controllers = list.toArray(controllers);
        return controllers;
    }

    public static boolean hasReference(Controller using, Controller used) {
        if (used == null || using == null) {
            return false;
        }
        ControllerUsage[] usages = using.getOutgoingControllerUsages();
        int i = 0;
        while (i < usages.length) {
            if (used.equals(usages[i].getUsedController())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasReference(Controller using, ComponentUsage componentUsage) {
        if (componentUsage == null || using == null) {
            return false;
        }
        ControllerUsage[] usages = using.getOutgoingControllerUsages();
        int i = 0;
        while (i < usages.length) {
            if (componentUsage.equals(usages[i].getComponentUsage())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IFile getImplementationFile(Controller controller) {
        NamingService namingService = new NamingService(ServicesEclipse.getEclipseProject((DevelopmentObject)controller).getLocation().toFile().getAbsolutePath() + GenerationEclipse.getGenerationOutputPathInfix());
        Path path = new Path(namingService.getControllerEditableNaming(controller).getAbsoluteFilePath());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        return file;
    }

    public static boolean doesAnyControllerExist(Component component, String name) {
        if (component != null) {
            Controller[] controllers = component.getControllers();
            int j = 0;
            while (j < controllers.length) {
                if (controllers[j].getName().equals(name)) {
                    return true;
                }
                ++j;
            }
            ComponentInterfaceImplementation cii = component.getComponentInterface();
            controllers = cii.getControllers();
            int j2 = 0;
            while (j2 < controllers.length) {
                if (controllers[j2].getName().equals(name)) {
                    return true;
                }
                ++j2;
            }
        }
        return false;
    }

    public static boolean doesAnyControllerExist(ComponentInterfaceDefinition cid, String name) {
        if (cid != null) {
            Controller[] controllers = cid.getControllers();
            int j = 0;
            while (j < controllers.length) {
                if (controllers[j].getName().equals(name)) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

