/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.controller;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.controller.AbstractContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.metamodel.webdynpro.plugin.WebDynproRootManager;
import com.sap.ide.metamodel.webdynpro.services.ServicesEclipse;
import com.sap.ide.webdynpro.service.controllereditor.NamingService;
import com.sap.ide.webdynpro.service.controllereditor.ServiceControllerEditorPlugin;
import com.sap.ide.webdynpro.service.controllereditor.ServiceWithUI;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.controller.WDCopyControllerDialog;
import com.sap.ide.webdynpro.service.controllereditor.implementation.AmbiguousImportsException;
import com.sap.ide.webdynpro.service.controllereditor.implementation.ImplementationService;
import com.sap.ide.webdynpro.service.core.paste.IPasteHandler;
import com.sap.ide.webdynpro.service.core.paste.IPasteManager;
import com.sap.ide.webdynpro.service.core.paste.MDOPasteMapper;
import com.sap.ide.webdynpro.service.core.paste.OriginalObjectNotExistingException;
import com.sap.ide.webdynpro.service.core.paste.PasteHandlerException;
import com.sap.ide.webdynpro.service.core.paste.WebDynproObjectPasteHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public class ControllerPasteHandler
extends WebDynproObjectPasteHandler {
    private MDOPasteMapper mMapper;
    private boolean mAreUsagesExcluded = false;
    private Controller[] mTargetControllers;

    public MainDevelopmentObject[] getAffectedMDOs(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        if (newParent instanceof Component) {
            return new MainDevelopmentObject[]{(Component)newParent};
        }
        return super.getAffectedMDOs(clipboardObjects, newParent, scope, pasteManager);
    }

    public boolean refactorBeforeExecution(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) throws PasteHandlerException {
        if (clipboardObjects != null && clipboardObjects.length == 1 && clipboardObjects[0].getType() == WebDynproDevelopmentObjectEnum.CONTROLLER) {
            ClipboardObject controllerObject = clipboardObjects[0];
            DevelopmentObject originalObject = pasteManager.getClipboard().getSourceMetamodel().getObjectFromKey(controllerObject.getOriginalKey());
            if (originalObject == null) {
                throw new OriginalObjectNotExistingException(controllerObject);
            }
            Controller controller = (Controller)originalObject;
            if (controller == null) {
                return false;
            }
            String newName = null;
            String newPackage = null;
            IPackageFragmentRoot newRoot = null;
            if (controller.getType() == ControllerTypeEnum.CUSTOM) {
                WDCopyControllerDialog dialog;
                Component component = (Component)controller.getParent().getMDO();
                String packageName = this.getPreselectedPackage(controllerObject, newParent);
                SourcePathIdentifier identifier = pasteManager.getSourcePathIdentifier();
                IPackageFragmentRoot preselectedSourceRoot = this.getPreselectedSourceRoot(identifier, newParent);
                IPackageFragmentRoot[] allRoots = this.getSourceRootsForTarget(newParent);
                ClipboardObject[] clipboardObjectHistory = pasteManager.getClipboardObjectsHistory();
                Component mdo = null;
                if (newParent instanceof Component) {
                    mdo = (Component)newParent;
                }
                if ((dialog = ServiceWithUI.displayCopyControllerDialog(allRoots, preselectedSourceRoot, this.getNewMetamodel(newParent), mdo, controllerObject.getNewName(), packageName, clipboardObjectHistory, this.isSourceRootListEnabled(identifier, newParent))) == null) {
                    return false;
                }
                newName = dialog.getName();
                newPackage = dialog.getPackage();
                newRoot = dialog.getSourceRoot();
                controllerObject.setNewName(newName);
                controllerObject.setNewPackage(newPackage);
                if (newRoot != null) {
                    this.setPasteProcessSourcePathIdentifier(pasteManager, newRoot, newParent);
                }
                this.storeMapping(controllerObject, newName, newPackage, newRoot, pasteManager);
            } else if (controller.getType() != ControllerTypeEnum.COMPONENT) {
                ClipboardObject compInterfaceObject;
                if (controller.getType() == ControllerTypeEnum.COMPONENT_INTERFACE) {
                    compInterfaceObject = controllerObject.getParent();
                    newName = NamingService.getComponentInterfaceControllerName(compInterfaceObject.getNewName());
                    newPackage = compInterfaceObject.getNewPackage();
                    newRoot = ServicesEclipse.getMDOSourceRoot((MainDevelopmentObject)controller);
                    controllerObject.setNewName(newName);
                    controllerObject.setNewPackage(newPackage);
                    this.storeMapping(controllerObject, newName, newPackage, newRoot, pasteManager);
                } else if (controller.getType() == ControllerTypeEnum.COMPONENT_CONFIGURATION) {
                    compInterfaceObject = controllerObject.getParent();
                    newName = NamingService.getComponentConfigurationControllerName(compInterfaceObject.getNewName());
                    newPackage = compInterfaceObject.getNewPackage();
                    newRoot = ServicesEclipse.getMDOSourceRoot((MainDevelopmentObject)controller);
                    controllerObject.setNewName(newName);
                    controllerObject.setNewPackage(newPackage);
                    this.storeMapping(controllerObject, newName, newPackage, newRoot, pasteManager);
                } else if (controller.getType() == ControllerTypeEnum.INTERFACE_VIEW || controller.getType() == ControllerTypeEnum.VIEW) {
                    // empty if block
                }
            }
            if (!this.mAreUsagesExcluded) {
                this.excludeForeignControllerUsages(newParent, pasteManager);
                this.mAreUsagesExcluded = true;
            }
            this.addToClipboardObjectsHistory(clipboardObjects, pasteManager);
            ClipboardObject[] children = controllerObject.getChildren();
            int j = 0;
            while (j < children.length) {
                IPasteHandler handler;
                ClipboardObject childObject = children[j];
                if (childObject.getType() == WebDynproDevelopmentObjectEnum.CONTEXTVALUENODE && (handler = pasteManager.getPasteHandler(childObject)) != null) {
                    boolean cancelled;
                    boolean bl = cancelled = !handler.refactorBeforeExecution(childObject.getChildren(), newParent, scope, pasteManager);
                    if (cancelled) {
                        return false;
                    }
                }
                ++j;
            }
        }
        return true;
    }

    public void refactorAfterExecution(DevelopmentObject[] newObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        if (newObjects != null && newObjects.length == 1 && newObjects[0] instanceof Controller) {
            Controller controller = (Controller)newObjects[0];
            ContextValueNode context = controller.getContext();
            ArrayList<Object> children = new ArrayList<Object>();
            AbstractContextNode[] childNodes = context.getChildNodes();
            ContextAttribute[] attributes = context.getAttributes();
            children.addAll(Arrays.asList(childNodes));
            children.addAll(Arrays.asList(attributes));
            IPasteHandler handler = pasteManager.getPasteHandler((DevelopmentObject)context);
            if (handler != null && children != null && children.size() > 0) {
                DevelopmentObject[] childrenArray = children.toArray(new DevelopmentObject[children.size()]);
                handler.refactorAfterExecution(childrenArray, newParent, scope, pasteManager);
            }
            IProgressMonitor monitor = pasteManager.getSharedMonitor();
            this.doGeneration(controller, pasteManager, monitor);
        }
    }

    private void doGeneration(Controller controller, IPasteManager pasteManager, IProgressMonitor monitor) {
        boolean ambiguousImports = false;
        ImplementationService implService = new ImplementationService(controller);
        if (this.hasImplementation(controller)) {
            pasteManager.openSharedMonitor();
            try {
                implService.organizeImports(true, monitor);
                if (this.importsMayBeAmbiguous(controller)) {
                    ambiguousImports = true;
                }
            }
            catch (AmbiguousImportsException e) {
                ambiguousImports = true;
            }
            if (ambiguousImports) {
                pasteManager.getLog().addEntry(2, TextPool.getInstance().getText(1047, controller.getName()), false);
            }
        } else {
            pasteManager.openSharedMonitor();
            implService.generateImplementation(monitor);
        }
    }

    private boolean importsMayBeAmbiguous(Controller newController) {
        Controller controller;
        return this.hasImplementation(newController) && (controller = this.findControllerMatchingName(newController.getName(), newController)) != null && !controller.getPackage().equalsIgnoreCase(newController.getPackage());
    }

    private Controller findControllerMatchingName(String name, Controller notThisOne) {
        Controller[] targetControllers = this.collectTargetControllers(notThisOne.getMetamodel());
        int i = 0;
        while (i < targetControllers.length) {
            if (!targetControllers[i].equals(notThisOne) && targetControllers[i].getName().equals(name)) {
                return targetControllers[i];
            }
            ++i;
        }
        return null;
    }

    private Controller[] collectTargetControllers(Metamodel metamodel) {
        if (this.mTargetControllers == null) {
            HashSet<Controller> controllers = new HashSet<Controller>();
            WebDynproRoot root = WebDynproRootManager.getWebDynproRoot((Metamodel)metamodel);
            try {
                Component[] comps = root.getComponents();
                int i = 0;
                while (i < comps.length) {
                    Component comp = comps[i];
                    controllers.addAll(Arrays.asList(comp.getControllers()));
                    ComponentInterfaceImplementation intf = comp.getComponentInterface();
                    controllers.addAll(Arrays.asList(intf.getControllers()));
                    ++i;
                }
                this.mTargetControllers = controllers.toArray(new Controller[controllers.size()]);
            }
            catch (LoadException e) {
                ServiceControllerEditorPlugin.internalError(((Object)((Object)this)).getClass(), "collectTargetControllers", e.getMessage(), e, false);
            }
        }
        return this.mTargetControllers;
    }

    public boolean hasImplementation(Controller controller) {
        ControllerTypeEnum type = controller.getType();
        return !(controller.getParent() instanceof ComponentInterfaceDefinition) || type != ControllerTypeEnum.COMPONENT_INTERFACE && type != ControllerTypeEnum.COMPONENT_CONFIGURATION && type != ControllerTypeEnum.INTERFACE_VIEW;
    }

    private void excludeForeignControllerUsages(MetamodelObject newParent, IPasteManager pasteManager) throws PasteHandlerException {
        HashMap availableUsedControllers = new HashMap();
        ArrayList controllersInClipboard = new ArrayList();
        ArrayList corruptUsages = new ArrayList();
        ClipboardObject[] rootObjects = pasteManager.getRootObjects();
        int i = 0;
        while (i < rootObjects.length) {
            ClipboardObject object = rootObjects[i];
            availableUsedControllers.putAll(this.findOldReferencedControllers(object, pasteManager, corruptUsages));
            ++i;
        }
        int i2 = 0;
        while (i2 < rootObjects.length) {
            ClipboardObject object = rootObjects[i2];
            controllersInClipboard.addAll(this.findControllersInClipboard(object, pasteManager));
            ++i2;
        }
        Iterator iter = availableUsedControllers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Controller controller = (Controller)entry.getKey();
            ClipboardObject usageObject = (ClipboardObject)entry.getValue();
            usageObject.setExcluded(!this.isUsedControllerReferencedByNewParent(controller, newParent) && !controllersInClipboard.contains(controller));
        }
        Iterator iter2 = corruptUsages.iterator();
        while (iter2.hasNext()) {
            ClipboardObject usage = (ClipboardObject)iter2.next();
            usage.setExcluded(true);
        }
        if (!corruptUsages.isEmpty()) {
            this.logWarningForCorruptUsages(corruptUsages, pasteManager);
        }
    }

    private List findControllersInClipboard(ClipboardObject object, IPasteManager pasteManager) throws PasteHandlerException {
        ArrayList<DevelopmentObject> result = new ArrayList<DevelopmentObject>();
        if (object.getType() == WebDynproDevelopmentObjectEnum.CONTROLLER) {
            DevelopmentObject originalObject = pasteManager.getClipboard().getSourceMetamodel().getObjectFromKey(object.getOriginalKey());
            if (originalObject == null) {
                throw new OriginalObjectNotExistingException(object);
            }
            result.add(originalObject);
        }
        ClipboardObject[] children = object.getChildren();
        int i = 0;
        while (i < children.length) {
            result.addAll(this.findControllersInClipboard(children[i], pasteManager));
            ++i;
        }
        return result;
    }

    private Map findOldReferencedControllers(ClipboardObject object, IPasteManager pasteManager, List corruptUsages) throws PasteHandlerException {
        HashMap<Controller, ClipboardObject> result = new HashMap<Controller, ClipboardObject>();
        int i = 0;
        while (i < object.getChildren().length) {
            Controller usedController;
            ControllerUsage usage;
            DevelopmentObject originalObject;
            ClipboardObject child = object.getChildren()[i];
            if (child.getType() == WebDynproDevelopmentObjectEnum.CONTROLLERUSAGE) {
                originalObject = pasteManager.getClipboard().getSourceMetamodel().getObjectFromKey(child.getOriginalKey());
                if (originalObject == null) {
                    throw new OriginalObjectNotExistingException(child);
                }
                usage = (ControllerUsage)originalObject;
                usedController = usage.getUsedController();
                if (usedController != null) {
                    result.put(usedController, child);
                } else if (!usage.hasComponentUsage()) {
                    corruptUsages.add(child);
                }
            } else if (child.getType() == WebDynproDevelopmentObjectEnum.COMPONENTCONTROLLERUSAGE) {
                originalObject = pasteManager.getClipboard().getSourceMetamodel().getObjectFromKey(child.getOriginalKey());
                if (originalObject == null) {
                    throw new OriginalObjectNotExistingException(child);
                }
                usage = (ComponentControllerUsage)originalObject;
                usedController = usage.getUsedComponentController();
                if (usedController != null) {
                    result.put(usedController, child);
                } else {
                    corruptUsages.add(child);
                }
            }
            result.putAll(this.findOldReferencedControllers(child, pasteManager, corruptUsages));
            ++i;
        }
        return result;
    }

    private boolean isUsedControllerReferencedByNewParent(Controller oldUsedController, MetamodelObject newParent) {
        Controller newUsedController = (Controller)this.convertOldToNewReference(this.getNewMetamodel(newParent), (DevelopmentObject)oldUsedController);
        if (newUsedController != null) {
            if (newParent instanceof Component) {
                Component component = (Component)newParent;
                if (Arrays.asList(component.getControllers()).contains(newUsedController)) {
                    return true;
                }
                if (Arrays.asList(component.getComponentInterface().getControllers()).contains(newUsedController)) {
                    return true;
                }
            } else if (newParent instanceof WebDynproRoot) {
                WebDynproRoot root = (WebDynproRoot)newParent;
                try {
                    ComponentInterfaceDefinition[] cids = root.getComponentInterfaceDefinitions();
                    int i = 0;
                    while (i < cids.length) {
                        if (Arrays.asList(cids[i].getControllers()).contains(newUsedController)) {
                            return true;
                        }
                        ++i;
                    }
                }
                catch (LoadException e) {
                    ServiceControllerEditorPlugin.internalError(((Object)((Object)this)).getClass(), "isUsedControllerReferencedByNewParent(Controller, MetamodelObject)", "Cannot load ComponentInterfaceDefinitions", e, false);
                }
            }
        }
        return false;
    }

    private void logWarningForCorruptUsages(List corruptUsages, IPasteManager pasteManager) {
        StringBuffer usages = new StringBuffer();
        Iterator iter = corruptUsages.iterator();
        while (iter.hasNext()) {
            ClipboardObject usageObject = (ClipboardObject)iter.next();
            usages.append(usageObject.getNewName());
            if (!iter.hasNext()) continue;
            usages.append(", ");
        }
        TextPool textPool = TextPool.getInstance();
        pasteManager.getLog().addEntry(2, textPool.getText(1046, usages), false);
    }
}

