/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.context.paste;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.exception.RefactoringException;
import com.sap.ide.metamodel.general.refactoring.RefactoringItem;
import com.sap.ide.metamodel.general.refactoring.RefactoringRequest;
import com.sap.ide.metamodel.general.refactoring.RefactoringTask;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextRecursionNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.repository.RepositoryUtilities;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.service.controllereditor.ServiceControllerEditorPlugin;
import com.sap.ide.webdynpro.service.controllereditor.context.ContextService;
import com.sap.ide.webdynpro.service.controllereditor.context.ServicesDeletion;
import com.sap.ide.webdynpro.service.controllereditor.context.paste.ContextPasteManager;
import java.util.Iterator;
import java.util.Map;

public class ServicesRefactoring {
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$controllereditor$context$paste$ServicesRefactoring;

    public static boolean isPasteAllowed(MetamodelClipboard clipboard, ContextElement newParent) {
        if (!clipboard.isPasteAllowed((MetamodelObject)newParent)) {
            return false;
        }
        Metamodel sourceMetamodel = clipboard.getSourceMetamodel();
        DevelopmentObjectKey[] contentKeys = clipboard.getContent();
        int i = 0;
        while (i < contentKeys.length) {
            DevelopmentObject object = sourceMetamodel.getObjectFromKey(contentKeys[i]);
            if (object != null) {
                if (object instanceof ContextAttribute) {
                    if (CheckLayerHelper.hasStructureBinding((ContextElement)newParent)) {
                        return false;
                    }
                    if (object instanceof ContextModelAttribute && newParent instanceof ContextValueNode && !newParent.getParent().isMDO()) {
                        return false;
                    }
                } else if (object instanceof ContextRecursionNode && newParent.getParent().isMDO()) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static void copyElement(ContextElement element) {
        MetamodelClipboard clipboard = Metamodel.getClipboard();
        clipboard.copy((DevelopmentObject)element);
    }

    public static void copyElements(ContextElement[] elements) {
        MetamodelClipboard clipboard = Metamodel.getClipboard();
        clipboard.copy((DevelopmentObject[])elements);
    }

    public static void cutElements(ContextElement[] elements, ControllerUsage[] controllerUsages) {
        ServicesRefactoring.copyElements(elements);
        int i = 0;
        while (i < elements.length) {
            ServicesDeletion.deleteElement(elements[i], controllerUsages);
            ++i;
        }
    }

    public static void pasteElementsSpecial(ContextNode newParent, MetamodelClipboard clipboard, ControllerUsage[] usages) {
        ContextPasteManager contextPasteManager = new ContextPasteManager(true, false, false, usages);
        contextPasteManager.paste(clipboard, (MetamodelObject)newParent);
    }

    public static void pasteElements(ContextNode newParent, ControllerUsage[] usages) {
        ServicesRefactoring.pasteElements(newParent, Metamodel.getClipboard(), usages, false, false);
    }

    public static void pasteElements(ContextNode newParent, MetamodelClipboard clipboard, ControllerUsage[] usages, boolean forceMerge, boolean noRepair) {
        ContextPasteManager contextPasteManager = new ContextPasteManager(false, forceMerge, noRepair, usages);
        contextPasteManager.paste(clipboard, (MetamodelObject)newParent);
    }

    public static boolean renameElements(Map elementsToRename) {
        if (elementsToRename == null || elementsToRename.isEmpty()) {
            return true;
        }
        RefactoringRequest request = null;
        Iterator iter = elementsToRename.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ContextElement element = (ContextElement)entry.getKey();
            if (request == null) {
                request = element.getRoot().getMetamodel().createRefactoringRequest();
                request.maximizeRefactoringScope();
            }
            RefactoringTask task = request.createRefactoringTask((DevelopmentObject)element);
            task.setNewName((String)entry.getValue());
            if (!task.isConflicting()) continue;
            ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$context$paste$ServicesRefactoring == null ? (class$com$sap$ide$webdynpro$service$controllereditor$context$paste$ServicesRefactoring = ServicesRefactoring.class$("com.sap.ide.webdynpro.service.controllereditor.context.paste.ServicesRefactoring")) : class$com$sap$ide$webdynpro$service$controllereditor$context$paste$ServicesRefactoring, "renameElements", "Still conflicts in Refactoring task", null, false);
            return false;
        }
        RefactoringItem[] items = request.getAffectedMDOs();
        MainDevelopmentObject[] affectedMdos = new MainDevelopmentObject[items.length];
        int i = 0;
        while (i < items.length) {
            MainDevelopmentObject mdo;
            affectedMdos[i] = mdo = items[i].getMDO();
            ++i;
        }
        if (!RepositoryUtilities.checkWriteability((MainDevelopmentObject[])affectedMdos, (boolean)false)) {
            return false;
        }
        try {
            request.execute();
        }
        catch (RefactoringException e) {
            ServiceControllerEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$controllereditor$context$paste$ServicesRefactoring == null ? (class$com$sap$ide$webdynpro$service$controllereditor$context$paste$ServicesRefactoring = ServicesRefactoring.class$("com.sap.ide.webdynpro.service.controllereditor.context.paste.ServicesRefactoring")) : class$com$sap$ide$webdynpro$service$controllereditor$context$paste$ServicesRefactoring, "renameElements", "Refactoring failed", e, false);
            return false;
        }
        return true;
    }

    public static boolean isContextElementClipboardObject(ClipboardObject object) {
        return ServicesRefactoring.isContextNodeClipboardObject(object) || ServicesRefactoring.isContextAttributeClipboardObject(object);
    }

    public static boolean isContextNodeClipboardObject(ClipboardObject object) {
        return ContextService.isContextNodeEnum(object.getType());
    }

    public static boolean isContextAttributeClipboardObject(ClipboardObject object) {
        return ContextService.isContextAttributeEnum(object.getType());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

