/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.context.paste;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.project.ProjectService;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.clipboard.PasteProcess;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.webdynpro.service.controllereditor.ServiceControllerEditorPlugin;
import com.sap.ide.webdynpro.service.controllereditor.context.paste.ServicesRefactoring;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.sap.ide.webdynpro.service.core.paste.IPasteHandler;
import com.sap.ide.webdynpro.service.core.paste.IPasteManager;
import com.sap.ide.webdynpro.service.core.paste.PasteException;
import com.sap.ide.webdynpro.service.core.paste.PasteHandlerException;
import com.sap.ide.webdynpro.service.core.paste.PasteLogDialog;
import com.sap.ide.webdynpro.service.core.paste.PasteManager;
import java.util.HashSet;
import java.util.Set;

public class ContextPasteManager
extends PasteManager {
    private MetamodelClipboard mClipboard;
    private ClipboardObject[] mRootObjects = PasteManager.EMPTY_CLIPBOARD_OBJECTS_ARRAY;
    private PasteProcess mPasteProcess;
    private boolean mShowWizard;
    private boolean mForceMerge;
    private boolean mNoRepair;
    private ControllerUsage[] mUsages;
    private Set mClipboardObjectsHistory = new HashSet();

    public ContextPasteManager(boolean showWizard, boolean forceMerge, boolean noRepair, ControllerUsage[] usages) {
        this.mShowWizard = showWizard;
        this.mForceMerge = forceMerge;
        this.mNoRepair = noRepair;
        this.mUsages = usages;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paste(MetamodelClipboard clipboard, MetamodelObject newParent) {
        block17: {
            block16: {
                block15: {
                    block14: {
                        super.paste(clipboard, newParent);
                        this.mClipboard = clipboard;
                        CoreTextPool pool = CoreTextPool.getInstance();
                        DevelopmentObject[] newObjects = new DevelopmentObject[]{};
                        HashSet affectedMDOs = new HashSet();
                        int scope = this.computeScope(clipboard, newParent);
                        if (!ServicesRefactoring.isPasteAllowed(clipboard, (ContextElement)newParent)) {
                            ServiceControllerEditorPlugin.internalError(((Object)((Object)this)).getClass(), "paste(MetamodelClipboard, MetamodelObject)", "Paste is not allowed. Operation is aborted.", null, false);
                            return;
                        }
                        if (!this.isSourceMetamodelValid(clipboard.getSourceMetamodel())) {
                            UIHelper.displayErrorMessage((String)CoreTextPool.getInstance().getText(414), (String)CoreTextPool.getInstance().getText(46));
                            return;
                        }
                        if (!ProjectService.checkMetamodelLanguage((Metamodel)this.getNewMetamodel(newParent))) {
                            UIHelper.displayErrorMessage((String)pool.getText(414), (String)pool.getText(47));
                            return;
                        }
                        this.mPasteProcess = clipboard.initiatePaste(newParent);
                        this.mRootObjects = this.mPasteProcess.getClipboardContent();
                        IPasteHandler handler = this.getPasteHandler(WebDynproDevelopmentObjectEnum.CONTEXTVALUENODE);
                        if (handler == null) {
                            return;
                        }
                        try {
                            try {
                                boolean cancelled;
                                MainDevelopmentObject[] mdos = handler.getAffectedMDOs(this.mRootObjects, newParent, scope, (IPasteManager)this);
                                if (!this.checkAffectedMDOs(affectedMDOs)) {
                                    Object var11_10 = null;
                                    break block14;
                                }
                                boolean bl = cancelled = !handler.refactorBeforeExecution(this.mRootObjects, newParent, scope, (IPasteManager)this);
                                if (cancelled) {
                                    break block15;
                                }
                                newObjects = this.pasteExecute(this.mPasteProcess);
                                if (newObjects == null) break block16;
                                if (newObjects.length == 0) {
                                    break block16;
                                }
                                handler.refactorAfterExecution(newObjects, newParent, scope, (IPasteManager)this);
                                if (!this.getLog().isEmpty()) {
                                    new PasteLogDialog(this.getLog()).open();
                                }
                                break block17;
                            }
                            catch (PasteHandlerException e) {
                                this.displayPasteException((PasteException)e);
                                Object var11_14 = null;
                                this.closeSharedMonitor();
                                return;
                            }
                            catch (Throwable t) {
                                ServiceControllerEditorPlugin.internalError(((Object)((Object)this)).getClass(), "paste(MetamodelClipboard, MetamodelObject)", "Error caused by context paste handler", t, false);
                                Object var11_15 = null;
                                this.closeSharedMonitor();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var11_16 = null;
                            this.closeSharedMonitor();
                            throw throwable;
                        }
                    }
                    this.closeSharedMonitor();
                    return;
                }
                Object var11_11 = null;
                this.closeSharedMonitor();
                return;
            }
            Object var11_12 = null;
            this.closeSharedMonitor();
            return;
        }
        Object var11_13 = null;
        this.closeSharedMonitor();
    }

    public MetamodelClipboard getClipboard() {
        return this.mClipboard;
    }

    public ClipboardObject[] getRootObjects() {
        return this.mRootObjects;
    }

    public SourcePathIdentifier getSourcePathIdentifier() {
        return this.mPasteProcess.getSourcePathIdentifier();
    }

    public void setSourcePathIdentifier(SourcePathIdentifier sourcePathIdentifier) {
        if (sourcePathIdentifier != null) {
            this.mPasteProcess.setSourcePathIdentifier(sourcePathIdentifier);
        }
    }

    public void addToClipboardObjectsHistory(ClipboardObject clipboardObject) {
        if (clipboardObject != null) {
            this.mClipboardObjectsHistory.add(clipboardObject);
        }
    }

    public ClipboardObject[] getClipboardObjectsHistory() {
        return this.mClipboardObjectsHistory.toArray(new ClipboardObject[this.mClipboardObjectsHistory.size()]);
    }

    public boolean getShowWizard() {
        return this.mShowWizard;
    }

    public boolean getForceMerge() {
        return this.mForceMerge;
    }

    public boolean getNoRepair() {
        return this.mNoRepair;
    }

    public ControllerUsage[] getUsages() {
        return this.mUsages;
    }
}

