/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.context.paste;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.controller.AbstractContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextRecursionNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.context.ContextService;
import com.sap.ide.webdynpro.service.controllereditor.context.ServicesCreation;
import com.sap.ide.webdynpro.service.controllereditor.context.ServicesDeletion;
import com.sap.ide.webdynpro.service.controllereditor.context.paste.ContextElementTypeRepairException;
import com.sap.ide.webdynpro.service.controllereditor.context.paste.ContextPasteElementMapper;
import com.sap.ide.webdynpro.service.controllereditor.context.paste.ContextPasteManager;
import com.sap.ide.webdynpro.service.controllereditor.context.paste.PasteSpecialResult;
import com.sap.ide.webdynpro.service.controllereditor.context.ui.ContextCaller;
import com.sap.ide.webdynpro.service.core.paste.IPasteManager;
import com.sap.ide.webdynpro.service.core.paste.MDOPasteManager;
import com.sap.ide.webdynpro.service.core.paste.OriginalObjectNotExistingException;
import com.sap.ide.webdynpro.service.core.paste.PasteHandlerException;
import com.sap.ide.webdynpro.service.core.paste.WebDynproObjectPasteHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContextPasteHandler
extends WebDynproObjectPasteHandler {
    private List mModelKeysByMDOOldContext = new ArrayList();
    private Set mReferencedModels = new HashSet();
    private Map mContextMappersByOldControllerKey = new Hashtable();
    private boolean mNoRepair = false;
    private static final String COPY_SEPARATOR = "_";
    private static final ControllerUsage[] EMPTY_CONTROLLER_USAGES = new ControllerUsage[0];

    public MainDevelopmentObject[] getAffectedMDOs(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        if (newParent instanceof DevelopmentObject) {
            return new MainDevelopmentObject[]{((DevelopmentObject)newParent).getMDO()};
        }
        return super.getAffectedMDOs(clipboardObjects, newParent, scope, pasteManager);
    }

    public boolean refactorBeforeExecution(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) throws PasteHandlerException {
        if (clipboardObjects.length == 0) {
            return true;
        }
        Metamodel sourceMetamodel = pasteManager.getClipboard().getSourceMetamodel();
        if (pasteManager instanceof ContextPasteManager) {
            ContextPasteManager contextPasteManager = (ContextPasteManager)pasteManager;
            this.mNoRepair = contextPasteManager.getNoRepair();
            DevelopmentObject originalObject = sourceMetamodel.getObjectFromKey(clipboardObjects[0].getOriginalKey());
            if (originalObject == null) {
                throw new OriginalObjectNotExistingException(clipboardObjects[0]);
            }
            ContextValueNode sourceContext = ((Controller)((ContextElement)originalObject).getMDO()).getContext();
            if (contextPasteManager.getShowWizard()) {
                PasteSpecialResult pasteSpecialResult = this.showRefactoringWizard(clipboardObjects, (ContextNode)newParent, scope, contextPasteManager);
                if (pasteSpecialResult.isCancelled()) {
                    return false;
                }
                this.mContextMappersByOldControllerKey.put(sourceContext.getMDO().getKey(), pasteSpecialResult.getElementMapper());
            } else {
                ContextPasteElementMapper mapper = new ContextPasteElementMapper(sourceContext.getKey(), sourceMetamodel);
                this.mContextMappersByOldControllerKey.put(sourceContext.getMDO().getKey(), mapper);
                int i = 0;
                while (i < clipboardObjects.length) {
                    this.refactorSimple(clipboardObjects[i], originalObject, (ContextNode)newParent, null, contextPasteManager.getForceMerge(), sourceMetamodel, mapper);
                    ++i;
                }
            }
        } else if (pasteManager instanceof MDOPasteManager) {
            DevelopmentObject sourceContext = sourceMetamodel.getObjectFromKey(clipboardObjects[0].getParent().getOriginalKey());
            if (sourceContext == null) {
                throw new OriginalObjectNotExistingException(clipboardObjects[0]);
            }
            ContextPasteElementMapper mapper = new ContextPasteElementMapper(sourceContext.getKey(), sourceMetamodel);
            this.mContextMappersByOldControllerKey.put(sourceContext.getMDO().getKey(), mapper);
            Iterator iter = clipboardObjects[0].getParent().iterator();
            while (iter.hasNext()) {
                ClipboardObject object = (ClipboardObject)iter.next();
                if (object.getType() != WebDynproDevelopmentObjectEnum.CONTEXTVALUENODE && object.getType() != WebDynproDevelopmentObjectEnum.CONTEXTVALUENODE && object.getType() != WebDynproDevelopmentObjectEnum.CONTEXTVALUEATTRIBUTE && object.getType() != WebDynproDevelopmentObjectEnum.CONTEXTMODELNODE && object.getType() != WebDynproDevelopmentObjectEnum.CONTEXTMODELATTRIBUTE && object.getType() != WebDynproDevelopmentObjectEnum.CONTEXTRECURSIONNODE) continue;
                String name = object.getNewName();
                mapper.storeNameMapping(name, name);
            }
        }
        this.addToClipboardObjectsHistory(clipboardObjects, pasteManager, true, true);
        return true;
    }

    public void refactorAfterExecution(DevelopmentObject[] newObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        if (newObjects.length == 0 || !(newObjects[0] instanceof ContextElement)) {
            return;
        }
        ArrayList failedTypeRepairs = new ArrayList();
        if (!this.mNoRepair) {
            int i = 0;
            while (i < newObjects.length) {
                if (newObjects[i] instanceof ContextElement) {
                    ContextElement element = (ContextElement)newObjects[i];
                    this.repairContextElement(element, newParent, pasteManager, failedTypeRepairs);
                }
                ++i;
            }
        }
        this.addUsedModelsToComponent(newObjects, newParent, scope, pasteManager);
        if (!failedTypeRepairs.isEmpty()) {
            TextPool textPool = TextPool.getInstance();
            pasteManager.getLog().addEntry(2, textPool.getText(2022), false);
        }
    }

    private void addUsedModelsToComponent(DevelopmentObject[] newObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        Component component = null;
        DevelopmentObject componentRoot = ((ContextElement)newObjects[0]).getMDO().getParent();
        if (!(componentRoot instanceof Component)) {
            return;
        }
        component = (Component)componentRoot;
        ClipboardObject[] rootObjects = pasteManager.getRootObjects();
        if (rootObjects.length > 0 && rootObjects[0].getType() == WebDynproDevelopmentObjectEnum.COMPONENT) {
            return;
        }
        if (scope == 3 || scope == 2) {
            int i = 0;
            while (i < newObjects.length) {
                if (newObjects[i] instanceof ContextElement) {
                    ContextElement element = (ContextElement)newObjects[i];
                    this.mReferencedModels.addAll(this.findReferencedModels(element, pasteManager, newParent));
                }
                ++i;
            }
            Iterator iter = this.mReferencedModels.iterator();
            while (iter.hasNext()) {
                Model model = (Model)iter.next();
                if (component.hasUsedModel(model)) continue;
                component.addUsedModel(model);
            }
        }
    }

    private Set findReferencedModels(ContextElement element, IPasteManager pasteManager, MetamodelObject newParent) {
        HashSet<Model> foundModels = new HashSet<Model>();
        if (element instanceof ContextModelNode) {
            ContextModelNode modelNode = (ContextModelNode)element;
            if (!CheckLayerHelper.hasValidMapping((ContextElement)modelNode, (ControllerUsage[])CheckLayerHelper.getOutgoingControllerUsages((ContextElement)modelNode))) {
                ContextModelNode oldNode;
                ModelClass modelClass = CheckLayerHelper.getModelClass((ContextModelNode)modelNode, (boolean)true);
                if (modelClass == null && this.getContextMapper(element, pasteManager) != null && (oldNode = (ContextModelNode)this.getContextMapper(element, pasteManager).getOldElement((ContextElement)modelNode)) != null) {
                    modelClass = CheckLayerHelper.getModelClass((ContextModelNode)oldNode);
                }
                if (modelClass != null) {
                    Model oldModel = modelClass.getModel();
                    Model newModel = (Model)this.convertOldToNewReference(this.getNewMetamodel(newParent), (DevelopmentObject)oldModel);
                    if (newModel != null) {
                        foundModels.add(newModel);
                    }
                }
            }
            AbstractContextNode[] childNodes = modelNode.getChildNodes();
            int i = 0;
            while (i < childNodes.length) {
                AbstractContextNode childNode = childNodes[i];
                foundModels.addAll(this.findReferencedModels((ContextElement)childNode, pasteManager, newParent));
                ++i;
            }
        }
        return foundModels;
    }

    private PasteSpecialResult showRefactoringWizard(ClipboardObject[] clipboardObjects, ContextNode newParent, int scope, ContextPasteManager pasteManager) {
        return ContextCaller.showRefactoringWizard(pasteManager.getClipboard(), clipboardObjects, newParent, pasteManager.getUsages());
    }

    private void refactorSimple(ClipboardObject clipboardObject, DevelopmentObject originalObject, ContextNode newParent, ClipboardObject directParent, boolean excludeConflictingElements, Metamodel sourceMetamodel, ContextPasteElementMapper mapper) throws PasteHandlerException {
        DevelopmentObjectEnum type = clipboardObject.getType();
        if (type == WebDynproDevelopmentObjectEnum.CONTEXTMODELNODE || type == WebDynproDevelopmentObjectEnum.CONTEXTVALUENODE || type == WebDynproDevelopmentObjectEnum.CONTEXTRECURSIONNODE) {
            if (excludeConflictingElements) {
                if (ContextService.isUniqueNodeWithinContext(clipboardObject.getNewName(), newParent) != null) {
                    clipboardObject.setExcluded(true);
                } else {
                    mapper.storeNameMapping(clipboardObject.getNewName(), clipboardObject.getNewName());
                }
            } else {
                StringBuffer name = new StringBuffer(clipboardObject.getNewName());
                int counter = 0;
                while (ContextService.isUniqueNodeWithinContext(name.toString(), newParent) != null) {
                    name = new StringBuffer(clipboardObject.getNewName());
                    name.append(COPY_SEPARATOR);
                    name.append(++counter);
                }
                mapper.storeNameMapping(name.toString(), clipboardObject.getNewName());
                clipboardObject.setNewName(name.toString());
            }
            ClipboardObject[] children = clipboardObject.getChildren();
            int i = 0;
            while (i < children.length) {
                DevelopmentObjectEnum childType = children[i].getType();
                if (type == WebDynproDevelopmentObjectEnum.CONTEXTMODELNODE || type == WebDynproDevelopmentObjectEnum.CONTEXTVALUENODE || type == WebDynproDevelopmentObjectEnum.CONTEXTRECURSIONNODE) {
                    DevelopmentObject originalChildObject = sourceMetamodel.getObjectFromKey(children[i].getOriginalKey());
                    if (originalChildObject == null) {
                        throw new OriginalObjectNotExistingException(children[i]);
                    }
                    this.refactorSimple(children[i], originalChildObject, newParent, clipboardObject, excludeConflictingElements, sourceMetamodel, mapper);
                }
                ++i;
            }
        } else if (type == WebDynproDevelopmentObjectEnum.CONTEXTMODELATTRIBUTE || type == WebDynproDevelopmentObjectEnum.CONTEXTVALUEATTRIBUTE) {
            if (excludeConflictingElements) {
                if (directParent == null) {
                    if (newParent.hasAttribute(clipboardObject.getNewName())) {
                        clipboardObject.setExcluded(true);
                    } else {
                        mapper.storeNameMapping(clipboardObject.getNewName(), clipboardObject.getNewName());
                    }
                }
            } else {
                StringBuffer name = new StringBuffer(clipboardObject.getNewName());
                int counter = 0;
                if (directParent == null) {
                    while (newParent.hasAttribute(name.toString())) {
                        name = new StringBuffer(clipboardObject.getNewName());
                        name.append(COPY_SEPARATOR);
                        name.append(++counter);
                    }
                    if (originalObject.getParent() != null) {
                        String oldParentNodesName = originalObject.getParent().getName();
                        mapper.storeNameMapping(newParent.getName(), oldParentNodesName);
                    }
                }
                mapper.storeNameMapping(name.toString(), clipboardObject.getNewName());
                clipboardObject.setNewName(name.toString());
            }
        }
    }

    private void repairContextElement(ContextElement newElement, MetamodelObject newParent, IPasteManager pasteManager, List failedTypeRepairs) {
        try {
            this.repairContextElement(newElement, newParent, pasteManager);
        }
        catch (ContextElementTypeRepairException e) {
            failedTypeRepairs.add(newElement);
        }
        if (newElement instanceof ContextNode) {
            ContextNode node = (ContextNode)newElement;
            ContextAttribute[] atts = node.getAttributes();
            int i = 0;
            while (i < atts.length) {
                this.repairContextElement((ContextElement)atts[i], newParent, pasteManager, failedTypeRepairs);
                ++i;
            }
            AbstractContextNode[] nodes = node.getChildNodes();
            int i2 = 0;
            while (i2 < nodes.length) {
                this.repairContextElement((ContextElement)nodes[i2], newParent, pasteManager, failedTypeRepairs);
                ++i2;
            }
        }
    }

    private void repairContextElement(ContextElement newElement, MetamodelObject newParent, IPasteManager pasteManager) throws ContextElementTypeRepairException {
        boolean typeRepairFailed = false;
        ContextPasteElementMapper mapper = this.getContextMapper(newElement, pasteManager);
        try {
            this.repairTypeAndModelReference(newElement, mapper);
        }
        catch (OriginalObjectNotExistingException e) {
            typeRepairFailed = true;
        }
        if (newElement instanceof ContextNode) {
            ContextNode newNode = (ContextNode)newElement;
            this.repairSelectionAndCardinalityAndInitializeLeadSelection(newNode, mapper);
            this.repairSingleton(newNode, mapper);
            if (newElement instanceof ContextModelNode) {
                this.repairSupplyingRelationRole((ContextModelNode)newElement);
            }
        } else if (newElement instanceof ContextRecursionNode) {
            this.repairContextRecursionNode((ContextRecursionNode)newElement);
        } else if (newElement instanceof ContextAttribute && newElement instanceof ContextValueAttribute) {
            ContextValueAttribute valAtt = (ContextValueAttribute)newElement;
            this.repairStructureElement(valAtt);
            this.repairCalculatedAttribute(valAtt, mapper);
        }
        if (newParent instanceof ContextNode) {
            this.repairInputElement(newElement, (ContextNode)newParent);
        }
        if (typeRepairFailed) {
            throw new ContextElementTypeRepairException(newElement);
        }
    }

    private void repairSupplyingRelationRole(ContextModelNode newNode) {
        if (newNode.hasSupplyingRelationRole() && !CheckLayerHelper.isValidSupplyingRelationRole((ContextModelNode)newNode, (ModelRelationRole)newNode.getSupplyingRelationRole())) {
            newNode.setSupplyingRelationRole(null);
        }
    }

    private void repairSingleton(ContextNode newNode, ContextPasteElementMapper mapper) {
        ContextNode oldNode;
        if (mapper != null && (oldNode = (ContextNode)mapper.getOldElement((ContextElement)newNode)) != null) {
            newNode.setSingleton(CheckLayerHelper.getSingleton((ContextNode)oldNode));
        }
        if (!CheckLayerHelper.isValidSingletonValue((ContextNode)newNode)) {
            newNode.setSingleton(!CheckLayerHelper.getSingleton((ContextNode)newNode));
        }
    }

    private void repairContextRecursionNode(ContextRecursionNode newElement) {
        if (newElement.hasRepeatedNode() && CheckLayerHelper.isValidRepeatedNode((ContextElement)newElement.getRepeatedNode(), (ContextRecursionNode)newElement) != null) {
            newElement.setRepeatedNode(null);
        }
    }

    private void repairStructureElement(ContextValueAttribute newAttribute) {
        if (!CheckLayerHelper.hasValidStructureElement((ContextValueAttribute)newAttribute, (boolean)true)) {
            ServicesDeletion.deleteStructureBinding(newAttribute);
        }
    }

    private void repairCalculatedAttribute(ContextValueAttribute attribute, ContextPasteElementMapper mapper) {
        ContextValueAttribute oldAtt;
        if (mapper != null && (oldAtt = (ContextValueAttribute)mapper.getOldElement((ContextElement)attribute)) != null && oldAtt.hasCalculatedAttributeProvider()) {
            ServicesCreation.createCalculatedAttributeProvider(attribute);
        }
    }

    private void repairSelectionAndCardinalityAndInitializeLeadSelection(ContextNode newNode, ContextPasteElementMapper mapper) {
        ContextElement oldElement;
        if (mapper != null && (oldElement = mapper.getOldElement((ContextElement)newNode)) instanceof ContextNode) {
            newNode.setSelection(CheckLayerHelper.getSelectionCardinality((ContextNode)((ContextNode)oldElement)));
            newNode.setCardinality(CheckLayerHelper.getCardinality((ContextNode)((ContextNode)oldElement)));
            newNode.setInitializeLeadSelection(CheckLayerHelper.getInititializeLeadSelection((ContextNode)((ContextNode)oldElement)));
        }
    }

    private void repairInputElement(ContextElement newElement, ContextNode newParent) {
        Controller newController = (Controller)newElement.getMDO();
        if (newController.getType() == ControllerTypeEnum.COMPONENT_INTERFACE || newController.getType() == ControllerTypeEnum.COMPONENT_CONFIGURATION) {
            if (newElement instanceof ContextAttribute) {
                if (newElement.getParent().getParent().isMDO()) {
                    newElement.setIsInputElement(false);
                } else {
                    ContextNode parentNode = (ContextNode)newElement.getParent();
                    if (parentNode == newParent) {
                        newElement.setIsInputElement(newParent.getIsInputElement());
                    }
                }
            }
        } else {
            newElement.setIsInputElement(false);
        }
    }

    private void repairTypeAndModelReference(ContextElement newElement, ContextPasteElementMapper mapper) throws OriginalObjectNotExistingException {
        ContextModelAttribute newModelAttribute;
        Metamodel newMetamodel = newElement.getMetamodel();
        if (newElement instanceof ContextValueAttribute) {
            ContextValueAttribute newAttr = (ContextValueAttribute)newElement;
            if (!CheckLayerHelper.hasType((ContextAttribute)newAttr)) {
                DtField oldStructureElement;
                DevelopmentObject newStructureElement;
                if (mapper == null) {
                    throw new OriginalObjectNotExistingException((DevelopmentObject)newElement);
                }
                ContextElement oldElement = mapper.getOldElement(newElement);
                if (oldElement == null) {
                    throw new OriginalObjectNotExistingException((DevelopmentObject)newElement);
                }
                ContextValueAttribute oldAttr = (ContextValueAttribute)oldElement;
                ControllerUsage[] oldUsages = CheckLayerHelper.getOutgoingControllerUsages((ContextElement)oldAttr);
                DtStructure newStructure = CheckLayerHelper.getStructure((ContextNode)((ContextNode)newElement.getParent()));
                if (CheckLayerHelper.hasStructureBinding((ContextElement)oldAttr) && newStructure != null && (newStructureElement = this.convertOldToNewReference(newMetamodel, (DevelopmentObject)(oldStructureElement = CheckLayerHelper.getStructureElement((ContextAttribute)oldAttr)))) != null && newStructure.hasStructureElement(newStructureElement.getName())) {
                    newAttr.setStructureElement(newStructureElement);
                }
                if (!CheckLayerHelper.hasStructureBinding((ContextElement)newAttr)) {
                    DevelopmentObject oldType = CheckLayerHelper.getType((ContextAttribute)oldAttr);
                    DevelopmentObject newType = this.convertOldToNewReference(newMetamodel, oldType);
                    ContextService.setType(newAttr, newType);
                }
            }
        } else if (newElement instanceof ContextValueNode) {
            ContextValueNode newNode = (ContextValueNode)newElement;
            if (!CheckLayerHelper.hasStructureBinding((ContextElement)newNode)) {
                if (mapper == null) {
                    throw new OriginalObjectNotExistingException((DevelopmentObject)newElement);
                }
                ContextValueNode oldNode = (ContextValueNode)mapper.getOldElement(newElement);
                ControllerUsage[] oldUsages = CheckLayerHelper.getOutgoingControllerUsages((ContextElement)oldNode);
                DtStructure oldStructure = null;
                oldStructure = CheckLayerHelper.getStructure((ContextNode)oldNode);
                DevelopmentObject newStructure = this.convertOldToNewReference(newMetamodel, (DevelopmentObject)oldStructure);
                newNode.setStructure(newStructure);
            }
        } else if (newElement instanceof ContextModelNode) {
            ContextModelNode newModelNode = (ContextModelNode)newElement;
            if (CheckLayerHelper.getModelClass((ContextModelNode)newModelNode) == null) {
                if (mapper == null) {
                    throw new OriginalObjectNotExistingException((DevelopmentObject)newElement);
                }
                ContextElement oldElement = mapper.getOldElement(newElement);
                if (oldElement == null) {
                    throw new OriginalObjectNotExistingException((DevelopmentObject)newElement);
                }
                ContextModelNode oldModelNode = (ContextModelNode)oldElement;
                ModelClass oldModelClass = CheckLayerHelper.getModelClass((ContextModelNode)oldModelNode);
                ModelClass newModelClass = (ModelClass)this.convertOldToNewReference(newMetamodel, (DevelopmentObject)oldModelClass);
                newModelNode.setModelClass(newModelClass);
                ModelRelationRole oldSupplRelationRole = CheckLayerHelper.getSupplyingRelationRole((ContextModelNode)oldModelNode);
                ModelRelationRole newRole = (ModelRelationRole)this.convertOldToNewReference(newMetamodel, (DevelopmentObject)oldSupplRelationRole);
                newModelNode.setSupplyingRelationRole(newRole);
            }
        } else if (newElement instanceof ContextModelAttribute && CheckLayerHelper.getReferencedProperty((ContextModelAttribute)(newModelAttribute = (ContextModelAttribute)newElement)) == null) {
            if (mapper == null) {
                throw new OriginalObjectNotExistingException((DevelopmentObject)newElement);
            }
            ContextElement oldElement = mapper.getOldElement(newElement);
            if (oldElement == null) {
                throw new OriginalObjectNotExistingException((DevelopmentObject)newElement);
            }
            ContextModelAttribute oldModelAttribute = (ContextModelAttribute)oldElement;
            ModelClassProperty oldModelProperty = CheckLayerHelper.getReferencedProperty((ContextModelAttribute)oldModelAttribute);
            ModelClassProperty newProperty = (ModelClassProperty)this.convertOldToNewReference(newMetamodel, (DevelopmentObject)oldModelProperty);
            newModelAttribute.setReferencedProperty((Property)newProperty);
        }
    }

    private ContextPasteElementMapper getContextMapper(ContextElement newElement, IPasteManager manager) {
        if (manager instanceof MDOPasteManager) {
            MDOPasteManager mdoPasteManager = (MDOPasteManager)manager;
            Controller oldController = (Controller)mdoPasteManager.getOldMDO(newElement.getMDO());
            if (oldController != null && this.mContextMappersByOldControllerKey.containsKey(oldController.getKey())) {
                return (ContextPasteElementMapper)this.mContextMappersByOldControllerKey.get(oldController.getKey());
            }
        } else if (manager instanceof ContextPasteManager) {
            Iterator iter = this.mContextMappersByOldControllerKey.entrySet().iterator();
            if (iter.hasNext()) {
                Map.Entry entry = iter.next();
                return (ContextPasteElementMapper)entry.getValue();
            }
        } else {
            throw new IllegalArgumentException("Unknown paste manager: " + manager);
        }
        return null;
    }
}

