/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.context;

import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.component.controller.AbstractContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElementMapping;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextRecursionNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.context.paste.ServicesRefactoring;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.ui.dialogs.ISelectionValidator;

public class ContextService {
    public static ISelectionValidator FILTER_CONTEXT_ATTRIBUTES = new FilterContextAttributes();
    public static ISelectionValidator FILTER_CONTEXT_NODES = new FilterContextNodes();

    public static String getContextElementPath(ContextElement contextElement) {
        StringBuffer buffer = new StringBuffer();
        ContextService.createContextElementPath((DevelopmentObject)contextElement, null, buffer, true);
        return buffer.toString();
    }

    public static String getRelativeContextElementPath(ContextElement contextElement) {
        StringBuffer buffer = new StringBuffer();
        ContextService.createContextElementPath((DevelopmentObject)contextElement, null, buffer, false);
        return buffer.toString();
    }

    public static String getAbsoluteContextElementPath(ContextElement contextElement) {
        StringBuffer buffer = new StringBuffer();
        ContextService.createContextElementPath((DevelopmentObject)contextElement, null, buffer, true);
        return buffer.toString();
    }

    public static String getMappingPath(ContextElementMapping mapping) {
        StringBuffer buffer = new StringBuffer();
        ContextService.createContextElementPath((DevelopmentObject)mapping.getMappedElement(), mapping.getControllerUsage(), buffer, true);
        return buffer.toString();
    }

    public static String getModelEntityPath(DevelopmentObject entity) {
        StringBuffer buffer = new StringBuffer();
        ContextService.createModelEntityPath(entity, buffer);
        return buffer.toString();
    }

    public static String isValidContextNodeName(String name, ContextNode parent) {
        String message = ContextService.isValidIdentifier(name);
        if (message != null) {
            return message;
        }
        message = ContextService.isUniqueWithinNode(name, parent);
        if (message != null) {
            return message;
        }
        return ContextService.isUniqueNodeWithinContext(name, (ContextNode)((Controller)parent.getMDO()).getContext());
    }

    public static String isValidContextAttributeName(String name, ContextNode parent) {
        String message = ContextService.isValidIdentifier(name);
        if (message != null) {
            return message;
        }
        return ContextService.isUniqueWithinNode(name, parent);
    }

    private static String isUniqueWithinNode(String name, ContextNode parent) {
        if (parent.hasAttribute(name)) {
            return TextPool.getInstance().getText(2002, name);
        }
        if (parent.hasChildNode(name)) {
            return TextPool.getInstance().getText(2002, name);
        }
        return null;
    }

    public static String isUniqueNodeWithinContext(String name, ContextNode node) {
        String message = null;
        ContextValueNode context = ((Controller)node.getMDO()).getContext();
        if (!context.getName().equalsIgnoreCase(name)) {
            if (!ContextService.isUniqueNodeWithinChildNodes(name, (ContextNode)context)) {
                message = TextPool.getInstance().getText(2002, name);
            }
        } else {
            message = TextPool.getInstance().getText(2002, name);
        }
        return message;
    }

    private static boolean isUniqueNodeWithinChildNodes(String name, ContextNode parent) {
        if (parent.getChildNodeCount() > 0) {
            if (parent.hasChildNode(name)) {
                return false;
            }
            AbstractContextNode[] childNodes = parent.getChildNodes();
            int i = 0;
            while (i < childNodes.length) {
                if (childNodes[i] instanceof ContextNode && !ContextService.isUniqueNodeWithinChildNodes(name, (ContextNode)childNodes[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static String isValidIdentifier(String name) {
        if (name.length() == 0) {
            return CoreTextPool.getInstance().getText(3, (Object)name);
        }
        if (!CheckServices.isValidIdentifier((String)name)) {
            return CoreTextPool.getInstance().getText(2, (Object)name);
        }
        return null;
    }

    private static void createContextElementPath(DevelopmentObject element, ControllerUsage controllerUsage, StringBuffer buffer, boolean absolutePath) {
        if (element != null) {
            if (absolutePath) {
                if (element instanceof Controller) {
                    if (controllerUsage != null && controllerUsage.hasComponentUsage()) {
                        buffer.append(controllerUsage.getComponentUsage().getName());
                        buffer.append(".");
                        buffer.append(element.getName());
                    } else {
                        buffer.append(element.getName());
                    }
                    return;
                }
                ContextService.createContextElementPath(element.getParent(), controllerUsage, buffer, absolutePath);
                if (!(element.getParent() instanceof Controller)) {
                    buffer.append(".");
                    buffer.append(element.getName());
                }
            } else if (!(element instanceof Controller)) {
                ContextService.createContextElementPath(element.getParent(), controllerUsage, buffer, absolutePath);
                if (!(element.getParent() instanceof Controller)) {
                    if (!(element.getParent().getParent() instanceof Controller)) {
                        buffer.append(".");
                    }
                    buffer.append(element.getName());
                }
            }
        }
    }

    private static void createModelEntityPath(DevelopmentObject element, StringBuffer buffer) {
        if (element != null) {
            if (element instanceof Model) {
                buffer.append(element.getName());
                return;
            }
            ContextService.createModelEntityPath(element.getParent(), buffer);
            buffer.append(".");
            buffer.append(element.getName());
        }
    }

    public static AbstractContextNode findContextNodeByName(String name, AbstractContextNode parent) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (parent.getName().equalsIgnoreCase(name)) {
            return parent;
        }
        if (parent instanceof ContextNode) {
            ContextNode parentNode = (ContextNode)parent;
            if (parentNode.hasChildNode(name)) {
                return parentNode.getChildNode(name);
            }
            AbstractContextNode[] childNodes = parentNode.getChildNodes();
            int i = 0;
            while (i < childNodes.length) {
                AbstractContextNode node = ContextService.findContextNodeByName(name, childNodes[i]);
                if (node != null) {
                    return node;
                }
                ++i;
            }
        }
        return null;
    }

    public static ContextAttribute findContextAttributeByName(String name, ContextNode parent) {
        if (parent != null && parent.hasAttribute(name)) {
            return parent.getAttribute(name);
        }
        return null;
    }

    public static List implementContext(ContextValueNode targetContext, ContextValueNode sourceContext, MetamodelClipboard clipboard) {
        ArrayList<ContextAttribute> excludedElements = new ArrayList<ContextAttribute>();
        ArrayList<Object> copiedElements = new ArrayList<Object>();
        ContextAttribute[] attributes = sourceContext.getAttributes();
        AbstractContextNode[] childNodes = sourceContext.getChildNodes();
        copiedElements.addAll(Arrays.asList(attributes));
        copiedElements.addAll(Arrays.asList(childNodes));
        if (copiedElements.size() > 0) {
            int i = 0;
            while (i < attributes.length) {
                if (ContextService.isUniqueWithinNode(attributes[i].getName(), (ContextNode)targetContext) != null) {
                    excludedElements.add(attributes[i]);
                }
                ++i;
            }
            ContextService.determineConflictingContextNodes(childNodes, targetContext, excludedElements);
            clipboard.copy((DevelopmentObject[])copiedElements.toArray(new ContextElement[copiedElements.size()]));
            ServicesRefactoring.pasteElements((ContextNode)targetContext, clipboard, new ControllerUsage[0], true, true);
        }
        return excludedElements;
    }

    private static void determineConflictingContextNodes(AbstractContextNode[] childNodes, ContextValueNode context, List conflictingNodes) {
        int i = 0;
        while (i < childNodes.length) {
            if (ContextService.isUniqueNodeWithinContext(childNodes[i].getName(), (ContextNode)context) != null) {
                conflictingNodes.add(childNodes[i]);
            } else if (childNodes[i] instanceof ContextNode && ((ContextNode)childNodes[i]).getChildNodeCount() > 0) {
                ContextService.determineConflictingContextNodes(((ContextNode)childNodes[i]).getChildNodes(), context, conflictingNodes);
            }
            ++i;
        }
    }

    public static List findElementForMapping(ContextElement targetElement, ContextNode parentSourceNode, String name, boolean isReverseMappingMode, List excludedElements) {
        ContextAttribute foundAttribute;
        List<AbstractContextNode> foundElements = new Vector();
        if (targetElement instanceof ContextModelNode) {
            foundElements = ContextService.findModelNodeByModelClass((ContextModelNode)targetElement, parentSourceNode, name);
        } else if (targetElement instanceof ContextModelAttribute) {
            foundElements = ContextService.findModelAttributeByModelProperty((ContextModelAttribute)targetElement, parentSourceNode, name);
        } else if (targetElement instanceof ContextValueNode) {
            AbstractContextNode element = ContextService.findContextNodeByName(name, (AbstractContextNode)parentSourceNode);
            if (element != null) {
                foundElements.add(element);
            }
        } else if (targetElement instanceof ContextRecursionNode) {
            AbstractContextNode element = ContextService.findContextNodeByName(name, (AbstractContextNode)parentSourceNode);
            if (element != null) {
                foundElements.add(element);
            }
        } else if (targetElement instanceof ContextValueAttribute && (foundAttribute = ContextService.findContextAttributeByName(name, parentSourceNode)) != null && (isReverseMappingMode || CheckLayerHelper.isValidType((DevelopmentObject)CheckLayerHelper.getType((ContextAttribute)((ContextAttribute)targetElement)), (DevelopmentObject)CheckLayerHelper.getType((ContextAttribute)foundAttribute)) == null)) {
            foundElements.add((AbstractContextNode)foundAttribute);
        }
        if (excludedElements != null) {
            foundElements.removeAll(excludedElements);
        }
        return foundElements;
    }

    public static List findModelNodeByModelClass(ContextModelNode targetNode, ContextNode parentSourceNode, String name) {
        ModelClass modelClassOfTarget = CheckLayerHelper.getModelClass((ContextModelNode)targetNode);
        return ContextService.findModelNodeByModelClass(modelClassOfTarget, parentSourceNode, name);
    }

    public static List findModelNodeByModelClass(ModelClass modelClass, ContextNode parentSourceNode, String name) {
        Vector<ContextModelNode> foundModelNodes = new Vector<ContextModelNode>();
        Vector<Object> resultList = new Vector<Object>();
        if (modelClass != null) {
            AbstractContextNode[] childNodes = parentSourceNode.getChildNodes();
            int i = 0;
            while (i < childNodes.length) {
                ContextModelNode modelNode;
                if (childNodes[i] instanceof ContextModelNode && modelClass == CheckLayerHelper.getModelClass((ContextModelNode)(modelNode = (ContextModelNode)childNodes[i]))) {
                    foundModelNodes.add(modelNode);
                }
                ++i;
            }
        }
        if (foundModelNodes.size() == 1) {
            resultList.addAll(foundModelNodes);
        } else if (foundModelNodes.isEmpty()) {
            AbstractContextNode foundNode = ContextService.findContextNodeByName(name, (AbstractContextNode)parentSourceNode);
            if (foundNode instanceof ContextModelNode) {
                resultList.add(foundNode);
            }
        } else {
            Iterator iter = foundModelNodes.iterator();
            while (iter.hasNext()) {
                ContextModelNode modelNode = (ContextModelNode)iter.next();
                AbstractContextNode foundNode = ContextService.findContextNodeByName(name, (AbstractContextNode)parentSourceNode);
                if (foundNode == null || foundNode != modelNode) continue;
                resultList.add(foundNode);
                break;
            }
            if (resultList.isEmpty()) {
                resultList.addAll(foundModelNodes);
            }
        }
        return resultList;
    }

    public static List findModelAttributeByModelProperty(ContextModelAttribute targetAttribute, ContextNode parentSourceNode, String name) {
        ModelClassProperty modelPropertyOfTarget = CheckLayerHelper.getReferencedProperty((ContextModelAttribute)targetAttribute);
        return ContextService.findModelAttributeByModelProperty((Property)modelPropertyOfTarget, parentSourceNode, name);
    }

    public static List findModelAttributeByModelProperty(Property modelProperty, ContextNode parentSourceNode, String name) {
        Vector<ContextModelAttribute> foundModelAttributes = new Vector<ContextModelAttribute>();
        Vector<Object> resultList = new Vector<Object>();
        if (modelProperty != null) {
            ContextAttribute[] childAttributes = parentSourceNode.getAttributes();
            int i = 0;
            while (i < childAttributes.length) {
                ContextModelAttribute modelAttribute;
                if (childAttributes[i] instanceof ContextModelAttribute && modelProperty == CheckLayerHelper.getReferencedProperty((ContextModelAttribute)(modelAttribute = (ContextModelAttribute)childAttributes[i]))) {
                    foundModelAttributes.add(modelAttribute);
                }
                ++i;
            }
        }
        if (foundModelAttributes.size() == 1) {
            resultList.addAll(foundModelAttributes);
        } else if (foundModelAttributes.isEmpty()) {
            ContextAttribute foundAttribute = ContextService.findContextAttributeByName(name, parentSourceNode);
            if (foundAttribute instanceof ContextModelAttribute) {
                resultList.add(foundAttribute);
            }
        } else {
            Iterator iter = foundModelAttributes.iterator();
            while (iter.hasNext()) {
                ContextModelAttribute modelAttribute = (ContextModelAttribute)iter.next();
                ContextAttribute foundAttribute = ContextService.findContextAttributeByName(name, parentSourceNode);
                if (foundAttribute == null || foundAttribute != modelAttribute) continue;
                resultList.add(foundAttribute);
                break;
            }
            if (resultList.isEmpty()) {
                resultList.addAll(foundModelAttributes);
            }
        }
        return resultList;
    }

    public static boolean isStructureElementNameMismatch(ContextValueNode parentNode, DtStructure structure) {
        if (parentNode != null && structure != null) {
            ContextAttribute[] attributes = parentNode.getAttributes();
            int i = 0;
            while (i < attributes.length) {
                ContextValueAttribute attribute = (ContextValueAttribute)attributes[i];
                if (!structure.hasStructureElement(attribute.getName())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static void setType(ContextValueAttribute attribute, DevelopmentObject type) {
        if (type == null) {
            ContextService.setType(attribute, (MetamodelServices.CompoundType)null);
        } else {
            ContextService.setType(attribute, new MetamodelServices.CompoundType(type));
        }
    }

    public static void setType(ContextValueAttribute attribute, MetamodelServices.CompoundType type) {
        MetamodelServices.setType((ContextValueAttribute)attribute, (MetamodelServices.CompoundType)type);
    }

    public static boolean isContextElementEnum(DevelopmentObjectEnum type) {
        return ContextService.isContextNodeEnum(type) || ContextService.isContextAttributeEnum(type);
    }

    public static boolean isContextNodeEnum(DevelopmentObjectEnum type) {
        return type == WebDynproDevelopmentObjectEnum.CONTEXTVALUENODE || type == WebDynproDevelopmentObjectEnum.CONTEXTMODELNODE || type == WebDynproDevelopmentObjectEnum.CONTEXTRECURSIONNODE;
    }

    public static boolean isContextAttributeEnum(DevelopmentObjectEnum type) {
        return type == WebDynproDevelopmentObjectEnum.CONTEXTVALUEATTRIBUTE || type == WebDynproDevelopmentObjectEnum.CONTEXTMODELATTRIBUTE;
    }

    private static class FilterContextNodes
    implements ISelectionValidator {
        private FilterContextNodes() {
        }

        public String isValid(Object value) {
            return value instanceof ContextNode ? null : TextPool.getInstance().getText(2001);
        }
    }

    private static class FilterContextAttributes
    implements ISelectionValidator {
        private FilterContextAttributes() {
        }

        public String isValid(Object value) {
            return value instanceof ContextAttribute ? null : TextPool.getInstance().getText(2000);
        }
    }
}

