/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor.component;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.service.controllereditor.NamingService;
import com.sap.ide.webdynpro.service.core.paste.IPasteHandler;
import com.sap.ide.webdynpro.service.core.paste.IPasteManager;
import com.sap.ide.webdynpro.service.core.paste.MDOPasteManager;
import com.sap.ide.webdynpro.service.core.paste.PasteHandlerException;
import com.sap.ide.webdynpro.service.core.paste.WebDynproObjectPasteHandler;
import java.util.Arrays;
import java.util.Vector;

public class ComponentInterfaceImplementationPasteHandler
extends WebDynproObjectPasteHandler {
    public MainDevelopmentObject[] getAffectedMDOs(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        if (newParent instanceof Component) {
            return new MainDevelopmentObject[]{(Component)newParent};
        }
        return super.getAffectedMDOs(clipboardObjects, newParent, scope, pasteManager);
    }

    public boolean refactorBeforeExecution(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) throws PasteHandlerException {
        if (clipboardObjects != null && clipboardObjects.length == 1 && clipboardObjects[0].getType() == WebDynproDevelopmentObjectEnum.COMPONENTINTERFACEIMPLEMENTATION) {
            String newName = null;
            String newPackage = null;
            if (clipboardObjects[0].getParent() != null) {
                ClipboardObject componentObject = clipboardObjects[0].getParent();
                newName = NamingService.getComponentInterfaceImplementationName(componentObject.getNewName());
                newPackage = componentObject.getNewPackage();
            } else if (newParent instanceof Component) {
                Component component = (Component)newParent;
                newName = NamingService.getComponentInterfaceImplementationName(component.getName());
                newPackage = component.getPackage();
            } else {
                return false;
            }
            clipboardObjects[0].setNewName(newName);
            clipboardObjects[0].setNewPackage(newPackage);
            this.addToClipboardObjectsHistory(clipboardObjects, pasteManager);
            ClipboardObject[] children = clipboardObjects[0].getChildren();
            int i = 0;
            while (i < children.length) {
                ClipboardObject child = children[i];
                IPasteHandler handler = pasteManager.getPasteHandler(child);
                ClipboardObject[] relevantChildren = MDOPasteManager.computeRelevantObjects((MetamodelClipboard)pasteManager.getClipboard(), (ClipboardObject[])children, (int)i);
                if (handler != null && relevantChildren != null && relevantChildren.length > 0) {
                    boolean cancelled;
                    boolean bl = cancelled = !handler.refactorBeforeExecution(relevantChildren, newParent, scope, pasteManager);
                    if (cancelled) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public void refactorAfterExecution(DevelopmentObject[] newObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        if (newObjects != null && newObjects.length == 1 && newObjects[0] instanceof ComponentInterfaceImplementation) {
            ComponentInterfaceImplementation cii = (ComponentInterfaceImplementation)newObjects[0];
            Vector<Controller> childObjects = new Vector<Controller>();
            Controller[] controllers = cii.getControllers();
            childObjects.addAll(Arrays.asList(controllers));
            DevelopmentObject[] children = childObjects.toArray(new DevelopmentObject[childObjects.size()]);
            int i = 0;
            while (i < children.length) {
                DevelopmentObject child = children[i];
                IPasteHandler handler = pasteManager.getPasteHandler(child);
                DevelopmentObject[] relevantChildren = MDOPasteManager.computeRelevantObjects((MetamodelClipboard)pasteManager.getClipboard(), (DevelopmentObject[])children, (int)i);
                if (handler != null && relevantChildren != null && relevantChildren.length > 0) {
                    handler.refactorAfterExecution(relevantChildren, newParent, scope, pasteManager);
                }
                ++i;
            }
        }
    }
}

