/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.service.controllereditor.ControllerPasteManager;
import com.sap.ide.webdynpro.service.core.paste.IPasteManager;
import com.sap.ide.webdynpro.service.core.paste.WebDynproObjectPasteHandler;
import java.util.HashMap;

public abstract class ControllerSubObjectPasteHandler
extends WebDynproObjectPasteHandler {
    protected HashMap mObjectMapping = new HashMap();

    public MainDevelopmentObject[] getAffectedMDOs(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        if (newParent instanceof Controller) {
            return new MainDevelopmentObject[]{(Controller)newParent};
        }
        return super.getAffectedMDOs(clipboardObjects, newParent, scope, pasteManager);
    }

    public boolean refactorBeforeExecution(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        if (clipboardObjects.length == 0) {
            return true;
        }
        DevelopmentObject newParentMDO = null;
        if (newParent instanceof DevelopmentObject) {
            newParentMDO = (DevelopmentObject)newParent;
        }
        if (pasteManager instanceof ControllerPasteManager) {
            ControllerPasteManager controllerPasteManager = (ControllerPasteManager)pasteManager;
            int i = 0;
            while (i < clipboardObjects.length) {
                ClipboardObject object = clipboardObjects[i];
                this.refactorSimple(object, newParentMDO);
                ++i;
            }
        }
        this.addToClipboardObjectsHistory(clipboardObjects, pasteManager, true, true);
        return true;
    }

    public void storeObjectMapping(ClipboardObject[] clipboardObjects) {
        int i = 0;
        while (i < clipboardObjects.length) {
            this.mObjectMapping.put(clipboardObjects[i].getNewName(), clipboardObjects[i].getOriginalKey());
            ++i;
        }
    }

    public void refactorAfterExecution(DevelopmentObject[] newObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        DevelopmentObject newParentDO = null;
        if (newParent instanceof DevelopmentObject) {
            newParentDO = (DevelopmentObject)newParent;
        }
        int i = 0;
        while (i < newObjects.length) {
            this.postProcess(newObjects[i], newParentDO);
            ++i;
        }
    }

    protected String generateNewPasteName(String name, DevelopmentObject[] existingObjects) {
        String newName = name;
        int counter = 0;
        boolean nameValid = false;
        while (!nameValid) {
            boolean objectExists = false;
            int i = 0;
            while (i < existingObjects.length) {
                if (existingObjects[i].getName().equals(newName)) {
                    newName = name + "_" + Integer.toString(++counter);
                    objectExists = true;
                    break;
                }
                ++i;
            }
            if (objectExists) continue;
            nameValid = true;
        }
        return newName;
    }

    protected abstract void refactorSimple(ClipboardObject var1, DevelopmentObject var2);

    protected abstract void postProcess(DevelopmentObject var1, DevelopmentObject var2);
}

