/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.project.ProjectService;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.clipboard.PasteProcess;
import com.sap.ide.webdynpro.service.controllereditor.ControllerSubObjectPasteHandler;
import com.sap.ide.webdynpro.service.controllereditor.ServiceControllerEditorPlugin;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.sap.ide.webdynpro.service.core.paste.IPasteHandler;
import com.sap.ide.webdynpro.service.core.paste.IPasteManager;
import com.sap.ide.webdynpro.service.core.paste.PasteException;
import com.sap.ide.webdynpro.service.core.paste.PasteHandlerException;
import com.sap.ide.webdynpro.service.core.paste.PasteLogDialog;
import com.sap.ide.webdynpro.service.core.paste.PasteManager;
import java.util.HashSet;

public class ControllerPasteManager
extends PasteManager {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paste(MetamodelClipboard clipboard, MetamodelObject newParent) {
        block18: {
            block17: {
                block16: {
                    super.paste(clipboard, newParent);
                    CoreTextPool pool = CoreTextPool.getInstance();
                    DevelopmentObject[] newObjects = new DevelopmentObject[]{};
                    int scope = this.computeScope(clipboard, newParent);
                    if (!clipboard.isPasteAllowed(newParent)) {
                        ServiceControllerEditorPlugin.internalError(((Object)((Object)this)).getClass(), "paste(MetamodelClipboard, MetamodelObject)", "Clipboard.isPasteAllowed() returned false. Operation is aborted.", null, false);
                        return;
                    }
                    if (!this.isSourceMetamodelValid(clipboard.getSourceMetamodel())) {
                        UIHelper.displayErrorMessage((String)CoreTextPool.getInstance().getText(414), (String)CoreTextPool.getInstance().getText(46));
                        return;
                    }
                    if (!ProjectService.checkMetamodelLanguage((Metamodel)this.getNewMetamodel(newParent))) {
                        UIHelper.displayErrorMessage((String)pool.getText(414), (String)pool.getText(47));
                        return;
                    }
                    PasteProcess pasteProcess = clipboard.initiatePaste(newParent);
                    ClipboardObject[] rootObjects = pasteProcess.getClipboardContent();
                    HashSet<MainDevelopmentObject> affectedMDOs = new HashSet<MainDevelopmentObject>();
                    MainDevelopmentObject mdo = null;
                    if (newParent instanceof DevelopmentObject) {
                        DevelopmentObject devObj = (DevelopmentObject)newParent;
                        while (true) {
                            if (devObj instanceof MainDevelopmentObject) {
                                mdo = (MainDevelopmentObject)devObj;
                                affectedMDOs.add(mdo);
                                break;
                            }
                            devObj = devObj.getParent();
                        }
                    }
                    if (!this.checkAffectedMDOs(affectedMDOs)) {
                        return;
                    }
                    IPasteHandler handler = this.getPasteHandler(rootObjects);
                    if (handler == null) {
                        return;
                    }
                    try {
                        block15: {
                            try {
                                boolean cancelled;
                                MainDevelopmentObject[] mdos = handler.getAffectedMDOs(rootObjects, newParent, scope, (IPasteManager)this);
                                boolean bl = cancelled = !handler.refactorBeforeExecution(rootObjects, newParent, scope, (IPasteManager)this);
                                if (!cancelled) break block15;
                                Object var14_14 = null;
                                break block16;
                            }
                            catch (PasteHandlerException e) {
                                this.displayPasteException((PasteException)e);
                                Object var14_15 = null;
                                this.closeSharedMonitor();
                                return;
                            }
                        }
                        if (handler instanceof ControllerSubObjectPasteHandler) {
                            ((ControllerSubObjectPasteHandler)handler).storeObjectMapping(rootObjects);
                        }
                        if ((newObjects = this.pasteExecute(pasteProcess)) == null) break block17;
                        if (newObjects.length == 0) {
                            break block17;
                        }
                        handler.refactorAfterExecution(newObjects, newParent, scope, (IPasteManager)this);
                        if (!this.getLog().isEmpty()) {
                            new PasteLogDialog(this.getLog()).open();
                        }
                        break block18;
                    }
                    catch (Throwable throwable) {
                        Object var14_18 = null;
                        this.closeSharedMonitor();
                        throw throwable;
                    }
                }
                this.closeSharedMonitor();
                return;
            }
            Object var14_16 = null;
            this.closeSharedMonitor();
            return;
        }
        Object var14_17 = null;
        this.closeSharedMonitor();
    }

    private IPasteHandler getPasteHandler(ClipboardObject[] objects) {
        if (objects == null || objects.length == 0) {
            return null;
        }
        ClipboardObject object = objects[0];
        int i = 1;
        while (i < objects.length) {
            if (!object.getType().equals(objects[i].getType())) {
                return null;
            }
            ++i;
        }
        return this.getPasteHandler(object);
    }
}

