/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.AbstractView;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.metamodel.webdynpro.plugin.WebDynproRootManager;
import com.sap.ide.webdynpro.service.controllereditor.ControllerEditorInput;
import com.sap.ide.webdynpro.service.controllereditor.ServiceControllerEditorPlugin;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectElementFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IMemento;

public class ControllerElementFactory
extends DevelopmentObjectElementFactory {
    public static final String FACTORY_ID = "com.sap.ide.webdynpro.service.controllereditor.ControllerElementFactory";
    public static final String KEY_COMPONENT = "component";
    public static final String KEY_TYPE = "type";
    public static final String KEY_COMPONENT_INTERFACE_DEFINITION = "componentInterfaceDefinition";
    public static final String KEY_CONTROLLER_PACKAGE = "controllerPackage";

    public IAdaptable createElement(IMemento memento) {
        String projectName = memento.getString("project");
        if (projectName == null) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null || !project.isAccessible()) {
            return null;
        }
        String packageName = memento.getString("package");
        if (packageName == null) {
            return null;
        }
        String objectName = memento.getString("developmentObject");
        if (objectName == null) {
            return null;
        }
        String componentName = memento.getString(KEY_COMPONENT);
        String componentInterfaceDefinitionName = null;
        if (componentName == null && (componentInterfaceDefinitionName = memento.getString(KEY_COMPONENT_INTERFACE_DEFINITION)) == null) {
            return null;
        }
        String controllerType = memento.getString(KEY_TYPE);
        if (controllerType == null) {
            return null;
        }
        String controllerPackage = memento.getString(KEY_CONTROLLER_PACKAGE);
        if (controllerPackage == null) {
            return null;
        }
        Metamodel metamodel = MetamodelManager.getMetamodel((String)projectName);
        WebDynproRoot root = WebDynproRootManager.getWebDynproRoot((Metamodel)metamodel);
        Component component = null;
        ComponentInterfaceDefinition componentInterfaceDefinition = null;
        if (componentName != null) {
            try {
                component = root.getComponent(packageName, componentName);
            }
            catch (LoadException e) {
                ServiceControllerEditorPlugin.internalError(((Object)((Object)this)).getClass(), "createElement(IMemento)", e.getMessage(), e, true);
                return null;
            }
            if (component == null) {
                return null;
            }
        } else {
            try {
                componentInterfaceDefinition = root.getComponentInterfaceDefinition(packageName, componentInterfaceDefinitionName);
            }
            catch (LoadException e) {
                ServiceControllerEditorPlugin.internalError(((Object)((Object)this)).getClass(), "createElement(IMemento)", e.getMessage(), e, true);
                return null;
            }
            if (componentInterfaceDefinition == null) {
                return null;
            }
        }
        if (controllerType.equals(ControllerTypeEnum.COMPONENT.toString())) {
            return new ControllerEditorInput(component);
        }
        if (controllerType.equals(ControllerTypeEnum.COMPONENT_CONFIGURATION.toString())) {
            if (component != null) {
                if (component.getComponentInterface() == null) {
                    return null;
                }
                if (component.getComponentInterface().getConfigurationController() == null) {
                    return null;
                }
                return new ControllerEditorInput(component.getComponentInterface().getConfigurationController());
            }
            if (componentInterfaceDefinition.getInterfaceController() == null) {
                return null;
            }
            return new ControllerEditorInput(componentInterfaceDefinition.getInterfaceController());
        }
        if (controllerType.equals(ControllerTypeEnum.COMPONENT_INTERFACE.toString())) {
            if (component != null) {
                if (component.getComponentInterface() == null) {
                    return null;
                }
                return new ControllerEditorInput(component.getComponentInterface());
            }
            return new ControllerEditorInput(componentInterfaceDefinition);
        }
        if (controllerType.equals(ControllerTypeEnum.INTERFACE_VIEW.toString())) {
            if (component != null) {
                ComponentInterfaceImplementation componentInterfaceImplementation = component.getComponentInterface();
                if (componentInterfaceImplementation == null) {
                    return null;
                }
                InterfaceView interfaceView = componentInterfaceImplementation.getInterfaceView(controllerPackage, objectName);
                if (interfaceView == null) {
                    return null;
                }
                return new ControllerEditorInput(interfaceView);
            }
            InterfaceView interfaceView = componentInterfaceDefinition.getInterfaceView(controllerPackage, objectName);
            if (interfaceView == null) {
                return null;
            }
            return new ControllerEditorInput(interfaceView);
        }
        if (controllerType.equals(ControllerTypeEnum.CUSTOM.toString())) {
            Controller controller = component.getController(controllerPackage, objectName);
            if (controller == null) {
                return null;
            }
            return new ControllerEditorInput(controller);
        }
        if (controllerType.equals(ControllerTypeEnum.VIEW.toString())) {
            View view = component.getView(controllerPackage, objectName);
            if (view == null) {
                return null;
            }
            return new ControllerEditorInput((AbstractView)view);
        }
        return null;
    }
}

