/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor;

import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterface;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.AbstractView;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.webdynpro.service.controllereditor.ServiceControllerEditorPlugin;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectEditorInput;
import org.eclipse.ui.IMemento;

public class ControllerEditorInput
extends DevelopmentObjectEditorInput {
    private static final TextPool msTextPool = TextPool.getInstance();
    private Controller mController = null;
    private AbstractView mAbstractView = null;
    private Component mComponent = null;
    private ComponentInterface mComponentInterface = null;

    public ControllerEditorInput(Controller controller) {
        super((DevelopmentObject)controller);
        this.mController = controller;
        if (this.mComponent == null) {
            if (this.mController == null) {
                ServiceControllerEditorPlugin.internalError(((Object)((Object)this)).getClass(), "ControllerEditorInput(Controller)", "Object has no controller", new Exception(), false);
                return;
            }
            DevelopmentObject parent = this.mController.getParent();
            if (parent instanceof Component) {
                this.mComponent = (Component)parent;
            } else if (parent instanceof ComponentInterface) {
                this.mComponentInterface = (ComponentInterface)parent;
                this.mComponent = (Component)this.mComponentInterface.getParent();
            }
        }
    }

    public ControllerEditorInput(AbstractView abstractView) {
        this(abstractView.getViewController());
        this.mAbstractView = abstractView;
    }

    public ControllerEditorInput(InterfaceView interfaceView) {
        this(interfaceView.getViewController());
        this.mAbstractView = interfaceView;
    }

    public ControllerEditorInput(Component component) {
        this(component.getComponentController());
        this.mComponent = component;
    }

    public ControllerEditorInput(ComponentInterfaceImplementation componentInterfaceImplementation) {
        this(componentInterfaceImplementation.getInterfaceController());
        DevelopmentObject parentObject = componentInterfaceImplementation.getParent();
        if (parentObject instanceof Component) {
            this.mComponent = (Component)parentObject;
        }
    }

    public ControllerEditorInput(ComponentInterfaceDefinition componentInterfaceDefinition) {
        this(componentInterfaceDefinition.getInterfaceController());
    }

    public String getToolTipText() {
        if (!this.mController.isValid()) {
            return "";
        }
        if (this.mController.getType().equals(ControllerTypeEnum.COMPONENT)) {
            return ServicesEclipse.getEclipseProject((DevelopmentObject)this.mController).getName() + "/" + this.mComponent.getName() + " - " + msTextPool.getText(583);
        }
        if (this.mController.getType().equals(ControllerTypeEnum.COMPONENT_INTERFACE)) {
            if (this.mComponent != null) {
                return ServicesEclipse.getEclipseProject((DevelopmentObject)this.mController).getName() + "/" + this.mComponent.getName() + "/" + this.mComponent.getComponentInterface().getName() + " - " + msTextPool.getText(584);
            }
            if (this.mComponentInterface != null) {
                return ServicesEclipse.getEclipseProject((DevelopmentObject)this.mController).getName() + "/" + this.mComponentInterface.getName() + " - " + msTextPool.getText(585);
            }
            return "";
        }
        if (this.mController.getType().equals(ControllerTypeEnum.COMPONENT_CONFIGURATION)) {
            if (this.mComponent != null) {
                return ServicesEclipse.getEclipseProject((DevelopmentObject)this.mController).getName() + "/" + this.mComponent.getName() + "/" + this.mComponent.getComponentInterface().getConfigurationController().getName() + " - " + msTextPool.getText(586);
            }
            if (this.mComponentInterface != null) {
                return ServicesEclipse.getEclipseProject((DevelopmentObject)this.mController).getName() + "/" + this.mComponentInterface.getName() + " - " + msTextPool.getText(587);
            }
            return "";
        }
        if (this.mController.getType().equals(ControllerTypeEnum.INTERFACE_VIEW)) {
            if (this.mComponent != null) {
                return ServicesEclipse.getEclipseProject((DevelopmentObject)this.mController).getName() + "/" + this.mComponent.getName() + "/" + this.mAbstractView.getName() + " - " + msTextPool.getText(588);
            }
            if (this.mComponentInterface != null) {
                return ServicesEclipse.getEclipseProject((DevelopmentObject)this.mController).getName() + "/" + this.mComponentInterface.getName() + "/" + this.mAbstractView.getName() + " - " + msTextPool.getText(588);
            }
            return "";
        }
        if (this.mController.getType().equals(ControllerTypeEnum.VIEW)) {
            return ServicesEclipse.getEclipseProject((DevelopmentObject)this.mController).getName() + "/" + this.mComponent.getName() + "/" + this.mAbstractView.getName() + " - " + msTextPool.getText(589);
        }
        return ServicesEclipse.getEclipseProject((DevelopmentObject)this.mController).getName() + "/" + this.mComponent.getName() + "/" + this.mController.getName() + " - " + msTextPool.getText(590);
    }

    public Controller getController() {
        return this.mController;
    }

    public AbstractView getView() {
        return this.mAbstractView;
    }

    public Component getComponent() {
        return this.mComponent;
    }

    public ComponentInterface getComponentInterface() {
        return this.mComponentInterface;
    }

    public String getEditorId() {
        return "com.sap.ide.webdynpro.editors.controller";
    }

    public String getFactoryId() {
        return "com.sap.ide.webdynpro.service.controllereditor.ControllerElementFactory";
    }

    public void saveState(IMemento memento) {
        if (!this.mController.isValid()) {
            return;
        }
        super.saveState(memento);
        if (this.mComponent != null) {
            memento.putString("package", this.mComponent.getPackage());
            memento.putString("controllerPackage", this.mController.getPackage());
            memento.putString("component", this.mComponent.getName());
        } else if (this.mComponentInterface instanceof ComponentInterfaceDefinition) {
            memento.putString("package", ((ComponentInterfaceDefinition)this.mComponentInterface).getPackage());
            memento.putString("componentInterfaceDefinition", this.mComponentInterface.getName());
        }
        memento.putString("type", this.mController.getType().toString());
    }

    public String getReadOnlyText() {
        boolean writable = !this.mController.isReadOnly();
        boolean allInSameState = true;
        if (!(this.mController.getType().equals(ControllerTypeEnum.COMPONENT) || this.mController.getType().equals(ControllerTypeEnum.COMPONENT_INTERFACE) || this.mController.getType().equals(ControllerTypeEnum.COMPONENT_CONFIGURATION))) {
            if (this.mController.getType().equals(ControllerTypeEnum.INTERFACE_VIEW)) {
                allInSameState = this.mAbstractView != null ? this.mController.isReadOnly() == this.mAbstractView.isReadOnly() : false;
            } else if (this.mController.getType().equals(ControllerTypeEnum.VIEW)) {
                allInSameState = this.mAbstractView != null ? this.mController.isReadOnly() == this.mAbstractView.isReadOnly() : false;
            } else if (this.mController.getType().equals(ControllerTypeEnum.CUSTOM)) {
                // empty if block
            }
        }
        if (!allInSameState) {
            return msTextPool.getText(165);
        }
        if (writable) {
            return msTextPool.getText(164);
        }
        return msTextPool.getText(163);
    }

    public String getEditorName() {
        String editorName = "";
        if (this.getController().getType().equals(ControllerTypeEnum.CUSTOM)) {
            editorName = this.getController().getName();
        } else if (this.getController().getType().equals(ControllerTypeEnum.VIEW)) {
            editorName = this.getController().getView().getName();
        } else if (this.getController().getType().equals(ControllerTypeEnum.COMPONENT)) {
            editorName = this.getController().getName();
        } else if (this.getController().getType().equals(ControllerTypeEnum.COMPONENT_CONFIGURATION) | this.getController().getType().equals(ControllerTypeEnum.COMPONENT_INTERFACE)) {
            editorName = this.getController().getName();
        } else if (this.getController().getType().equals(ControllerTypeEnum.INTERFACE_VIEW)) {
            editorName = this.getController().getView().getName();
        }
        return editorName;
    }
}

