/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.controllereditor;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.metamodel.webdynpro.plugin.WebDynproRootManager;
import com.sap.ide.webdynpro.service.controllereditor.ComponentControllerUsageEditorInput;
import com.sap.ide.webdynpro.service.controllereditor.ServiceControllerEditorPlugin;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectElementFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IMemento;

public class ComponentControllerUsageElementFactory
extends DevelopmentObjectElementFactory {
    public static final String FACTORY_ID = "com.sap.ide.webdynpro.service.controllereditor.ComponentControllerUsageElementFactory";
    public static final String KEY_COMPONENT = "component";
    public static final String KEY_COMPONENT_USAGE = "componentUsage";

    public IAdaptable createElement(IMemento memento) {
        String projectName = memento.getString("project");
        if (projectName == null) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null || !project.isAccessible()) {
            return null;
        }
        String packageName = memento.getString("package");
        if (packageName == null) {
            return null;
        }
        String objectName = memento.getString("developmentObject");
        if (objectName == null) {
            return null;
        }
        String componentName = memento.getString(KEY_COMPONENT);
        if (componentName == null) {
            return null;
        }
        String componentUsageName = memento.getString(KEY_COMPONENT_USAGE);
        if (componentUsageName == null) {
            return null;
        }
        Metamodel metamodel = MetamodelManager.getMetamodel((String)projectName);
        WebDynproRoot root = WebDynproRootManager.getWebDynproRoot((Metamodel)metamodel);
        Component component = null;
        try {
            component = root.getComponent(packageName, componentName);
        }
        catch (LoadException e) {
            ServiceControllerEditorPlugin.internalError(((Object)((Object)this)).getClass(), "createElement(IMemento)", e.getMessage(), e, true);
            return null;
        }
        if (component == null) {
            return null;
        }
        ComponentUsage componentUsage = component.getComponentUsage(componentUsageName);
        if (componentUsage == null) {
            return null;
        }
        ComponentControllerUsage componentControllerUsage = componentUsage.getComponentControllerUsage(objectName);
        if (componentControllerUsage == null) {
            return null;
        }
        return new ComponentControllerUsageEditorInput(componentControllerUsage);
    }
}

