/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedChar;

public class WaitableChar
extends SynchronizedChar {
    public WaitableChar(char initialValue) {
        super(initialValue);
    }

    public WaitableChar(char initialValue, Object lock) {
        super(initialValue, lock);
    }

    public char set(char newValue) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.set(newValue);
        }
    }

    public boolean commit(char assumedValue, char newValue) {
        Object object = this.lock_;
        synchronized (object) {
            boolean success = super.commit(assumedValue, newValue);
            if (success) {
                this.lock_.notifyAll();
            }
            return success;
        }
    }

    public char add(char amount) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.add(amount);
        }
    }

    public char subtract(char amount) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.subtract(amount);
        }
    }

    public char multiply(char factor) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.multiply(factor);
        }
    }

    public char divide(char factor) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.divide(factor);
        }
    }

    public void whenEqual(char c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ != c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenNotEqual(char c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ == c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenLessEqual(char c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ > c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenLess(char c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ >= c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenGreaterEqual(char c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ < c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenGreater(char c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ <= c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }
}

