/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import java.math.BigInteger;

public class PolicyConstraints
extends V3Extension {
    int b = -1;
    int a = -1;
    public static final ObjectID oid = new ObjectID("2.5.29.36", "PolicyConstraints");

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != -1) {
            stringBuffer.append("require explicit policy: " + this.a + "\n");
        }
        if (this.b != -1) {
            stringBuffer.append("inhibit policy mapping: " + this.b + "\n");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        boolean bl = true;
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a != -1) {
            sEQUENCE.addComponent(new CON_SPEC(0, new INTEGER(this.a), bl));
        }
        if (this.b != -1) {
            sEQUENCE.addComponent(new CON_SPEC(1, new INTEGER(this.b), bl));
        }
        return sEQUENCE;
    }

    public void setRequireExplicitPolicy(int n) {
        this.a = n;
    }

    public void setInhibitPolicyMapping(int n) {
        this.b = n;
    }

    public void setInhibitExplicitPolicy(int n) {
        this.setInhibitPolicyMapping(n);
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            if (!aSN1Object.isA(ASN.SEQUENCE)) {
                throw new X509ExtensionException("PolicyConstraints has to be a SEQUENCE!");
            }
            int n = aSN1Object.countComponents();
            if (n > 2) {
                throw new X509ExtensionException("PolicyConstraints cannot have more than 2 components!");
            }
            int n2 = 0;
            while (n2 < aSN1Object.countComponents()) {
                CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(n2);
                if (cON_SPEC.isImplicitlyTagged()) {
                    cON_SPEC.forceImplicitlyTagged(ASN.INTEGER);
                }
                switch (cON_SPEC.getAsnType().getTag()) {
                    case 0: {
                        this.a = ((BigInteger)((ASN1Object)cON_SPEC.getValue()).getValue()).intValue();
                        break;
                    }
                    case 1: {
                        this.b = ((BigInteger)((ASN1Object)cON_SPEC.getValue()).getValue()).intValue();
                        break;
                    }
                }
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            throw new X509ExtensionException(exception.toString());
        }
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public int getRequireExplicitPolicy() {
        return this.a;
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public int getInhibitPolicyMapping() {
        return this.b;
    }

    public int getInhibitExplicitPolicy() {
        return this.getInhibitPolicyMapping();
    }
}

