/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.utils.Util;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Random;

public final class NumberTheory {
    private static final long c = 58642669L;
    private static final long d = 111546435L;
    private static final BigInteger a;
    private static BigInteger[] b;
    public static final BigInteger TWO;
    public static final BigInteger ONE;
    public static final BigInteger ZERO;

    public static BigInteger nextPrime(BigInteger bigInteger) {
        bigInteger = bigInteger.setBit(0);
        while (!NumberTheory.isProbablePrime(bigInteger)) {
            bigInteger = bigInteger.add(TWO);
        }
        return bigInteger;
    }

    public static boolean millerRabin(BigInteger bigInteger) {
        int n = bigInteger.bitLength();
        int n2 = n <= 500 ? (n <= 100 ? 27 : (n <= 150 ? 18 : (n <= 200 ? 15 : (n <= 250 ? 12 : (n <= 300 ? 9 : (n <= 350 ? 8 : (n <= 400 ? 7 : 6))))))) : (n <= 600 ? 5 : (n <= 800 ? 4 : (n <= 1250 ? 3 : 2)));
        BigInteger bigInteger2 = BigInteger.valueOf(1L);
        BigInteger bigInteger3 = BigInteger.valueOf(2L);
        BigInteger bigInteger4 = bigInteger.subtract(bigInteger2);
        int n3 = bigInteger4.getLowestSetBit();
        BigInteger bigInteger5 = bigInteger4.shiftRight(n3);
        BigInteger bigInteger6 = bigInteger.subtract(BigInteger.valueOf(4L));
        Random random = new Random();
        int n4 = 1;
        while (n4 <= n2) {
            BigInteger bigInteger7 = new BigInteger(n + 4, random);
            BigInteger bigInteger8 = (bigInteger7 = bigInteger7.mod(bigInteger6).add(bigInteger3)).modPow(bigInteger5, bigInteger);
            if (bigInteger8.compareTo(bigInteger2) != 0 && bigInteger8.compareTo(bigInteger4) != 0) {
                int n5 = 1;
                while (n5 <= n3 - 1 && (n5 == 1 || bigInteger8.compareTo(bigInteger4) != 0)) {
                    if ((bigInteger8 = bigInteger8.modPow(bigInteger3, bigInteger)).compareTo(bigInteger2) == 0) {
                        return false;
                    }
                    ++n5;
                }
                if (bigInteger8.compareTo(bigInteger4) != 0) {
                    return false;
                }
            }
            ++n4;
        }
        return true;
    }

    public static boolean isProbablePrime(BigInteger bigInteger) {
        if (bigInteger.compareTo(ONE) <= 0) {
            return false;
        }
        if (NumberTheory.hasSmallFactors(bigInteger)) {
            return false;
        }
        return NumberTheory.millerRabin(bigInteger);
    }

    public static boolean hasSmallFactors(BigInteger bigInteger) {
        if (!bigInteger.testBit(0)) {
            return true;
        }
        if (bigInteger.bitLength() < 59) {
            return false;
        }
        long l = bigInteger.mod(a).longValue();
        int n = (int)(l % 111546435L);
        if (n % 3 == 0 || n % 5 == 0 || n % 7 == 0 || n % 11 == 0 || n % 13 == 0 || n % 17 == 0 || n % 19 == 0 || n % 23 == 0) {
            return true;
        }
        int n2 = (int)(l % 58642669L);
        if (n2 % 29 == 0 || n2 % 31 == 0 || n2 % 37 == 0 || n2 % 41 == 0 || n2 % 43 == 0) {
            return true;
        }
        int n3 = 13;
        while (n3 < b.length) {
            if (bigInteger.mod(b[n3]).signum() == 0) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static BigInteger getStrongPrime(int n, Random random) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = ZERO.setBit(511 + 128 * n);
        BigDecimal bigDecimal = new BigDecimal(Math.sqrt(2.0));
        BigInteger bigInteger3 = new BigDecimal(bigInteger2).multiply(bigDecimal).toBigInteger();
        while ((bigInteger = new BigInteger(512 + 128 * n, random)).compareTo(bigInteger3) == -1) {
        }
        BigInteger bigInteger4 = NumberTheory.nextPrime(new BigInteger(101, random));
        BigInteger bigInteger5 = NumberTheory.nextPrime(new BigInteger(101, random));
        BigInteger bigInteger6 = bigInteger5.modInverse(bigInteger4).multiply(bigInteger5).subtract(bigInteger4.modInverse(bigInteger5).multiply(bigInteger4));
        BigInteger bigInteger7 = bigInteger4.multiply(bigInteger5);
        BigInteger bigInteger8 = bigInteger.add(bigInteger6.subtract(bigInteger).mod(bigInteger7));
        while (!NumberTheory.isProbablePrime(bigInteger8)) {
            bigInteger8 = bigInteger8.add(bigInteger7);
        }
        return bigInteger8;
    }

    public static int gcd(int n, int n2) {
        while (n2 != 0) {
            int n3 = n % n2;
            n = n2;
            n2 = n3;
        }
        return n;
    }

    public static int[] extGcd(int n, int n2) {
        if (n2 == 0) {
            int[] nArray = new int[3];
            nArray[0] = n;
            nArray[1] = 1;
            return nArray;
        }
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 1;
        while (n2 > 0) {
            int n7 = n / n2;
            int n8 = n - n7 * n2;
            int n9 = n3 - n7 * n4;
            int n10 = n5 - n7 * n6;
            n = n2;
            n2 = n8;
            n3 = n4;
            n4 = n9;
            n5 = n6;
            n6 = n10;
        }
        return new int[]{n, n3, n5};
    }

    private NumberTheory() {
    }

    static {
        ZERO = BigInteger.valueOf(0L);
        ONE = BigInteger.valueOf(1L);
        TWO = BigInteger.valueOf(2L);
        a = BigInteger.valueOf(6541380665835015L);
        String string = "AAMABQAHAAsADQARABMAFwAdAB8AJQApACsALwA1ADsAPQBDAEcASQBPAFMAWQBhAGUAZwBrAG0AcQB/AIMAiQCLAJUAlwCdAKMApwCtALMAtQC/AMEAxQDHANMA3wDjAOUA6QDvAPEA+wEBAQcBDQEPARUBGQEbASUBMwE3ATkBPQFLAVEBWwFdAWEBZwFvAXUBewF/AYUBjQGRAZkBowGlAa8BsQG3AbsBwQHJAc0BzwHTAd8B5wHrAfMB9wH9AgkCCwIdAiMCLQIzAjkCOwJBAksCUQJXAlkCXwJlAmkCawJ3AoECgwKHAo0CkwKVAqECpQKrArMCvQLFAs8C1w==";
        byte[] byArray = Util.decodeByteArray(string);
        int n = byArray.length >> 1;
        b = new BigInteger[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = byArray[n3] & 0xFF;
            n4 = n4 << 8 | byArray[n3 + 1] & 0xFF;
            NumberTheory.b[n2] = BigInteger.valueOf(n4);
            ++n2;
            n3 += 2;
        }
    }
}

