/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.utils.InternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;

public class DHPrivateKey
extends PrivateKeyInfo
implements Serializable,
javax.crypto.interfaces.DHPrivateKey {
    private DHParameterSpec c;
    private BigInteger a;
    private transient ASN1 b;

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.encode());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DH private key");
        stringBuffer.append(this.c == null ? ":\n" : " (" + this.c.getP().bitLength() + " bits):\n");
        stringBuffer.append("x: " + this.a.toString(16) + "\n");
        if (this.c != null) {
            stringBuffer.append("key parameters:\n" + this.c.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        try {
            this.decode(new ASN1(objectInputStream).toByteArray());
            return;
        }
        catch (Exception exception) {
            throw new IOException("Unable to restore Certificate: " + exception.toString());
        }
    }

    public int hashCode() {
        return this.a.hashCode() ^ this.c.hashCode();
    }

    public BigInteger getX() {
        return this.a;
    }

    public DHParameterSpec getParams() {
        return this.c;
    }

    public String getAlgorithm() {
        return "DH";
    }

    public byte[] encode() {
        return this.b.toByteArray();
    }

    protected void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.b = new ASN1(byArray);
            this.a = (BigInteger)this.b.toASN1Object().getValue();
            ASN1Object aSN1Object = this.private_key_algorithm.getParameter();
            BigInteger bigInteger = (BigInteger)aSN1Object.getComponentAt(0).getValue();
            BigInteger bigInteger2 = (BigInteger)aSN1Object.getComponentAt(1).getValue();
            if (aSN1Object.countComponents() > 2) {
                int n = ((BigInteger)aSN1Object.getComponentAt(2).getValue()).intValue();
                this.c = new DHParameterSpec(bigInteger, bigInteger2, n);
                return;
            }
            this.c = new DHParameterSpec(bigInteger, bigInteger2);
            return;
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No DH Private Key: " + exception.toString());
        }
    }

    private void b() {
        try {
            this.b = new ASN1(new INTEGER(this.a));
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(this.c.getP()));
            sEQUENCE.addComponent(new INTEGER(this.c.getG()));
            if (this.c.getL() > 0) {
                sEQUENCE.addComponent(new INTEGER(this.c.getL()));
            }
            this.private_key_algorithm = (AlgorithmID)AlgorithmID.dhKeyAgreement.clone();
            this.private_key_algorithm.setParameter(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new InternalErrorException(codingException);
        }
        this.createPrivateKeyInfo();
    }

    public DHPrivateKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }

    public DHPrivateKey(DHPrivateKeySpec dHPrivateKeySpec) {
        this.a = dHPrivateKeySpec.getX();
        this.c = new DHParameterSpec(dHPrivateKeySpec.getP(), dHPrivateKeySpec.getG());
        this.b();
    }

    public DHPrivateKey(BigInteger bigInteger, DHParameterSpec dHParameterSpec) {
        this.a = bigInteger;
        this.c = dHParameterSpec;
        this.b();
    }

    public DHPrivateKey(InputStream inputStream) throws InvalidKeyException, IOException {
        super(inputStream);
    }

    public DHPrivateKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }
}

